/*
 * Decompiled with CFR 0.152.
 */
package Commands;

import Commands.BlockContext;
import Robo.Ponto;
import virbot4u.JanelaPonto;

public class Nodo {
    private String data;
    private Nodo left;
    private Nodo right;
    private int line;

    public Nodo(String data) {
        this.data = data;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public Nodo getLeft() {
        return this.left;
    }

    public void setLeft(Nodo left) {
        this.left = left;
    }

    public Nodo getRight() {
        return this.right;
    }

    public void setRight(Nodo right) {
        this.right = right;
    }

    public float value(BlockContext inThisContext, int line) {
        this.line = line;
        return this.logicalValue(this, inThisContext);
    }

    private float logicalValue(Nodo no, BlockContext inThisContext) {
        if (no.getData().equals("&")) {
            if (((int)this.logicalValue(no.getLeft(), inThisContext) & (int)this.logicalValue(no.getRight(), inThisContext)) == 0) {
                return 0.0f;
            }
            return 1.0f;
        }
        if (no.getData().equals("|")) {
            if (((int)this.logicalValue(no.getLeft(), inThisContext) | (int)this.logicalValue(no.getRight(), inThisContext)) == 0) {
                return 0.0f;
            }
            return 1.0f;
        }
        if (no.getData().equals("^")) {
            if (this.logicalValue(no.getLeft(), inThisContext) != 0.0f && this.logicalValue(no.getRight(), inThisContext) == 0.0f || this.logicalValue(no.getLeft(), inThisContext) == 0.0f && this.logicalValue(no.getRight(), inThisContext) != 0.0f) {
                return 0.0f;
            }
            return 1.0f;
        }
        return this.conditionalValue(no, inThisContext);
    }

    private float conditionalValue(Nodo no, BlockContext inThisContext) {
        System.out.println(no.getData());
        if (no.getData().equals("<")) {
            if (this.conditionalValue(no.getLeft(), inThisContext) < this.conditionalValue(no.getRight(), inThisContext)) {
                return 1.0f;
            }
            return 0.0f;
        }
        if (no.getData().equals(">")) {
            System.out.println(no.getData());
            if (this.conditionalValue(no.getLeft(), inThisContext) > this.conditionalValue(no.getRight(), inThisContext)) {
                return 1.0f;
            }
            return 0.0f;
        }
        if (no.getData().equals("<=")) {
            if (this.conditionalValue(no.getLeft(), inThisContext) <= this.conditionalValue(no.getRight(), inThisContext)) {
                return 1.0f;
            }
            return 0.0f;
        }
        if (no.getData().equals(">=")) {
            if (this.conditionalValue(no.getLeft(), inThisContext) >= this.conditionalValue(no.getRight(), inThisContext)) {
                return 1.0f;
            }
            return 0.0f;
        }
        if (no.getData().equals("==")) {
            if (this.conditionalValue(no.getLeft(), inThisContext) == this.conditionalValue(no.getRight(), inThisContext)) {
                return 1.0f;
            }
            return 0.0f;
        }
        if (no.getData().equals("<>")) {
            if (this.conditionalValue(no.getLeft(), inThisContext) != this.conditionalValue(no.getRight(), inThisContext)) {
                return 1.0f;
            }
            return 0.0f;
        }
        return this.calcValue(no, inThisContext).floatValue();
    }

    private Float calcValue(Nodo no, BlockContext inThisContext) {
        if (this.isDigit(no.getData())) {
            return Float.valueOf(Integer.parseInt(no.getData()));
        }
        if (no.getData().equals("+")) {
            return Float.valueOf(this.calcValue(no.getLeft(), inThisContext).floatValue() + this.calcValue(no.getRight(), inThisContext).floatValue());
        }
        if (no.getData().equals("-")) {
            return Float.valueOf(this.calcValue(no.getLeft(), inThisContext).floatValue() - this.calcValue(no.getRight(), inThisContext).floatValue());
        }
        if (no.getData().equals("*")) {
            return Float.valueOf(this.calcValue(no.getLeft(), inThisContext).floatValue() * this.calcValue(no.getRight(), inThisContext).floatValue());
        }
        if (no.getData().equals("/")) {
            return Float.valueOf(this.calcValue(no.getLeft(), inThisContext).floatValue() / this.calcValue(no.getRight(), inThisContext).floatValue());
        }
        if (no.getData().equals("**")) {
            return Float.valueOf((float)Math.pow(this.calcValue(no.getLeft(), inThisContext).floatValue(), this.calcValue(no.getRight(), inThisContext).floatValue()));
        }
        if (no.getData().equals("%")) {
            return Float.valueOf(this.calcValue(no.getLeft(), inThisContext).floatValue() % this.calcValue(no.getRight(), inThisContext).floatValue());
        }
        if (no.getData().equals("NEG")) {
            return Float.valueOf(-this.calcValue(no.getRight(), inThisContext).floatValue());
        }
        if (no.getData().equals(".")) {
            return Float.valueOf(this.calcPoint(no.getLeft(), no.getRight(), inThisContext));
        }
        if (inThisContext.getVariable(no.getData()) == null) {
            inThisContext.informError(6, this.line, no.getData());
        }
        return inThisContext.getVariable(no.getData());
    }

    private float calcPoint(Nodo left, Nodo right, BlockContext inThisContext) {
        if (right.getData().equals("X")) {
            Ponto pnt = (Ponto)JanelaPonto.getListaDePontos().getObjeto(inThisContext.verificaPontos(left.getData(), this.line));
            return pnt.getX().floatValue();
        }
        if (right.getData().equals("Y")) {
            Ponto pnt = (Ponto)JanelaPonto.getListaDePontos().getObjeto(inThisContext.verificaPontos(left.getData(), this.line));
            return pnt.getY().floatValue();
        }
        if (right.getData().equals("Z")) {
            Ponto pnt = (Ponto)JanelaPonto.getListaDePontos().getObjeto(inThisContext.verificaPontos(left.getData(), this.line));
            return pnt.getZ().floatValue();
        }
        inThisContext.informError(7, this.line, "");
        return 0.0f;
    }

    private boolean isDigit(String digit) {
        for (int i = 0; i < digit.length(); ++i) {
            if (Character.isDigit(digit.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

