/*
 * Decompiled with CFR 0.152.
 */
package Commands;

import Commands.AbstractInstruction;
import Commands.BlockContext;
import Commands.Instruction;
import Componentes.RList;
import Robo.Angulos;
import Robo.Ponto;
import java.util.ArrayList;
import virbot4u.JanelaPonto;

public class InstrGP
extends AbstractInstruction {
    private RList lPontos;
    private ArrayList position;
    private int approach;

    public InstrGP(ArrayList position, int approach, int line) {
        this.position = position;
        this.line = line;
        this.approach = approach;
    }

    public Instruction execute(BlockContext inThisContext) {
        Ponto pnt = null;
        this.lPontos = JanelaPonto.getListaDePontos();
        if (this.lPontos == null) {
            inThisContext.informError(3, this.line, "");
        }
        if (this.position.size() == 3 && this.position.get(2).equals("#")) {
            String pointName1 = this.position.get(0).toString();
            String pointName2 = this.position.get(1).toString();
            this.position.remove(2);
            this.position.remove(1);
            int cont1 = !Character.isDigit(pointName1.charAt(0)) ? inThisContext.verificaPontos(pointName1, this.line) : Integer.parseInt(pointName1) - 1;
            int cont2 = !Character.isDigit(pointName2.charAt(0)) ? inThisContext.verificaPontos(pointName2, this.line) : Integer.parseInt(pointName2) - 1;
            if (cont1 > cont2) {
                inThisContext.informError(4, this.line, pointName1 + " ... " + pointName2);
            }
            for (int i = cont1 + 1; i <= cont2; ++i) {
                this.position.add(((Ponto)this.lPontos.getObjeto(i)).getNomePonto());
            }
            this.position.add(pointName2);
        }
        for (int i = 0; i < this.position.size(); ++i) {
            this.setApproach(inThisContext, this.approach, this.line);
            try {
                Thread.sleep(35L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.position.get(i).toString().length() > 0) {
                String pointName = this.position.get(i).toString();
                int cont = !Character.isDigit(pointName.charAt(0)) ? inThisContext.verificaPontos(pointName, this.line) : Integer.parseInt(pointName) - 1;
                if (cont == -1 || cont > this.lPontos.getItemCount() - 1) {
                    inThisContext.informError(5, this.line, cont == -1 ? this.position.get(i).toString() + " " : "");
                }
                pnt = (Ponto)this.lPontos.getObjeto(cont);
                if (inThisContext.getScene() == null) {
                    inThisContext.informError(1, this.line, "");
                } else if (this.approach == 0 || this.approach == 1) {
                    inThisContext.getScene().setMove(pnt.getAngulos());
                } else {
                    inThisContext.getScene().setMove(new Angulos(pnt.getAlfa(), pnt.getBeta(), pnt.getGama(), Float.valueOf(this.definePositionApproach(inThisContext, pnt, this.approach, this.line)), pnt.getRotacao()));
                }
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return this.nextInstruction;
    }

    public float definePositionApproach(BlockContext inThisContext, Ponto pnt, int approach, int line) {
        switch (approach) {
            case 1: {
                break;
            }
            case 2: {
                if (90.0f - (pnt.getBeta().floatValue() + pnt.getGama().floatValue()) <= 130.0f && 90.0f - (pnt.getBeta().floatValue() + pnt.getGama().floatValue()) >= -130.0f) {
                    return 90.0f - (pnt.getBeta().floatValue() + pnt.getGama().floatValue());
                }
                inThisContext.informWarning(13, line, "FRONT");
                break;
            }
            case 3: {
                if (180.0f - (pnt.getBeta().floatValue() + pnt.getGama().floatValue()) <= 130.0f && 180.0f - (pnt.getBeta().floatValue() + pnt.getGama().floatValue()) >= -130.0f) {
                    return 180.0f - (pnt.getBeta().floatValue() + pnt.getGama().floatValue());
                }
                inThisContext.informWarning(13, line, "UP");
                break;
            }
            case 4: {
                float anguloGarra = inThisContext.getScene().getElevacao().floatValue() + inThisContext.getScene().getBeta().floatValue() + inThisContext.getScene().getGama().floatValue();
                if (anguloGarra - (pnt.getBeta().floatValue() + pnt.getGama().floatValue()) <= 130.0f && anguloGarra - (pnt.getBeta().floatValue() + pnt.getGama().floatValue()) >= -130.0f) {
                    float valApproach = inThisContext.getScene().toRadianos(pnt.getElevacao().floatValue() + pnt.getBeta().floatValue() + pnt.getGama().floatValue()) - (float)Math.PI;
                    return anguloGarra - (pnt.getBeta().floatValue() + pnt.getGama().floatValue());
                }
                inThisContext.informWarning(13, line, "FIXED");
                break;
            }
            case 5: {
                if (-90.0f - (pnt.getBeta().floatValue() + pnt.getGama().floatValue()) <= 130.0f && -90.0f - (pnt.getBeta().floatValue() + pnt.getGama().floatValue()) >= -130.0f) {
                    return -90.0f - (pnt.getBeta().floatValue() + pnt.getGama().floatValue());
                }
                inThisContext.informWarning(13, line, "BACK");
            }
        }
        return 150.0f;
    }
}

