/*
 * Decompiled with CFR 0.152.
 */
package Commands;

import Commands.AbstractInstruction;
import Commands.BlockContext;
import Commands.Instruction;
import Componentes.RList;
import Robo.Angulos;
import Robo.Ponto;
import java.util.ArrayList;
import virbot4u.JanelaPonto;

public class InstrGL
extends AbstractInstruction {
    private ArrayList position;
    private RList lPontos;
    private int approach;

    public InstrGL(ArrayList position, int approach, int line) {
        this.position = position;
        this.line = line;
        this.approach = approach;
    }

    public Instruction execute(BlockContext inThisContext) {
        float granularidade = inThisContext.getScene().granularity;
        float h = 1.0f / granularidade;
        ArrayList<Angulos> points = null;
        Ponto pnt = null;
        if (granularidade > 1000.0f) {
            granularidade = 1000.0f;
        }
        if (granularidade < 5.0f) {
            granularidade = 5.0f;
        }
        this.lPontos = JanelaPonto.getListaDePontos();
        if (this.lPontos == null) {
            inThisContext.informError(3, this.line, "");
        }
        if (this.position.size() == 3 && this.position.get(2).equals("#")) {
            String pointName1 = this.position.get(0).toString();
            String pointName2 = this.position.get(1).toString();
            this.position.remove(2);
            this.position.remove(1);
            int cont1 = !Character.isDigit(pointName1.charAt(0)) ? inThisContext.verificaPontos(pointName1, this.line) : Integer.parseInt(pointName1) - 1;
            int cont2 = !Character.isDigit(pointName2.charAt(0)) ? inThisContext.verificaPontos(pointName2, this.line) : Integer.parseInt(pointName2) - 1;
            if (cont1 > cont2) {
                inThisContext.informError(4, this.line, pointName1 + " ... " + pointName2);
            }
            for (int i = cont1 + 1; i <= cont2; ++i) {
                this.position.add(((Ponto)this.lPontos.getObjeto(i)).getNomePonto());
            }
            this.position.add(pointName2);
        }
        for (int i = 0; i < this.position.size(); ++i) {
            if (this.position.get(i).toString().length() <= 0) continue;
            String pointName = this.position.get(i).toString();
            int cont = !Character.isDigit(pointName.charAt(0)) ? inThisContext.verificaPontos(pointName, this.line) : Integer.parseInt(pointName) - 1;
            if (cont == -1 || cont > this.lPontos.getItemCount() - 1) {
                inThisContext.informError(5, this.line, cont == -1 ? this.position.get(i).toString() + " " : "");
            }
            pnt = (Ponto)this.lPontos.getObjeto(cont);
            if (inThisContext.getScene() == null) {
                inThisContext.informError(1, this.line, "");
                continue;
            }
            float auxRoll = inThisContext.getScene().toRadianos(inThisContext.getScene().getRotacao().floatValue());
            this.setApproach(inThisContext, this.approach, this.line);
            try {
                Thread.sleep(35L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            float xCurrent = inThisContext.getScene().getPontoX().floatValue();
            float yCurrent = inThisContext.getScene().getPontoY().floatValue();
            float zCurrent = inThisContext.getScene().getPontoZ().floatValue();
            points = new ArrayList<Angulos>();
            float z2 = 0.0f;
            float z1 = 0.0f;
            float y2 = 0.0f;
            float y1 = 0.0f;
            float x2 = 0.0f;
            float x1 = 0.0f;
            int p = 0;
            while ((float)p <= granularidade) {
                float x = xCurrent + h * (float)p * (pnt.getX().floatValue() - xCurrent);
                float y = yCurrent + h * (float)p * (pnt.getY().floatValue() - yCurrent);
                float z = zCurrent + h * (float)p * (pnt.getZ().floatValue() - zCurrent);
                if (p == 0) {
                    x1 = x;
                    y1 = y;
                    z1 = z;
                }
                if ((float)p == granularidade) {
                    x2 = x;
                    y2 = y;
                    z2 = z;
                }
                float pitch = inThisContext.getScene().toRadianos(inThisContext.getScene().getElevacao().floatValue() + inThisContext.getScene().getBeta().floatValue() + inThisContext.getScene().getGama().floatValue()) - (float)Math.PI;
                float roll = inThisContext.getScene().toRadianos(inThisContext.getScene().getRotacao().floatValue());
                ArrayList angs = inThisContext.getScene().calcularInversaPontos(-x, z, y, pitch, roll, inThisContext.getScene().elbowOver);
                if (angs == null) {
                    inThisContext.informError(16, this.line, (String)this.position.get(i));
                }
                Angulos ang = new Angulos(Float.valueOf(inThisContext.getScene().toGraus(((Float)angs.get(0)).floatValue())), Float.valueOf(inThisContext.getScene().toGraus(((Float)angs.get(1)).floatValue())), Float.valueOf(inThisContext.getScene().toGraus(((Float)angs.get(2)).floatValue())), Float.valueOf(inThisContext.getScene().toGraus(((Float)angs.get(3)).floatValue())), Float.valueOf(inThisContext.getScene().toGraus(((Float)angs.get(4)).floatValue())));
                points.add(ang);
                ++p;
            }
            double distance = Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y1 - y2, 2.0) + Math.pow(z1 - z2, 2.0));
            int sleep = (int)((double)granularidade * distance) / 1000;
            int p2 = 0;
            while ((float)p2 <= granularidade) {
                inThisContext.getScene().setAngulos((Angulos)points.get(p2));
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                ++p2;
            }
        }
        return this.nextInstruction;
    }
}

