/*
 * Decompiled with CFR 0.152.
 */
package Commands;

import Commands.BlockContext;
import Commands.ErrorMessages;
import Commands.InstrCG;
import Commands.InstrCS;
import Commands.InstrDI;
import Commands.InstrEI;
import Commands.InstrGC;
import Commands.InstrGL;
import Commands.InstrGP;
import Commands.InstrGS;
import Commands.InstrIF;
import Commands.InstrII;
import Commands.InstrIL;
import Commands.InstrJA;
import Commands.InstrJU;
import Commands.InstrLabel;
import Commands.InstrOF;
import Commands.InstrOG;
import Commands.InstrOI;
import Commands.InstrON;
import Commands.InstrPH;
import Commands.InstrPS;
import Commands.InstrRB;
import Commands.InstrRP;
import Commands.InstrRT;
import Commands.InstrSA;
import Commands.InstrSVC;
import Commands.InstrSVS;
import Commands.InstrSVT;
import Commands.InstrWT;
import Commands.Instruction;
import Commands.Nodo;
import Commands.ScriptingBlockContext;
import Robo.Ponto;
import java.util.ArrayList;
import java.util.Map;
import virbot4u.CenaX3D;
import virbot4u.JanelaPonto;
import virbot4u.JanelaPrograma;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBlockContext
extends Thread
implements BlockContext {
    protected BlockContext parent;
    private Map<String, InstrLabel> labels;
    private Map<String, BlockContext> routines;
    private Map<String, Float> variables;
    private int label;
    protected CenaX3D scene;
    boolean loop;
    boolean upDown;
    private long timeStart;
    Instruction interruptInstr;

    public AbstractBlockContext(BlockContext parent, Map<String, InstrLabel> labels, Map<String, BlockContext> routines, Map<String, Float> variables, CenaX3D scene) {
        this.variables = variables;
        this.parent = parent;
        this.labels = labels;
        this.routines = routines;
        this.label = 0;
        this.scene = scene;
        this.loop = false;
        this.upDown = false;
        this.timeStart = System.currentTimeMillis();
        this.interruptInstr = null;
    }

    @Override
    public BlockContext getParentBlockContext() {
        return this.parent;
    }

    protected abstract void addInstr(Instruction var1);

    @Override
    public void addInstrOG(int line) {
        this.addInstr(new InstrOG(line));
    }

    @Override
    public void addInstrCG(int line) {
        this.addInstr(new InstrCG(line));
    }

    @Override
    public void addInstrWT(String time, int line) {
        this.addInstr(new InstrWT(time, line));
    }

    @Override
    public void addInstrRB(int line) {
        this.addInstr(new InstrRB(line));
    }

    @Override
    public void addInstrGP(ArrayList position, int approach, int line) {
        this.addInstr(new InstrGP(position, approach, line));
    }

    @Override
    public void addInstrJU(String toLabel, int line) {
        this.addInstr(new InstrJU(toLabel, line));
    }

    @Override
    public void addInstrCS(String sub, int line) {
        this.addInstr(new InstrCS(sub, line));
    }

    @Override
    public void addInstrSVC(Nodo variable, Nodo value, int line) {
        this.addInstr(new InstrSVC(variable, value, line));
    }

    @Override
    public void addInstrSVS(String nameVar, int line) {
        this.addInstr(new InstrSVS(nameVar, line));
    }

    @Override
    public void addInstrSVT(String nameVar, int line) {
        this.addInstr(new InstrSVT(nameVar, line));
    }

    @Override
    public void addInstrIF(Nodo condition, String toLabel, int line) {
        this.addInstr(new InstrIF(condition, toLabel, line));
    }

    @Override
    public void addInstrPS(String msg, int line) {
        this.addInstr(new InstrPS(msg, line));
    }

    @Override
    public void addInstrRP(String namePoint, int line) {
        this.addInstr(new InstrRP(namePoint, line));
    }

    @Override
    public void addInstrJA(Nodo value, int line) {
        this.addInstr(new InstrJA(value, line));
    }

    @Override
    public void addInstrRT(int line) {
        this.addInstr(new InstrRT(line));
    }

    @Override
    public void addInstrIL(Nodo axis, String toLabel, int line) {
        this.addInstr(new InstrIL(axis, toLabel, line));
    }

    @Override
    public void addInstrPH(int line) {
        this.addInstr(new InstrPH(line));
    }

    @Override
    public void addInstrII(Nodo iiToken, boolean onOff, String toLabel, int line) {
        this.addInstr(new InstrII(iiToken, onOff, toLabel, line));
    }

    @Override
    public void addInstrOI(Nodo ioToken, boolean onOff, String toLabel, int line) {
        this.addInstr(new InstrOI(ioToken, onOff, toLabel, line));
    }

    @Override
    public void addInstrDI(Nodo inOut, int line) {
        this.addInstr(new InstrDI(inOut, line));
    }

    @Override
    public void addInstrEI(Nodo inOut, int line) {
        this.addInstr(new InstrEI(inOut, line));
    }

    @Override
    public void addInstrOF(Nodo inOut, int line) {
        this.addInstr(new InstrOF(inOut, line));
    }

    @Override
    public void addInstrON(Nodo inOut, int line) {
        this.addInstr(new InstrON(inOut, line));
    }

    @Override
    public void addInstrGC(String positionVia, String positionF, int approach, int line) {
        this.addInstr(new InstrGC(positionVia, positionF, approach, line));
    }

    @Override
    public void addInstrGL(ArrayList position, int approach, int line) {
        this.addInstr(new InstrGL(position, approach, line));
    }

    @Override
    public void addInstrSA(String axis, int line) {
        this.addInstr(new InstrSA(axis, line));
    }

    @Override
    public void addInstrGS(ArrayList position, int approach, int line) {
        this.addInstr(new InstrGS(position, approach, line));
    }

    @Override
    public void createVariable(String varName, Float value) {
        this.variables.put(varName, value);
    }

    @Override
    public Float getVariable(String varName) {
        return this.variables.get(varName);
    }

    @Override
    public long getTimeStart() {
        return this.timeStart;
    }

    @Override
    public void initTimeStart() {
        this.timeStart = System.currentTimeMillis();
    }

    @Override
    public boolean isVariable(String varName) {
        return this.variables.get(varName) != null;
    }

    @Override
    public void createLabel(String labelName, int line) {
        InstrLabel li = new InstrLabel(labelName, line);
        if (this.labels.get(labelName) != null) {
            this.informError(19, line, labelName);
            this.stop();
        }
        this.labels.put(labelName, li);
        this.addInstr(li);
    }

    @Override
    public Instruction getInstrForLabel(String labelName) {
        return this.labels.get(labelName);
    }

    @Override
    public boolean executeRoutine(String routineName) {
        if (this.routines.get(routineName) == null) {
            return false;
        }
        this.routines.get(routineName).executeBlockInstructions();
        return true;
    }

    @Override
    public BlockContext createRoutine(String routineName) {
        ScriptingBlockContext bc = new ScriptingBlockContext(this, this.scene);
        System.out.println("--------" + routineName);
        this.routines.put(routineName, bc);
        return bc;
    }

    @Override
    public int informLabel() {
        return this.label++;
    }

    @Override
    public CenaX3D getScene() {
        return this.scene;
    }

    @Override
    public void setExecutionLoop() {
        this.loop = true;
    }

    @Override
    public void informError(int errorMessage, int lineError, String complements) {
        JanelaPrograma.getTxtConsole().setCaretPosition(0);
        if (JanelaPrograma.getIdioma().equals("Portugues")) {
            JanelaPrograma.getTxtConsole().setText(JanelaPrograma.getTxtConsole().getText().equals("") ? "" + ErrorMessages.getMessage(errorMessage, lineError, 1, complements) + "\n" : JanelaPrograma.getTxtConsole().getText() + ErrorMessages.getMessage(errorMessage, lineError, 1, complements) + "\n");
            this.scene.jp.setTxtFeedback("ERRO na linha << " + lineError + " >>");
        } else {
            JanelaPrograma.getTxtConsole().setText(JanelaPrograma.getTxtConsole().getText().equals("") ? "" + ErrorMessages.getMessage(errorMessage, lineError, 2, complements) + "\n" : JanelaPrograma.getTxtConsole().getText() + ErrorMessages.getMessage(errorMessage, lineError, 2, complements) + "\n");
            this.scene.jp.setTxtFeedback("ERROR line << " + lineError + " >>");
        }
        this.stop();
    }

    @Override
    public void informWarning(int warningMessage, int lineError, String complements) {
        JanelaPrograma.getTxtConsole().setCaretPosition(0);
        if (JanelaPrograma.getIdioma().equals("Portugues")) {
            JanelaPrograma.getTxtConsole().setText(ErrorMessages.getMessage(warningMessage, lineError, 1, complements));
        } else {
            JanelaPrograma.getTxtConsole().setText(ErrorMessages.getMessage(warningMessage, lineError, 2, complements));
        }
    }

    @Override
    public void printMessageConsole(String textMessage) {
        JanelaPrograma.getTxtConsole().setText(JanelaPrograma.getTxtConsole().getText().equals("") ? "" + textMessage + "\n" : JanelaPrograma.getTxtConsole().getText() + textMessage + "\n");
        JanelaPrograma.getTxtConsole().setCaretPosition(JanelaPrograma.getTxtConsole().getText().length());
    }

    @Override
    public synchronized void setInterruption(boolean upDown, int input, Instruction instr, int line, int contr) {
        this.upDown = upDown;
        System.out.println(upDown);
        if (contr == 1) {
            this.writeFeedback(3, "" + line);
        }
        this.interruptInstr = instr;
    }

    @Override
    public int verificaPontos(String nomePonto, int line) {
        if (JanelaPonto.getListaDePontos() == null) {
            this.informError(3, line, "");
        }
        Integer numPontos = JanelaPonto.getListaDePontos().getItemCount();
        for (int i = 0; i < numPontos; ++i) {
            Ponto ponto = (Ponto)JanelaPonto.getListaDePontos().getObjeto(i);
            if (!nomePonto.equals(ponto.getNomePonto())) continue;
            return i;
        }
        return -1;
    }

    protected void writeFeedbackLine(int line) {
        if (JanelaPrograma.getIdioma().equals("Portugues")) {
            this.scene.jp.setTxtFeedback("Executando linha << " + line + " >> ...");
        } else {
            this.scene.jp.setTxtFeedback("Executing line << " + line + " >> ...");
        }
    }

    protected void writeFeedback(int type, String complements) {
        switch (type) {
            case 1: {
                if (JanelaPrograma.getIdioma().equals("Portugues")) {
                    this.scene.jp.setTxtFeedback("Terminado...");
                    break;
                }
                this.scene.jp.setTxtFeedback("Finished...");
                break;
            }
            case 2: {
                if (JanelaPrograma.getIdioma().equals("Portugues")) {
                    JanelaPrograma.getTxtConsole().setText(JanelaPrograma.getTxtConsole().getText() + "Completo!");
                    break;
                }
                JanelaPrograma.getTxtConsole().setText(JanelaPrograma.getTxtConsole().getText() + "Complete!");
                break;
            }
            case 3: {
                if (JanelaPrograma.getIdioma().equals("Portugues")) {
                    JanelaPrograma.getTxtConsole().setText(JanelaPrograma.getTxtConsole().getText() + "Executando Interrup\u00e7\u00e3o na linha '" + complements + "'!\n");
                    break;
                }
                JanelaPrograma.getTxtConsole().setText(JanelaPrograma.getTxtConsole().getText() + "Executing Interruption in line '" + complements + "'!\n");
            }
        }
    }
}

