/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.impl.core.loading;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.Vector;
import org.ietf.uri.URI;
import org.ietf.uri.URIUtils;
import org.ietf.uri.URL;
import org.ietf.uri.UnsupportedServiceException;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.scripting.InvalidScriptContentException;
import org.web3d.vrml.scripting.ScriptEngine;
import org.web3d.vrml.scripting.ScriptWrapper;
import org.xj3d.core.loading.CacheDetails;
import org.xj3d.core.loading.FileCache;
import org.xj3d.core.loading.LoadRequestHandler;
import org.xj3d.impl.core.loading.BaseLoadHandler;
import org.xj3d.impl.core.loading.ScriptLoadDetails;

class ScriptLoadHandler
extends BaseLoadHandler
implements LoadRequestHandler {
    private static final String NO_VALID_URLS_MSG = "Cannot resolve any URLS for a script. URL: ";
    private static final String UNKNOWN_ERROR_MSG = "Loading the script generated an unexpected error.";
    private static final String JAVA_MIME = "application/x-java";
    private FileCache fileCache;

    ScriptLoadHandler(FileCache fileCache) {
        this.fileCache = fileCache;
    }

    public void processLoadRequest(ErrorReporter errorReporter, String[] stringArray, Vector vector) {
        Object object;
        ScriptLoadDetails scriptLoadDetails;
        int n;
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < vector.size(); ++n) {
            scriptLoadDetails = (ScriptLoadDetails)vector.get(n);
            object = scriptLoadDetails.node;
            object.setLoadState(2);
        }
        if (this.terminateCurrent) {
            return;
        }
        for (n = 0; !bl && n < stringArray.length; ++n) {
            int n2;
            object = stringArray[n];
            if (!((String)object).startsWith("javascript:") && !((String)object).startsWith("ecmascript:") && (n2 = ((String)object).lastIndexOf(35)) != -1) {
                object = ((String)object).substring(0, n2);
            }
            CacheDetails cacheDetails = this.fileCache.checkForFile((String)object);
            scriptLoadDetails = (ScriptLoadDetails)vector.get(0);
            VRMLScriptNodeType vRMLScriptNodeType = scriptLoadDetails.node;
            VRMLExecutionSpace vRMLExecutionSpace = vRMLScriptNodeType.getExecutionSpace();
            BasicScene basicScene = vRMLExecutionSpace.getContainedScene();
            int n3 = basicScene.getSpecificationMajorVersion();
            Map map = (Map)scriptLoadDetails.engineMap.get(n3);
            if (cacheDetails != null) {
                String string = cacheDetails.getContentType();
                ScriptEngine scriptEngine = (ScriptEngine)map.get(string);
                if (scriptEngine == null) continue;
                Object object2 = cacheDetails.getContent();
                bl = true;
                for (int i = 0; i < vector.size(); ++i) {
                    scriptLoadDetails = (ScriptLoadDetails)vector.get(i);
                    VRMLScriptNodeType vRMLScriptNodeType2 = scriptLoadDetails.node;
                    if (!vRMLScriptNodeType2.checkValidContentType(string)) continue;
                    vRMLScriptNodeType2.setLoadedURI(stringArray[n]);
                    try {
                        ScriptWrapper scriptWrapper = scriptEngine.buildWrapper(vRMLScriptNodeType2.getExecutionSpace(), string, object2);
                        vRMLScriptNodeType2.setContent(string, scriptWrapper);
                    }
                    catch (InvalidScriptContentException invalidScriptContentException) {
                        String string2 = "Invalid content for script " + (String)object;
                        errorReporter.errorReport(string2, (Exception)((Object)invalidScriptContentException));
                        continue;
                    }
                    vRMLScriptNodeType2.setLoadState(3);
                    scriptLoadDetails.statusListener.loadCompleted(vRMLScriptNodeType2);
                }
                continue;
            }
            bl = this.loadExternal(errorReporter, (String)object, vector, map);
        }
        if (!bl) {
            n = vector.size();
            for (int i = 0; i < vector.size(); ++i) {
                scriptLoadDetails = (ScriptLoadDetails)vector.get(i);
                VRMLScriptNodeType vRMLScriptNodeType = scriptLoadDetails.node;
                vRMLScriptNodeType.setLoadState(4);
                scriptLoadDetails.statusListener.loadFailed(vRMLScriptNodeType);
            }
            String string = stringArray.length > 0 ? (stringArray[0].length() > 80 ? stringArray[0].substring(0, 80) : stringArray[0]) : "Empty Url";
            errorReporter.warningReport(NO_VALID_URLS_MSG + string, null);
        }
        this.currentConnection = null;
    }

    private boolean loadExternal(ErrorReporter errorReporter, String string, Vector vector, Map map) {
        boolean bl = false;
        URL[] uRLArray = null;
        if (string.endsWith(".class")) {
            ScriptEngine scriptEngine = (ScriptEngine)map.get(JAVA_MIME);
            if (scriptEngine == null) {
                return false;
            }
            return this.loadClass(errorReporter, string, vector, scriptEngine);
        }
        if (string.startsWith("ecmascript:") || string.startsWith("javascript:")) {
            String string2 = string.startsWith("ecmascript:") ? "application/ecmascript" : "application/javascript";
            String string3 = string.length() > 10 ? string.substring(11) : "";
            ScriptEngine scriptEngine = (ScriptEngine)map.get(string2);
            for (int i = 0; i < vector.size(); ++i) {
                ScriptLoadDetails scriptLoadDetails = (ScriptLoadDetails)vector.get(i);
                VRMLScriptNodeType vRMLScriptNodeType = scriptLoadDetails.node;
                if (!vRMLScriptNodeType.checkValidContentType(string2)) continue;
                bl = true;
                vRMLScriptNodeType.setLoadedURI(string);
                vRMLScriptNodeType.setLoadState(3);
                ScriptWrapper scriptWrapper = scriptEngine.buildWrapper(vRMLScriptNodeType.getExecutionSpace(), string2, (Object)string3);
                vRMLScriptNodeType.setContent(string2, scriptWrapper);
                vRMLScriptNodeType.setLoadState(3);
                scriptLoadDetails.statusListener.loadCompleted(vRMLScriptNodeType);
            }
            return bl;
        }
        try {
            URI uRI = URIUtils.createURI((String)string);
            if (this.terminateCurrent) {
                return false;
            }
            uRLArray = uRI.getURLList();
        }
        catch (IOException iOException) {
            String string4 = "URI does not resolve to anything useful.\nURI is " + string;
            errorReporter.warningReport(string4, iOException);
            return false;
        }
        if (this.terminateCurrent) {
            return false;
        }
        if (uRLArray == null) {
            errorReporter.warningReport("Script contains no URLs. Ignoring", null);
            return false;
        }
        for (int i = 0; i < uRLArray.length; ++i) {
            try {
                this.currentConnection = uRLArray[i].getResource();
            }
            catch (IOException iOException) {
                String string5 = "Can't find resource " + uRLArray[i];
                errorReporter.warningReport(string5, iOException);
                continue;
            }
            catch (UnsupportedServiceException unsupportedServiceException) {
                String string6 = "Can't run script: " + uRLArray[i];
                errorReporter.warningReport(string6, (Exception)((Object)unsupportedServiceException));
                continue;
            }
            if (!this.makeConnection(errorReporter)) {
                if (!this.terminateCurrent) continue;
                break;
            }
            try {
                if (this.terminateCurrent) {
                    this.currentConnection.close();
                    break;
                }
                String string7 = this.currentConnection.getContentType();
                if (this.terminateCurrent) {
                    this.currentConnection.close();
                    break;
                }
                if (string7 == null) {
                    this.currentConnection.close();
                    continue;
                }
                ScriptEngine scriptEngine = (ScriptEngine)map.get(string7);
                if (scriptEngine == null) {
                    this.currentConnection.close();
                    continue;
                }
                Object object = this.currentConnection.getContent();
                this.currentConnection.close();
                if (object == null) continue;
                if (this.terminateCurrent) break;
                boolean bl2 = false;
                for (int j = 0; j < vector.size(); ++j) {
                    ScriptLoadDetails scriptLoadDetails = (ScriptLoadDetails)vector.get(j);
                    VRMLScriptNodeType vRMLScriptNodeType = scriptLoadDetails.node;
                    if (!vRMLScriptNodeType.checkValidContentType(string7)) continue;
                    bl2 = true;
                    vRMLScriptNodeType.setLoadedURI(string);
                    vRMLScriptNodeType.setLoadState(3);
                    ScriptWrapper scriptWrapper = scriptEngine.buildWrapper(vRMLScriptNodeType.getExecutionSpace(), string7, object);
                    vRMLScriptNodeType.setContent(string7, scriptWrapper);
                    vRMLScriptNodeType.setLoadState(3);
                    scriptLoadDetails.statusListener.loadCompleted(vRMLScriptNodeType);
                }
                if (!bl2) continue;
                if (this.terminateCurrent) break;
                this.fileCache.cacheFile(string, string7, object);
                if (this.terminateCurrent) break;
                bl = true;
                break;
            }
            catch (IOException iOException) {
                String string8 = "IO Error reading external file " + string;
                errorReporter.warningReport(string8, iOException);
                if (!this.terminateCurrent) continue;
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                errorReporter.warningReport("Can't set external content", illegalArgumentException);
                continue;
            }
            catch (InvalidScriptContentException invalidScriptContentException) {
                String string9 = "Invalid content for script url " + string;
                errorReporter.warningReport(string9, (Exception)((Object)invalidScriptContentException));
                continue;
            }
            catch (Exception exception) {
                errorReporter.errorReport(UNKNOWN_ERROR_MSG, exception);
            }
        }
        return bl;
    }

    private boolean loadClass(ErrorReporter errorReporter, String string, Vector vector, ScriptEngine scriptEngine) {
        String string2;
        String string3;
        boolean bl = true;
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(46);
        if (string.startsWith("jar:")) {
            int n3 = string.lastIndexOf("!");
            string3 = string.substring(4, n3);
            string2 = string.substring(n3 + 2, n2);
        } else {
            string3 = string.substring(0, n + 1);
            string2 = string.substring(n + 1, n2);
        }
        String string4 = null;
        Throwable throwable = null;
        try {
            java.net.URL[] uRLArray = new java.net.URL[]{new java.net.URL(string3)};
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
            Class<?> clazz = null;
            try {
                clazz = uRLClassLoader.loadClass(string2);
            }
            catch (Exception exception) {
                ClassLoader classLoader = this.getClass().getClassLoader();
                clazz = classLoader.loadClass(string2);
            }
            for (int i = 0; i < vector.size(); ++i) {
                ScriptWrapper scriptWrapper;
                ScriptLoadDetails scriptLoadDetails = (ScriptLoadDetails)vector.get(i);
                VRMLScriptNodeType vRMLScriptNodeType = scriptLoadDetails.node;
                try {
                    scriptWrapper = scriptEngine.buildWrapper(vRMLScriptNodeType.getExecutionSpace(), JAVA_MIME, clazz);
                }
                catch (Exception exception) {
                    ClassLoader classLoader = this.getClass().getClassLoader();
                    clazz = classLoader.loadClass(string2);
                    scriptWrapper = scriptEngine.buildWrapper(vRMLScriptNodeType.getExecutionSpace(), JAVA_MIME, clazz);
                }
                this.fileCache.cacheFile(string, JAVA_MIME, clazz);
                vRMLScriptNodeType.setContent(JAVA_MIME, scriptWrapper);
                vRMLScriptNodeType.setLoadState(3);
                scriptLoadDetails.statusListener.loadCompleted(vRMLScriptNodeType);
            }
        }
        catch (MalformedURLException malformedURLException) {
            string4 = "Invalid URL for the script " + string3;
            throwable = malformedURLException;
            bl = false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            string4 = "Couldn't find the Java class " + string2 + " at: " + string3;
            throwable = classNotFoundException;
            bl = false;
        }
        catch (InvalidScriptContentException invalidScriptContentException) {
            string4 = "Invalid content for script " + string;
            throwable = invalidScriptContentException;
            bl = false;
        }
        if (string4 != null) {
            errorReporter.errorReport(string4, (Exception)throwable);
        }
        return bl;
    }
}

