/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.impl.core.eventmodel;

import java.util.ArrayList;
import java.util.List;
import org.web3d.browser.BrowserCore;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.xj3d.core.eventmodel.ViewpointManager;
import org.xj3d.core.eventmodel.ViewpointStatusListener;
import org.xj3d.core.eventmodel.ViewpointStatusListenerMulticaster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultViewpointManager
implements ViewpointManager,
org.web3d.browser.ViewpointStatusListener {
    private static final String REMOVE_ERROR_MSG = "Error sending viewpoint remove message: ";
    private static final String ADD_ERROR_MSG = "Error sending viewpoint add message: ";
    private static final String CHANGE_ERROR_MSG = "Error sending viewpoint change message: ";
    private static final String SELECT_ERROR_MSG = "Error sending viewpoint bound notification events: ";
    private static final String DEFAULT_ERR_MSG = "Unknown error sending viewpoint state change event: ";
    private ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();
    private VRMLViewpointNodeType nextViewpoint;
    private VRMLViewpointNodeType currentViewpoint;
    private ArrayList<ArrayList<VRMLViewpointNodeType>> viewpointsByLayer = new ArrayList();
    private ArrayList<VRMLViewpointNodeType> defaultViewpoints = new ArrayList();
    private ArrayList<VRMLViewpointNodeType> boundViewpoints = new ArrayList();
    private int activeLayerId = -1;
    private ViewpointStatusListener externalListeners;
    private BrowserCore browserCore;

    public DefaultViewpointManager(BrowserCore browserCore) {
        this.browserCore = browserCore;
        this.browserCore.addViewpointStatusListener((org.web3d.browser.ViewpointStatusListener)this);
    }

    @Override
    public void updateViewpoint(long l) {
        if (this.nextViewpoint != null) {
            this.nextViewpoint.setBind(true, true, l);
            this.currentViewpoint = this.nextViewpoint;
            this.nextViewpoint = null;
        }
    }

    @Override
    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    @Override
    public void setViewpoint(VRMLViewpointNodeType vRMLViewpointNodeType) {
        this.nextViewpoint = vRMLViewpointNodeType;
    }

    @Override
    public void resetViewpoint() {
        this.nextViewpoint = this.currentViewpoint;
    }

    @Override
    public void firstViewpoint() {
        this.firstViewpoint(this.activeLayerId);
    }

    @Override
    public void firstViewpoint(int n) {
        ArrayList<VRMLViewpointNodeType> arrayList = this.viewpointsByLayer.get(n);
        if (arrayList.size() != 0) {
            this.nextViewpoint = arrayList.get(0);
            if (this.nextViewpoint == this.defaultViewpoints.get(n)) {
                this.nextViewpoint = arrayList.get(1);
            }
        }
    }

    @Override
    public void lastViewpoint() {
        this.lastViewpoint(this.activeLayerId);
    }

    @Override
    public void lastViewpoint(int n) {
        ArrayList<VRMLViewpointNodeType> arrayList = this.viewpointsByLayer.get(n);
        int n2 = arrayList.size();
        if (n2 != 0) {
            this.nextViewpoint = arrayList.get(n2 - 1);
            if (this.nextViewpoint == this.defaultViewpoints.get(n)) {
                this.nextViewpoint = arrayList.get(n2 - 2);
            }
        }
    }

    @Override
    public void nextViewpoint() {
        this.nextViewpoint(this.activeLayerId);
    }

    @Override
    public void nextViewpoint(int n) {
        ArrayList<VRMLViewpointNodeType> arrayList = this.viewpointsByLayer.get(n);
        if (arrayList.size() < 2) {
            return;
        }
        int n2 = arrayList.indexOf(this.currentViewpoint);
        if (n2 != -1) {
            n2 = n2 == arrayList.size() - 1 ? 0 : ++n2;
            VRMLViewpointNodeType vRMLViewpointNodeType = this.defaultViewpoints.get(n);
            if (n2 == arrayList.indexOf(vRMLViewpointNodeType)) {
                ++n2;
            }
            if (n2 > arrayList.size() - 1) {
                n2 = 0;
            }
            this.nextViewpoint = arrayList.get(n2);
        }
    }

    @Override
    public void previousViewpoint() {
        this.previousViewpoint(this.activeLayerId);
    }

    @Override
    public void previousViewpoint(int n) {
        ArrayList<VRMLViewpointNodeType> arrayList = this.viewpointsByLayer.get(n);
        if (arrayList.size() < 2) {
            return;
        }
        int n2 = arrayList.indexOf(this.currentViewpoint);
        if (n2 != -1) {
            n2 = n2 == 0 ? arrayList.size() - 1 : --n2;
            VRMLViewpointNodeType vRMLViewpointNodeType = this.defaultViewpoints.get(n);
            if (n2 == arrayList.indexOf(vRMLViewpointNodeType)) {
                --n2;
            }
            if (n2 < 0) {
                n2 = arrayList.size() - 1;
            }
            this.nextViewpoint = arrayList.get(n2);
        }
    }

    @Override
    public void shutdown() {
        this.browserCore.removeViewpointStatusListener((org.web3d.browser.ViewpointStatusListener)this);
    }

    @Override
    public void clear() {
        this.viewpointsByLayer.clear();
        this.defaultViewpoints.clear();
        this.boundViewpoints.clear();
        this.currentViewpoint = null;
        this.nextViewpoint = null;
    }

    @Override
    public void addViewpointListener(ViewpointStatusListener viewpointStatusListener) {
        this.externalListeners = ViewpointStatusListenerMulticaster.add(this.externalListeners, viewpointStatusListener);
    }

    @Override
    public void removeViewpointListener(ViewpointStatusListener viewpointStatusListener) {
        this.externalListeners = ViewpointStatusListenerMulticaster.remove(this.externalListeners, viewpointStatusListener);
    }

    public void viewpointLayerAdded(int n) {
        if (n >= this.viewpointsByLayer.size()) {
            for (int i = this.viewpointsByLayer.size(); i <= n; ++i) {
                this.viewpointsByLayer.add(null);
            }
            this.defaultViewpoints.add(null);
            this.boundViewpoints.add(null);
        }
        this.viewpointsByLayer.set(n, new ArrayList());
    }

    public void viewpointLayerRemoved(int n) {
        this.viewpointsByLayer.set(n, null);
        this.defaultViewpoints.set(n, null);
        this.boundViewpoints.set(n, null);
    }

    public void viewpointLayerActive(int n) {
        this.activeLayerId = n;
        if (n != -1) {
            ArrayList<VRMLViewpointNodeType> arrayList = this.viewpointsByLayer.get(n);
            this.currentViewpoint = this.boundViewpoints.get(n);
            if (this.externalListeners != null) {
                VRMLViewpointNodeType[] vRMLViewpointNodeTypeArray = null;
                if (arrayList != null && arrayList.size() != 0) {
                    vRMLViewpointNodeTypeArray = (VRMLViewpointNodeType[])arrayList.toArray();
                }
                try {
                    this.externalListeners.availableViewpointsChanged(vRMLViewpointNodeTypeArray);
                }
                catch (Throwable throwable) {
                    if (throwable instanceof Exception) {
                        this.errorReporter.errorReport(CHANGE_ERROR_MSG + this.externalListeners, (Exception)throwable);
                    }
                    System.out.println(DEFAULT_ERR_MSG + throwable);
                    throwable.printStackTrace();
                }
            }
        }
    }

    public void viewpointAdded(VRMLViewpointNodeType vRMLViewpointNodeType, int n, boolean bl) {
        ArrayList<VRMLViewpointNodeType> arrayList;
        if (bl) {
            this.defaultViewpoints.set(n, vRMLViewpointNodeType);
            if (this.boundViewpoints.get(n) == null) {
                this.boundViewpoints.set(n, vRMLViewpointNodeType);
            }
        }
        if (!(arrayList = this.viewpointsByLayer.get(n)).contains(vRMLViewpointNodeType)) {
            arrayList.add(vRMLViewpointNodeType);
        }
        if (n == this.activeLayerId && this.externalListeners != null) {
            try {
                this.externalListeners.viewpointAdded(vRMLViewpointNodeType);
            }
            catch (Throwable throwable) {
                if (throwable instanceof Exception) {
                    this.errorReporter.errorReport(ADD_ERROR_MSG + this.externalListeners, (Exception)throwable);
                }
                System.out.println(DEFAULT_ERR_MSG + throwable);
                throwable.printStackTrace();
            }
        }
    }

    public void viewpointRemoved(VRMLViewpointNodeType vRMLViewpointNodeType, int n) {
        ArrayList<VRMLViewpointNodeType> arrayList = this.viewpointsByLayer.get(n);
        arrayList.remove(vRMLViewpointNodeType);
        if (this.defaultViewpoints.get(n) == vRMLViewpointNodeType) {
            this.defaultViewpoints.set(n, null);
        }
        if (this.boundViewpoints.get(n) == vRMLViewpointNodeType) {
            this.boundViewpoints.set(n, this.defaultViewpoints.get(n));
        }
        if (n == this.activeLayerId && this.externalListeners != null) {
            try {
                this.externalListeners.viewpointRemoved(vRMLViewpointNodeType);
            }
            catch (Throwable throwable) {
                if (throwable instanceof Exception) {
                    this.errorReporter.errorReport(REMOVE_ERROR_MSG + this.externalListeners, (Exception)throwable);
                }
                System.out.println(DEFAULT_ERR_MSG + throwable);
                throwable.printStackTrace();
            }
        }
    }

    public void viewpointBound(VRMLViewpointNodeType vRMLViewpointNodeType, int n) {
        this.boundViewpoints.set(n, vRMLViewpointNodeType);
        if (n == this.activeLayerId) {
            this.currentViewpoint = vRMLViewpointNodeType;
            if (this.externalListeners != null) {
                try {
                    this.externalListeners.selectedViewpointChanged(vRMLViewpointNodeType);
                }
                catch (Throwable throwable) {
                    if (throwable instanceof Exception) {
                        this.errorReporter.errorReport(SELECT_ERROR_MSG + this.externalListeners, (Exception)throwable);
                    }
                    System.out.println(DEFAULT_ERR_MSG + throwable);
                    throwable.printStackTrace();
                }
            }
        }
    }

    @Override
    public List<VRMLViewpointNodeType> getActiveViewpoints() {
        return this.viewpointsByLayer.get(this.activeLayerId);
    }
}

