/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.impl.core.eventmodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.NavigationStateListener;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.VRMLNavigationInfoNodeType;
import org.xj3d.core.eventmodel.NavigationManager;
import org.xj3d.core.eventmodel.NavigationStatusListener;
import org.xj3d.core.eventmodel.NavigationStatusListenerMulticaster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNavigationManager
implements NavigationManager,
NavigationStateListener {
    private static final String REMOVE_ERROR_MSG = "Error sending viewpoint remove message: ";
    private static final String NAV_SELECT_ERROR_MSG = "Error sending navigation info selection message: ";
    private static final String NAV_CHANGE_ERROR_MSG = "Error sending navigation info change message: ";
    private static final String NAV_STATE_ERROR_MSG = "Error sending navigation state change message: ";
    private static final String NAV_LIST_ERROR_MSG = "Error sending navigation type listing message: ";
    private static final String DEFAULT_ERR_MSG = "Unknown error sending navigation state change event: ";
    private static final String ACTIVE_IDX_SIZE_MSG = "The navigation type index selected is out of range for the currently available types in the system: ";
    private ErrorReporter errorReporter;
    private NavigationStatusListener listeners;
    private List<String> navigationTypes = new ArrayList<String>();
    private int activeNavigationType = -1;
    private VRMLNavigationInfoNodeType activeNavInfo;
    private List<VRMLNavigationInfoNodeType> activeNavInfoList = new ArrayList<VRMLNavigationInfoNodeType>();
    private BrowserCore browserCore;

    public DefaultNavigationManager(BrowserCore browserCore) {
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        this.browserCore = browserCore;
        this.browserCore.addNavigationStateListener((NavigationStateListener)this);
    }

    @Override
    public void setNavigationInfo(VRMLNavigationInfoNodeType vRMLNavigationInfoNodeType) {
        this.activeNavInfo = vRMLNavigationInfoNodeType;
    }

    @Override
    public VRMLNavigationInfoNodeType getNavigationInfo() {
        return this.activeNavInfo;
    }

    @Override
    public List<String> getActiveNavigationTypes() {
        return Collections.unmodifiableList(this.navigationTypes);
    }

    @Override
    public void setActiveNavigationIndex(int n) throws IllegalArgumentException {
        if (n >= this.navigationTypes.size() || n < -1) {
            throw new IllegalArgumentException(ACTIVE_IDX_SIZE_MSG + n);
        }
        this.activeNavigationType = n;
        this.sendNavTypeIndex(n);
    }

    @Override
    public int getActiveNavgiationIndex() {
        return this.activeNavigationType;
    }

    @Override
    public void clear() {
    }

    @Override
    public void shutdown() {
        this.browserCore.removeNavigationStateListener((NavigationStateListener)this);
    }

    @Override
    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    @Override
    public List<VRMLNavigationInfoNodeType> getActiveNavInfos() {
        return Collections.unmodifiableList(this.activeNavInfoList);
    }

    @Override
    public void addNavigationListener(NavigationStatusListener navigationStatusListener) {
        this.listeners = NavigationStatusListenerMulticaster.add(this.listeners, navigationStatusListener);
    }

    @Override
    public void removeNavigationListener(NavigationStatusListener navigationStatusListener) {
        this.listeners = NavigationStatusListenerMulticaster.remove(this.listeners, navigationStatusListener);
    }

    public void navigationStateChanged(int n) {
        this.activeNavigationType = n;
        this.sendNavTypeIndex(n);
    }

    public void navigationListChanged(String[] stringArray, int n) {
        this.navigationTypes.clear();
        for (int i = 0; i < n; ++i) {
            this.navigationTypes.add(stringArray[i]);
        }
        if (this.listeners != null) {
            List<String> list = Collections.unmodifiableList(this.navigationTypes);
            try {
                this.listeners.navigationListChanged(list);
            }
            catch (Throwable throwable) {
                if (throwable instanceof Exception) {
                    this.errorReporter.errorReport(NAV_LIST_ERROR_MSG + this.listeners, (Exception)throwable);
                }
                System.out.println(DEFAULT_ERR_MSG + throwable);
                throwable.printStackTrace();
            }
        }
    }

    private void sendNavTypeIndex(int n) {
        if (this.listeners == null) {
            return;
        }
        try {
            this.listeners.navigationStateChanged(n);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                this.errorReporter.errorReport(NAV_STATE_ERROR_MSG + this.listeners, (Exception)throwable);
            }
            System.out.println(DEFAULT_ERR_MSG + throwable);
            throwable.printStackTrace();
        }
    }
}

