/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.core.eventmodel;

import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.vrml.nodes.VRMLKeyDeviceSensorNodeType;
import org.web3d.vrml.util.KeySensorDevice;
import org.web3d.vrml.util.KeySequence;
import org.web3d.vrml.util.NodeArray;
import org.web3d.vrml.util.Xj3DKeyEvent;
import org.xj3d.core.eventmodel.DeviceFactory;

public class KeyDeviceSensorManager {
    private ErrorReporter errorReporter;
    private HashSet keyNodes;
    private NodeArray sensors;
    private KeySensorDevice keySensorDevice;
    private KeySequence keySequence;
    private DeviceFactory deviceFactory;

    public KeyDeviceSensorManager(DeviceFactory deviceFactory) {
        if (deviceFactory != null) {
            this.deviceFactory = deviceFactory;
            this.keySensorDevice = deviceFactory.getKeySensorDevice();
            this.keySequence = new KeySequence();
        }
        this.keyNodes = new HashSet();
        this.sensors = new NodeArray();
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void clear() {
        this.keyNodes.clear();
    }

    public void reinitialize(DeviceFactory deviceFactory) {
        this.deviceFactory = deviceFactory;
        if (this.deviceFactory != null) {
            this.keySensorDevice = this.deviceFactory.getKeySensorDevice();
            this.keySequence = new KeySequence();
        } else {
            this.keySensorDevice = null;
            this.keySequence = null;
        }
    }

    public void processEvents() {
        if (this.keySensorDevice != null) {
            this.keySensorDevice.getEvents(this.keySequence);
            int n = this.keySequence.size();
            if (n != 0) {
                int n2 = this.sensors.size();
                for (int i = 0; i < n2; ++i) {
                    int n3;
                    VRMLKeyDeviceSensorNodeType vRMLKeyDeviceSensorNodeType = (VRMLKeyDeviceSensorNodeType)this.sensors.get(i);
                    if (!vRMLKeyDeviceSensorNodeType.getEnabled()) continue;
                    for (int j = n3 = vRMLKeyDeviceSensorNodeType.requiresLastEventOnly() ? n - 1 : 0; j < n; ++j) {
                        this.sendEvent(vRMLKeyDeviceSensorNodeType, this.keySequence.get(j));
                    }
                }
            }
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void addSensor(VRMLKeyDeviceSensorNodeType vRMLKeyDeviceSensorNodeType) {
        if (!this.keyNodes.contains(vRMLKeyDeviceSensorNodeType)) {
            this.keyNodes.add(vRMLKeyDeviceSensorNodeType);
            this.sensors.add(vRMLKeyDeviceSensorNodeType);
        }
    }

    public void removeSensor(VRMLKeyDeviceSensorNodeType vRMLKeyDeviceSensorNodeType) {
        if (this.keyNodes.contains(vRMLKeyDeviceSensorNodeType)) {
            this.keyNodes.remove(vRMLKeyDeviceSensorNodeType);
            this.sensors.remove(vRMLKeyDeviceSensorNodeType);
        }
    }

    private void sendEvent(VRMLKeyDeviceSensorNodeType vRMLKeyDeviceSensorNodeType, Xj3DKeyEvent xj3DKeyEvent) {
        try {
            switch (xj3DKeyEvent.getID()) {
                case 0x4B400000: {
                    vRMLKeyDeviceSensorNodeType.keyPressed(xj3DKeyEvent);
                    break;
                }
                case 1263009792: {
                    vRMLKeyDeviceSensorNodeType.keyReleased(xj3DKeyEvent);
                }
            }
        }
        catch (Exception exception) {
            this.errorReporter.warningReport("Error propogating key event", exception);
        }
    }
}

