/*
 * Decompiled with CFR 0.152.
 */
package vrml.field;

import vrml.Field;
import vrml.field.ConstSFImage;

public class SFImage
extends Field {
    protected int imageWidth;
    protected int imageHeight;
    protected int imageComponents;
    protected byte[] imagePixels;

    public SFImage() {
        this.imagePixels = new byte[0];
    }

    public SFImage(int n, int n2, int n3, byte[] byArray) {
        this.imageWidth = n;
        this.imageHeight = n;
        this.imageComponents = n3;
        this.imagePixels = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.imagePixels, 0, byArray.length);
    }

    public int getWidth() {
        return this.imageWidth;
    }

    public int getHeight() {
        return this.imageHeight;
    }

    public int getComponents() {
        return this.imageComponents;
    }

    public void getPixels(byte[] byArray) {
        System.arraycopy(this.imagePixels, 0, byArray, 0, this.imagePixels.length);
    }

    public void setValue(int n, int n2, int n3, byte[] byArray) {
        this.imageWidth = n;
        this.imageHeight = n;
        this.imageComponents = n3;
        if (byArray.length != this.imagePixels.length) {
            this.imagePixels = new byte[byArray.length];
        }
        System.arraycopy(byArray, 0, this.imagePixels, 0, byArray.length);
    }

    public void setValue(ConstSFImage constSFImage) {
        this.imageWidth = constSFImage.getWidth();
        this.imageHeight = constSFImage.getHeight();
        this.imageComponents = constSFImage.getComponents();
        int n = this.imageWidth * this.imageHeight * this.imageComponents;
        if (n != this.imagePixels.length) {
            this.imagePixels = new byte[n];
        }
        constSFImage.getPixels(this.imagePixels);
    }

    public void setValue(SFImage sFImage) {
        this.imageWidth = sFImage.getWidth();
        this.imageHeight = sFImage.getHeight();
        this.imageComponents = sFImage.getComponents();
        int n = this.imageWidth * this.imageHeight * this.imageComponents;
        if (n != this.imagePixels.length) {
            this.imagePixels = new byte[n];
        }
        sFImage.getPixels(this.imagePixels);
    }

    public String toString() {
        return null;
    }

    public Object clone() {
        return new SFImage(this.imageWidth, this.imageHeight, this.imageComponents, this.imagePixels);
    }
}

