/*
 * Decompiled with CFR 0.152.
 */
package vrml.field;

import vrml.MField;
import vrml.field.ConstMFString;
import vrml.field.ConstSFString;
import vrml.field.SFString;

public class MFString
extends MField {
    protected static final int ARRAY_INC = 5;
    protected String[] data;

    public MFString() {
        this.data = new String[5];
        this.numElements = 0;
    }

    public MFString(String[] stringArray) {
        this.numElements = stringArray.length;
        this.data = new String[this.numElements];
        System.arraycopy(stringArray, 0, this.data, 0, this.numElements);
    }

    public MFString(int n, String[] stringArray) {
        this.numElements = n;
        this.data = new String[n];
        System.arraycopy(stringArray, 0, this.data, 0, n);
    }

    public void getValue(String[] stringArray) {
        System.arraycopy(this.data, 0, stringArray, 0, this.numElements);
    }

    public String get1Value(int n) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        return this.data[n];
    }

    public void setValue(String[] stringArray) {
        if (stringArray.length > this.data.length) {
            this.data = new String[stringArray.length];
        }
        System.arraycopy(stringArray, 0, this.data, 0, stringArray.length);
        this.numElements = stringArray.length;
    }

    public void setValue(int n, String[] stringArray) {
        if (n > this.data.length) {
            this.data = new String[n];
        }
        System.arraycopy(stringArray, 0, this.data, 0, n);
        this.numElements = n;
    }

    public void setValue(MFString mFString) {
        int n = mFString.getSize();
        if (n > this.data.length) {
            this.data = new String[n];
        }
        mFString.getValue(this.data);
    }

    public void setValue(ConstMFString constMFString) {
        int n = constMFString.getSize();
        if (n > this.data.length) {
            this.data = new String[n];
        }
        constMFString.getValue(this.data);
    }

    public void set1Value(int n, String string) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.data[n] = string;
    }

    public void set1Value(int n, ConstSFString constSFString) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.data[n] = constSFString.getValue();
    }

    public void set1Value(int n, SFString sFString) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.data[n] = sFString.getValue();
    }

    public void addValue(String string) {
        this.realloc();
        this.data[this.numElements++] = string;
    }

    public void addValue(SFString sFString) {
        this.realloc();
        this.data[this.numElements++] = sFString.getValue();
    }

    public void addValue(ConstSFString constSFString) {
        this.realloc();
        this.data[this.numElements++] = constSFString.getValue();
    }

    public void insertValue(int n, String string) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.makeHole(n);
        this.data[n] = string;
        ++this.numElements;
    }

    public void insertValue(int n, ConstSFString constSFString) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.makeHole(n);
        this.data[n] = constSFString.getValue();
        ++this.numElements;
    }

    public void insertValue(int n, SFString sFString) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.makeHole(n);
        this.data[n] = sFString.getValue();
        ++this.numElements;
    }

    public void clear() {
        this.numElements = 0;
    }

    public void delete(int n) {
        if (n < 0 || n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Invalid index");
        }
        int n2 = n * 3;
        int n3 = this.numElements * 3 - n2;
        if (n3 != 0) {
            System.arraycopy(this.data, n2 + 3, this.data, n2, n3);
        }
        --this.numElements;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[\n  ");
        int n = 0;
        for (int i = 0; i < this.numElements; ++i) {
            stringBuffer.append(this.data[n++]);
            stringBuffer.append(' ');
            if (i % 6 != 0) continue;
            stringBuffer.append("\n  ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Object clone() {
        return new MFString(this.numElements, this.data);
    }

    private void realloc() {
        if (this.numElements >= this.data.length) {
            int n = this.numElements + 5;
            String[] stringArray = new String[n];
            System.arraycopy(this.data, 0, stringArray, 0, this.data.length);
            this.data = stringArray;
        }
    }

    private void makeHole(int n) {
        int n2 = this.numElements - n;
        if (this.numElements >= this.data.length) {
            int n3 = this.numElements + 5;
            String[] stringArray = new String[n3];
            System.arraycopy(this.data, 0, stringArray, 0, n - 1);
            System.arraycopy(this.data, n, stringArray, n + 1, n2);
            this.data = stringArray;
        } else {
            System.arraycopy(this.data, n, this.data, n + 1, n2);
        }
    }
}

