/*
 * Decompiled with CFR 0.152.
 */
package vrml.field;

import org.web3d.util.ArrayUtils;
import vrml.MField;
import vrml.field.ConstMFRotation;
import vrml.field.ConstSFRotation;
import vrml.field.SFRotation;

public class MFRotation
extends MField {
    protected static final int ARRAY_INC = 20;
    protected float[] data;
    private float[] tmpField = new float[4];

    public MFRotation() {
        this.data = new float[20];
        this.numElements = 0;
    }

    public MFRotation(float[][] fArray) {
        this.data = new float[fArray.length * 4];
        ArrayUtils.flatten2(fArray, fArray.length, this.data);
        this.numElements = fArray.length;
    }

    public MFRotation(float[] fArray) {
        if (fArray.length < 4) {
            throw new IllegalArgumentException("Array length less than 4");
        }
        this.numElements = fArray.length / 4;
        int n = this.numElements * 4;
        this.data = new float[n];
        System.arraycopy(fArray, 0, this.data, 0, n);
    }

    public MFRotation(int n, float[] fArray) {
        if (fArray.length < 4) {
            throw new IllegalArgumentException("Array length less than 4");
        }
        this.numElements = n / 4;
        this.data = new float[fArray.length];
        System.arraycopy(fArray, 0, this.data, 0, fArray.length);
    }

    public void getValue(float[][] fArray) {
        ArrayUtils.raise4(this.data, this.numElements, fArray);
    }

    public void getValue(float[] fArray) {
        System.arraycopy(this.data, 0, fArray, 0, this.numElements * 4);
    }

    public void get1Value(int n, float[] fArray) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        int n2 = n * 4;
        fArray[0] = this.data[n2++];
        fArray[1] = this.data[n2++];
        fArray[2] = this.data[n2++];
        fArray[3] = this.data[n2];
    }

    public void get1Value(int n, SFRotation sFRotation) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        int n2 = n * 4;
        sFRotation.setValue(this.data[n2], this.data[n2 + 1], this.data[n2 + 2], this.data[n2 + 3]);
    }

    public void setValue(float[][] fArray) {
        if (fArray.length > this.numElements) {
            this.data = new float[fArray.length * 4];
        }
        this.numElements = fArray.length;
        ArrayUtils.flatten4(fArray, this.numElements, this.data);
    }

    public void setValue(float[] fArray) {
        int n = fArray.length / 4;
        if (n > this.numElements) {
            this.data = new float[n * 4];
        }
        this.numElements = n;
        System.arraycopy(fArray, 0, this.data, 0, n * 4);
    }

    public void setValue(int n, float[] fArray) {
        if (n > this.data.length) {
            this.data = new float[n];
        }
        this.numElements = n / 4;
        System.arraycopy(fArray, 0, this.data, 0, n);
    }

    public void setValue(MFRotation mFRotation) {
        int n = mFRotation.getSize();
        if (n > this.numElements) {
            this.data = new float[n * 4];
        }
        this.numElements = n;
        mFRotation.getValue(this.data);
    }

    public void setValue(ConstMFRotation constMFRotation) {
        int n = constMFRotation.getSize();
        if (n > this.numElements) {
            this.data = new float[n * 4];
        }
        this.numElements = n;
        constMFRotation.getValue(this.data);
    }

    public void set1Value(int n, ConstSFRotation constSFRotation) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        int n2 = n * 4;
        constSFRotation.getValue(this.tmpField);
        this.data[n2++] = this.tmpField[0];
        this.data[n2++] = this.tmpField[1];
        this.data[n2++] = this.tmpField[2];
        this.data[n2] = this.tmpField[3];
    }

    public void set1Value(int n, SFRotation sFRotation) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        int n2 = n * 4;
        sFRotation.getValue(this.tmpField);
        this.data[n2++] = this.tmpField[0];
        this.data[n2++] = this.tmpField[1];
        this.data[n2++] = this.tmpField[2];
        this.data[n2] = this.tmpField[3];
    }

    public void set1Value(int n, float f, float f2, float f3, float f4) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        int n2 = n * 4;
        this.data[n2++] = f;
        this.data[n2++] = f2;
        this.data[n2++] = f3;
        this.data[n2] = f4;
    }

    public void addValue(ConstSFRotation constSFRotation) {
        int n = this.numElements * 4;
        this.realloc();
        ++this.numElements;
        constSFRotation.getValue(this.tmpField);
        this.data[n++] = this.tmpField[0];
        this.data[n++] = this.tmpField[1];
        this.data[n++] = this.tmpField[2];
        this.data[n] = this.tmpField[3];
    }

    public void addValue(SFRotation sFRotation) {
        int n = this.numElements * 4;
        this.realloc();
        ++this.numElements;
        sFRotation.getValue(this.tmpField);
        this.data[n++] = this.tmpField[0];
        this.data[n++] = this.tmpField[1];
        this.data[n++] = this.tmpField[2];
        this.data[n] = this.tmpField[3];
    }

    public void addValue(float f, float f2, float f3, float f4) {
        int n = this.numElements * 4;
        this.realloc();
        ++this.numElements;
        this.data[n++] = f;
        this.data[n++] = f2;
        this.data[n++] = f3;
        this.data[n] = f4;
    }

    public void insertValue(int n, ConstSFRotation constSFRotation) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        int n2 = n * 4;
        this.makeHole(n2);
        ++this.numElements;
        constSFRotation.getValue(this.tmpField);
        this.data[n2++] = this.tmpField[0];
        this.data[n2++] = this.tmpField[1];
        this.data[n2++] = this.tmpField[2];
        this.data[n2] = this.tmpField[3];
    }

    public void insertValue(int n, SFRotation sFRotation) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        int n2 = n * 4;
        this.makeHole(n2);
        ++this.numElements;
        sFRotation.getValue(this.tmpField);
        this.data[n2++] = this.tmpField[0];
        this.data[n2++] = this.tmpField[1];
        this.data[n2++] = this.tmpField[2];
        this.data[n2] = this.tmpField[3];
    }

    public void insertValue(int n, float f, float f2, float f3, float f4) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        int n2 = n * 4;
        this.makeHole(n2);
        ++this.numElements;
        this.data[n2++] = f;
        this.data[n2++] = f2;
        this.data[n2++] = f3;
        this.data[n2] = f4;
    }

    public void clear() {
        this.numElements = 0;
    }

    public void delete(int n) {
        if (n < 0 || n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Invalid index");
        }
        int n2 = n * 4;
        int n3 = this.numElements * 4 - n2;
        if (n3 != 0) {
            System.arraycopy(this.data, n2 + 4, this.data, n2, n3);
        }
        --this.numElements;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[\n  ");
        int n = 0;
        for (int i = 0; i < this.numElements; ++i) {
            stringBuffer.append(this.data[n++]);
            stringBuffer.append(' ');
            stringBuffer.append(this.data[n++]);
            stringBuffer.append(' ');
            stringBuffer.append(this.data[n++]);
            stringBuffer.append(' ');
            stringBuffer.append(this.data[n++]);
            stringBuffer.append(' ');
            if (i % 4 != 0) continue;
            stringBuffer.append("\n  ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Object clone() {
        return new MFRotation(this.numElements * 4, this.data);
    }

    private void realloc() {
        int n = this.numElements * 4;
        if (n >= this.data.length) {
            int n2 = n + 20;
            float[] fArray = new float[n2];
            System.arraycopy(this.data, 0, fArray, 0, this.data.length);
            this.data = fArray;
        }
    }

    private void makeHole(int n) {
        int n2 = this.numElements * 4;
        int n3 = n2 - n;
        if (n2 >= this.data.length) {
            int n4 = n2 + 20;
            float[] fArray = new float[n4];
            System.arraycopy(this.data, 0, fArray, 0, n - 1);
            System.arraycopy(this.data, n, fArray, n + 4, n3);
            this.data = fArray;
        } else {
            System.arraycopy(this.data, n, this.data, n + 4, n3);
        }
    }
}

