/*
 * Decompiled with CFR 0.152.
 */
package vrml.field;

import vrml.MField;
import vrml.field.ConstMFFloat;
import vrml.field.ConstSFFloat;
import vrml.field.SFFloat;

public class MFFloat
extends MField {
    protected static final int ARRAY_INC = 5;
    protected float[] data;

    public MFFloat() {
        this.data = new float[5];
        this.numElements = 0;
    }

    public MFFloat(float[] fArray) {
        this.numElements = fArray.length;
        this.data = new float[this.numElements];
        System.arraycopy(fArray, 0, this.data, 0, this.numElements);
    }

    public MFFloat(int n, float[] fArray) {
        this.numElements = n;
        this.data = new float[n];
        System.arraycopy(fArray, 0, this.data, 0, n);
    }

    public void getValue(float[] fArray) {
        System.arraycopy(this.data, 0, fArray, 0, this.numElements);
    }

    public float get1Value(int n) {
        if (n >= this.numElements) {
            throw new IllegalArgumentException("Index > numElements");
        }
        return this.data[n];
    }

    public void setValue(float[] fArray) {
        if (fArray.length > this.data.length) {
            this.data = new float[fArray.length];
        }
        System.arraycopy(fArray, 0, this.data, 0, fArray.length);
        this.numElements = fArray.length;
    }

    public void setValue(int n, float[] fArray) {
        if (n > this.data.length) {
            this.data = new float[n];
        }
        System.arraycopy(fArray, 0, this.data, 0, n);
        this.numElements = n;
    }

    public void setValue(MFFloat mFFloat) {
        int n = mFFloat.getSize();
        if (n > this.data.length) {
            this.data = new float[n];
        }
        mFFloat.getValue(this.data);
    }

    public void setValue(ConstMFFloat constMFFloat) {
        int n = constMFFloat.getSize();
        if (n > this.data.length) {
            this.data = new float[n];
        }
        constMFFloat.getValue(this.data);
    }

    public void set1Value(int n, float f) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.data[n] = f;
    }

    public void set1Value(int n, ConstSFFloat constSFFloat) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.data[n] = constSFFloat.getValue();
    }

    public void set1Value(int n, SFFloat sFFloat) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.data[n] = sFFloat.getValue();
    }

    public void addValue(float f) {
        this.realloc();
        this.data[this.numElements++] = f;
    }

    public void addValue(SFFloat sFFloat) {
        this.realloc();
        this.data[this.numElements++] = sFFloat.getValue();
    }

    public void addValue(ConstSFFloat constSFFloat) {
        this.realloc();
        this.data[this.numElements++] = constSFFloat.getValue();
    }

    public void insertValue(int n, float f) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.makeHole(n);
        this.data[n] = f;
        ++this.numElements;
    }

    public void insertValue(int n, ConstSFFloat constSFFloat) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.makeHole(n);
        this.data[n] = constSFFloat.getValue();
        ++this.numElements;
    }

    public void insertValue(int n, SFFloat sFFloat) {
        if (n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Index > numElements");
        }
        this.makeHole(n);
        this.data[n] = sFFloat.getValue();
        ++this.numElements;
    }

    public void clear() {
        this.numElements = 0;
    }

    public void delete(int n) {
        if (n < 0 || n >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException("Invalid index");
        }
        int n2 = n * 3;
        int n3 = this.numElements * 3 - n2;
        if (n3 != 0) {
            System.arraycopy(this.data, n2 + 3, this.data, n2, n3);
        }
        --this.numElements;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[\n  ");
        int n = 0;
        for (int i = 0; i < this.numElements; ++i) {
            stringBuffer.append(this.data[n++]);
            stringBuffer.append(' ');
            if (i % 6 != 0) continue;
            stringBuffer.append("\n  ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Object clone() {
        return new MFFloat(this.numElements, this.data);
    }

    private void realloc() {
        if (this.numElements >= this.data.length) {
            int n = this.numElements + 5;
            float[] fArray = new float[n];
            System.arraycopy(this.data, 0, fArray, 0, this.data.length);
            this.data = fArray;
        }
    }

    private void makeHole(int n) {
        int n2 = this.numElements - n;
        if (this.numElements >= this.data.length) {
            int n3 = this.numElements + 5;
            float[] fArray = new float[n3];
            System.arraycopy(this.data, 0, fArray, 0, n - 1);
            System.arraycopy(this.data, n, fArray, n + 1, n2);
            this.data = fArray;
        } else {
            System.arraycopy(this.data, n, this.data, n + 1, n2);
        }
    }
}

