/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.jsai;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.web3d.util.HashSet;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLScriptNodeType;
import org.web3d.vrml.scripting.ScriptWrapper;
import org.web3d.vrml.scripting.jsai.FieldFactory;
import org.web3d.vrml.scripting.jsai.JSAIFieldFactory;
import org.web3d.vrml.scripting.jsai.JSAINode;
import org.web3d.vrml.scripting.jsai.NodeField;
import org.web3d.vrml.scripting.jsai.VRML97ScriptEvent;
import vrml.BaseNode;
import vrml.Browser;
import vrml.ConstField;
import vrml.Field;
import vrml.field.ConstMFFloat;
import vrml.field.ConstMFInt32;
import vrml.field.ConstMFNode;
import vrml.field.ConstMFString;
import vrml.field.ConstSFBool;
import vrml.field.ConstSFColor;
import vrml.field.ConstSFFloat;
import vrml.field.ConstSFInt32;
import vrml.field.ConstSFNode;
import vrml.field.ConstSFRotation;
import vrml.field.ConstSFString;
import vrml.field.ConstSFTime;
import vrml.field.ConstSFVec2f;
import vrml.field.ConstSFVec3f;
import vrml.node.Node;
import vrml.node.Script;

public class VRML97ScriptWrapper
implements ScriptWrapper {
    private Script script;
    private ArrayList pendingEvents;
    private LinkedList unusedEvents;
    private VRML97ScriptEvent[] eventArray;
    private double timestamp;
    private Browser browser;
    private FieldFactory fieldFactory;
    private boolean initialized;
    private boolean hadInputEvent;
    private HashSet eventOuts;

    public VRML97ScriptWrapper(Script script, Browser browser) {
        if (script == null || browser == null) {
            throw new IllegalArgumentException("Bad script init. Null node");
        }
        this.script = script;
        this.browser = browser;
        this.fieldFactory = new JSAIFieldFactory();
        this.initialized = false;
        this.hadInputEvent = false;
    }

    public void initialize(VRMLScriptNodeType vRMLScriptNodeType) {
        this.eventOuts = new HashSet();
        List list = vRMLScriptNodeType.getAllFields();
        Iterator iterator = list.iterator();
        HashMap<String, Field> hashMap = new HashMap<String, Field>();
        while (iterator.hasNext()) {
            Field field;
            VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)iterator.next();
            String string = vRMLFieldDeclaration.getName();
            if (vRMLFieldDeclaration.getAccessType() == 4) {
                this.eventOuts.add(string);
            }
            if ((field = this.fieldFactory.createField(vRMLScriptNodeType, string, false)) instanceof NodeField) {
                ((NodeField)((Object)field)).initialize(this.browser, this.fieldFactory);
            }
            hashMap.put(string, field);
        }
        this.pendingEvents = new ArrayList(vRMLScriptNodeType.getFieldCount());
        this.unusedEvents = new LinkedList();
        this.eventArray = new VRML97ScriptEvent[vRMLScriptNodeType.getFieldCount()];
        this.initialized = true;
        this.script.prepareScript(this.browser, hashMap, vRMLScriptNodeType);
        this.script.initialize();
    }

    public void setTimestamp(double d) {
        this.timestamp = d;
    }

    public boolean prepareEvents() {
        return false;
    }

    public void queueEvent(int n, String string, int n2) {
        if (!this.initialized || this.eventOuts.contains(string)) {
            return;
        }
        VRML97ScriptEvent vRML97ScriptEvent = this.getUnusedEvent();
        ConstSFInt32 constSFInt32 = new ConstSFInt32(n2);
        vRML97ScriptEvent.reInit(string, this.timestamp, constSFInt32);
        this.pendingEvents.add(vRML97ScriptEvent);
    }

    public void queueEvent(int n, String string, int[] nArray, int n2) {
        if (!this.initialized || this.eventOuts.contains(string)) {
            return;
        }
        VRML97ScriptEvent vRML97ScriptEvent = this.getUnusedEvent();
        ConstMFInt32 constMFInt32 = new ConstMFInt32(nArray);
        vRML97ScriptEvent.reInit(string, this.timestamp, constMFInt32);
        this.pendingEvents.add(vRML97ScriptEvent);
    }

    public void queueEvent(int n, String string, long l) {
    }

    public void queueEvent(int n, String string, long[] lArray, int n2) {
    }

    public void queueEvent(int n, String string, boolean bl) {
        if (!this.initialized || this.eventOuts.contains(string)) {
            return;
        }
        VRML97ScriptEvent vRML97ScriptEvent = this.getUnusedEvent();
        ConstSFBool constSFBool = new ConstSFBool(bl);
        vRML97ScriptEvent.reInit(string, this.timestamp, constSFBool);
        this.pendingEvents.add(vRML97ScriptEvent);
    }

    public void queueEvent(int n, String string, boolean[] blArray, int n2) {
    }

    public void queueEvent(int n, String string, float f) {
        if (!this.initialized || this.eventOuts.contains(string)) {
            return;
        }
        VRML97ScriptEvent vRML97ScriptEvent = this.getUnusedEvent();
        ConstSFFloat constSFFloat = new ConstSFFloat(f);
        vRML97ScriptEvent.reInit(string, this.timestamp, constSFFloat);
        this.pendingEvents.add(vRML97ScriptEvent);
    }

    public void queueEvent(int n, String string, float[] fArray, int n2) {
        if (!this.initialized || this.eventOuts.contains(string)) {
            return;
        }
        VRML97ScriptEvent vRML97ScriptEvent = this.getUnusedEvent();
        ConstField constField = null;
        switch (n) {
            case 21: {
                constField = new ConstSFColor(fArray[0], fArray[1], fArray[2]);
                break;
            }
            case 19: {
                constField = new ConstSFRotation(fArray[0], fArray[1], fArray[2], fArray[3]);
                break;
            }
            case 13: {
                constField = new ConstSFVec2f(fArray[0], fArray[1]);
                break;
            }
            case 15: {
                constField = new ConstSFVec3f(fArray[0], fArray[1], fArray[2]);
                break;
            }
            case 6: {
                constField = new ConstMFFloat(fArray);
                break;
            }
            default: {
                System.err.println("Invalid field queue type in float[]");
                return;
            }
        }
        vRML97ScriptEvent.reInit(string, this.timestamp, constField);
        this.pendingEvents.add(vRML97ScriptEvent);
    }

    public void queueEvent(int n, String string, double d) {
        if (!this.initialized || this.eventOuts.contains(string)) {
            return;
        }
        VRML97ScriptEvent vRML97ScriptEvent = this.getUnusedEvent();
        ConstSFTime constSFTime = new ConstSFTime(d);
        vRML97ScriptEvent.reInit(string, this.timestamp, constSFTime);
        this.pendingEvents.add(vRML97ScriptEvent);
    }

    public void queueEvent(int n, String string, double[] dArray, int n2) {
    }

    public void queueEvent(int n, String string, String string2) {
        if (!this.initialized || this.eventOuts.contains(string)) {
            return;
        }
        VRML97ScriptEvent vRML97ScriptEvent = this.getUnusedEvent();
        ConstSFString constSFString = new ConstSFString(string2);
        vRML97ScriptEvent.reInit(string, this.timestamp, constSFString);
        this.pendingEvents.add(vRML97ScriptEvent);
    }

    public void queueEvent(int n, String string, String[] stringArray, int n2) {
        if (!this.initialized || this.eventOuts.contains(string)) {
            return;
        }
        VRML97ScriptEvent vRML97ScriptEvent = this.getUnusedEvent();
        ConstMFString constMFString = new ConstMFString(stringArray);
        vRML97ScriptEvent.reInit(string, this.timestamp, constMFString);
        this.pendingEvents.add(vRML97ScriptEvent);
    }

    public void queueEvent(int n, String string, VRMLNodeType vRMLNodeType) {
        if (!this.initialized || this.eventOuts.contains(string)) {
            return;
        }
        VRML97ScriptEvent vRML97ScriptEvent = this.getUnusedEvent();
        JSAINode jSAINode = new JSAINode(vRMLNodeType, this.browser, this.fieldFactory);
        ConstSFNode constSFNode = new ConstSFNode(jSAINode);
        vRML97ScriptEvent.reInit(string, this.timestamp, constSFNode);
        this.pendingEvents.add(vRML97ScriptEvent);
    }

    public void queueEvent(int n, String string, VRMLNodeType[] vRMLNodeTypeArray, int n2) {
        if (!this.initialized || this.eventOuts.contains(string)) {
            return;
        }
        VRML97ScriptEvent vRML97ScriptEvent = this.getUnusedEvent();
        BaseNode[] baseNodeArray = new Node[vRMLNodeTypeArray.length];
        for (int i = 0; i < vRMLNodeTypeArray.length; ++i) {
            baseNodeArray[i] = new JSAINode(vRMLNodeTypeArray[i], this.browser, this.fieldFactory);
        }
        ConstMFNode constMFNode = new ConstMFNode(baseNodeArray);
        vRML97ScriptEvent.reInit(string, this.timestamp, constMFNode);
        this.pendingEvents.add(vRML97ScriptEvent);
    }

    public boolean sendEvents() {
        if (!this.initialized) {
            return false;
        }
        int n = this.pendingEvents.size();
        if (n == 0) {
            return false;
        }
        if (n > this.eventArray.length) {
            this.eventArray = new VRML97ScriptEvent[n];
        }
        this.hadInputEvent = true;
        this.pendingEvents.toArray(this.eventArray);
        try {
            this.script.processEvents(n, this.eventArray);
        }
        catch (Throwable throwable) {
            System.err.println("Error during script event propogation");
            System.err.println(throwable.getMessage());
            throwable.printStackTrace();
        }
        this.unusedEvents.addAll(this.pendingEvents);
        this.pendingEvents.clear();
        return false;
    }

    public void updateEventOuts() {
    }

    public void eventsProcessed() {
        if (!this.hadInputEvent) {
            return;
        }
        this.hadInputEvent = false;
        try {
            this.script.eventsProcessed();
        }
        catch (Throwable throwable) {
            System.err.println("Error during script event propogation");
            System.err.println(throwable.getMessage());
            throwable.printStackTrace();
        }
    }

    public void shutdown() {
        this.script.shutdown();
        this.script = null;
    }

    private VRML97ScriptEvent getUnusedEvent() {
        VRML97ScriptEvent vRML97ScriptEvent = null;
        vRML97ScriptEvent = this.unusedEvents.size() == 0 ? new VRML97ScriptEvent() : (VRML97ScriptEvent)this.unusedEvents.remove(0);
        return vRML97ScriptEvent;
    }
}

