/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.jsai;

import java.util.WeakHashMap;
import org.web3d.browser.BrowserCore;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.scripting.jsai.ScriptBrowser;
import org.xj3d.core.eventmodel.RouteManager;
import org.xj3d.core.loading.WorldLoaderManager;
import vrml.Browser;

class VRML97ScriptBrowserFactory {
    private ErrorReporter errorReporter;
    private BrowserCore core;
    private RouteManager routeManager;
    private WeakHashMap browsers;
    private WorldLoaderManager loadManager;
    private FrameStateManager stateManager;

    VRML97ScriptBrowserFactory(BrowserCore browserCore, RouteManager routeManager, FrameStateManager frameStateManager, WorldLoaderManager worldLoaderManager) {
        this.core = browserCore;
        this.routeManager = routeManager;
        this.loadManager = worldLoaderManager;
        this.stateManager = frameStateManager;
        this.browsers = new WeakHashMap();
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public Browser getBrowser(VRMLExecutionSpace vRMLExecutionSpace) {
        Browser browser = (Browser)this.browsers.get(vRMLExecutionSpace);
        if (browser == null) {
            browser = new ScriptBrowser(vRMLExecutionSpace, this.core, this.routeManager, this.stateManager, this.loadManager);
            ((ScriptBrowser)browser).setErrorReporter(this.errorReporter);
            this.browsers.put(vRMLExecutionSpace, browser);
        }
        return browser;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }
}

