/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.jsai;

import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import vrml.field.ConstSFVec3f;
import vrml.field.SFVec3f;

class JSAISFVec3f
extends SFVec3f
implements VRMLNodeListener {
    private VRMLNodeType node;
    private int fieldIndex;

    JSAISFVec3f(VRMLNodeType vRMLNodeType, int n) {
        this.node = vRMLNodeType;
        this.fieldIndex = n;
        this.valueChanged = true;
        this.updateLocalData();
        this.node.addNodeListener(this);
    }

    public void getValue(float[] fArray) {
        this.updateLocalData();
        fArray[0] = this.data[0];
        fArray[1] = this.data[1];
        fArray[2] = this.data[2];
    }

    public void setValue(float[] fArray) {
        this.data[0] = fArray[0];
        this.data[1] = fArray[1];
        this.data[2] = fArray[2];
        try {
            this.node.setValue(this.fieldIndex, fArray, 3);
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    public void setValue(float f, float f2, float f3) {
        this.data[0] = f;
        this.data[1] = f2;
        this.data[2] = f3;
        try {
            this.node.setValue(this.fieldIndex, this.data, 3);
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    public void setValue(ConstSFVec3f constSFVec3f) {
        constSFVec3f.getValue(this.data);
        try {
            this.node.setValue(this.fieldIndex, this.data, 3);
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    public void setValue(SFVec3f sFVec3f) {
        sFVec3f.getValue(this.data);
        try {
            this.node.setValue(this.fieldIndex, this.data, 3);
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    public Object clone() {
        return new JSAISFVec3f(this.node, this.fieldIndex);
    }

    public void fieldChanged(int n) {
        if (n != this.fieldIndex) {
            return;
        }
        this.valueChanged = true;
    }

    private void updateLocalData() {
        if (!this.valueChanged) {
            return;
        }
        try {
            VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
            if (vRMLFieldData == null || vRMLFieldData.numElements == 0) {
                this.data[0] = 0.0f;
                this.data[1] = 0.0f;
                this.data[2] = 0.0f;
            } else {
                this.data[0] = vRMLFieldData.floatArrayValue[0];
                this.data[1] = vRMLFieldData.floatArrayValue[1];
                this.data[2] = vRMLFieldData.floatArrayValue[2];
            }
            this.valueChanged = false;
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }
}

