/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.jsai;

import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import vrml.field.ConstSFBool;
import vrml.field.SFBool;

class JSAISFBool
extends SFBool
implements VRMLNodeListener {
    private VRMLNodeType node;
    private int fieldIndex;

    JSAISFBool(VRMLNodeType vRMLNodeType, int n) {
        this.node = vRMLNodeType;
        this.fieldIndex = n;
        this.valueChanged = true;
        this.updateLocalData();
        this.node.addNodeListener(this);
    }

    public boolean getValue() {
        this.updateLocalData();
        return this.data;
    }

    public void setValue(boolean bl) {
        this.data = bl;
        try {
            this.node.setValue(this.fieldIndex, bl);
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    public void setValue(SFBool sFBool) {
        this.data = sFBool.getValue();
        try {
            this.node.setValue(this.fieldIndex, this.data);
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    public void setValue(ConstSFBool constSFBool) {
        this.data = constSFBool.getValue();
        try {
            this.node.setValue(this.fieldIndex, this.data);
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    public Object clone() {
        return new JSAISFBool(this.node, this.fieldIndex);
    }

    public void fieldChanged(int n) {
        if (n != this.fieldIndex) {
            return;
        }
        this.valueChanged = true;
    }

    private void updateLocalData() {
        if (!this.valueChanged) {
            return;
        }
        try {
            VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
            this.data = vRMLFieldData == null ? false : vRMLFieldData.booleanValue;
            this.valueChanged = false;
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }
}

