/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.jsai;

import java.util.HashMap;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.jsai.FieldFactory;
import org.web3d.vrml.scripting.jsai.NodeField;
import vrml.Browser;
import vrml.ConstField;
import vrml.Field;
import vrml.node.Node;

public class JSAINode
extends Node {
    private HashMap fieldMap;
    private HashMap constMap;
    private FieldFactory fieldFactory;

    public JSAINode(VRMLNodeType vRMLNodeType, Browser browser, FieldFactory fieldFactory) {
        if (vRMLNodeType == null) {
            throw new NullPointerException("Node reference null");
        }
        if (browser == null) {
            throw new NullPointerException("Browser reference is null");
        }
        this.realNode = vRMLNodeType;
        this.browser = browser;
        this.fieldFactory = fieldFactory;
        this.nodeName = vRMLNodeType.getVRMLNodeName();
        this.fieldMap = new HashMap();
        this.constMap = new HashMap();
    }

    FieldFactory getFieldFactory() {
        return this.fieldFactory;
    }

    protected Field createField(String string, boolean bl) {
        Field field = (Field)this.fieldMap.get(string);
        if (field == null) {
            field = this.fieldFactory.createField(this.realNode, string, bl);
            this.fieldMap.put(string, field);
            if (field instanceof NodeField) {
                ((NodeField)((Object)field)).initialize(this.browser, this.fieldFactory);
            }
        }
        return field;
    }

    protected ConstField createConstField(String string) {
        ConstField constField = (ConstField)this.constMap.get(string);
        if (constField == null) {
            constField = this.fieldFactory.createConstField(this.realNode, string);
            this.constMap.put(string, constField);
            if (constField instanceof NodeField) {
                ((NodeField)((Object)constField)).initialize(this.browser, this.fieldFactory);
            }
        }
        return constField;
    }
}

