/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.jsai;

import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.jsai.JSAIMFVec2f;
import vrml.field.ConstMFVec3f;
import vrml.field.ConstSFVec3f;
import vrml.field.MFVec3f;
import vrml.field.SFVec3f;

class JSAIMFVec3f
extends MFVec3f
implements VRMLNodeListener {
    private VRMLNodeType node;
    private int fieldIndex;

    JSAIMFVec3f(VRMLNodeType vRMLNodeType, int n) {
        this.node = vRMLNodeType;
        this.fieldIndex = n;
        this.valueChanged = true;
        this.updateLocalData();
        this.node.addNodeListener(this);
    }

    public void getValue(float[][] fArray) {
        this.updateLocalData();
        super.getValue(fArray);
    }

    public void getValue(float[] fArray) {
        this.updateLocalData();
        super.getValue(fArray);
    }

    public void get1Value(int n, float[] fArray) {
        this.updateLocalData();
        super.get1Value(n, fArray);
    }

    public void get1Value(int n, SFVec3f sFVec3f) {
        this.updateLocalData();
        super.get1Value(n, sFVec3f);
    }

    public void setValue(float[][] fArray) {
        super.setValue(fArray);
        this.updateCoreData();
    }

    public void setValue(float[] fArray) {
        super.setValue(fArray);
        this.updateCoreData();
    }

    public void setValue(int n, float[] fArray) {
        super.setValue(n, fArray);
        this.updateCoreData();
    }

    public void setValue(MFVec3f mFVec3f) {
        super.setValue(mFVec3f);
        this.updateCoreData();
    }

    public void setValue(ConstMFVec3f constMFVec3f) {
        super.setValue(constMFVec3f);
        this.updateCoreData();
    }

    public void set1Value(int n, ConstSFVec3f constSFVec3f) {
        super.set1Value(n, constSFVec3f);
        this.updateCoreData();
    }

    public void set1Value(int n, SFVec3f sFVec3f) {
        super.set1Value(n, sFVec3f);
        this.updateCoreData();
    }

    public void set1Value(int n, float f, float f2, float f3) {
        super.set1Value(n, f, f2, f3);
        this.updateCoreData();
    }

    public void addValue(ConstSFVec3f constSFVec3f) {
        super.addValue(constSFVec3f);
        this.updateCoreData();
    }

    public void addValue(SFVec3f sFVec3f) {
        super.addValue(sFVec3f);
        this.updateCoreData();
    }

    public void addValue(float f, float f2, float f3) {
        super.addValue(f, f2, f3);
        this.updateCoreData();
    }

    public void insertValue(int n, ConstSFVec3f constSFVec3f) {
        super.insertValue(n, constSFVec3f);
        this.updateCoreData();
    }

    public void insertValue(int n, SFVec3f sFVec3f) {
        super.insertValue(n, sFVec3f);
        this.updateCoreData();
    }

    public void insertValue(int n, float f, float f2, float f3) {
        super.insertValue(n, f, f2, f3);
        this.updateCoreData();
    }

    public void clear() {
        System.out.println("JSAIMFVec3f clear not implemented yet");
    }

    public void delete(int n) {
        super.delete(n);
        this.updateCoreData();
    }

    public String toString() {
        this.updateLocalData();
        return super.toString();
    }

    public Object clone() {
        return new JSAIMFVec2f(this.node, this.fieldIndex);
    }

    public void fieldChanged(int n) {
        if (n != this.fieldIndex) {
            return;
        }
        this.valueChanged = true;
    }

    private void updateLocalData() {
        if (!this.valueChanged) {
            return;
        }
        try {
            VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
            if (vRMLFieldData == null) {
                return;
            }
            if (vRMLFieldData.numElements == 0) {
                this.numElements = 0;
                this.data = new float[0];
            } else {
                super.setValue(vRMLFieldData.numElements * 3, vRMLFieldData.floatArrayValue);
            }
            this.valueChanged = false;
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    private void updateCoreData() {
        try {
            this.node.setValue(this.fieldIndex, this.data, this.numElements * 3);
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }
}

