/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.jsai;

import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import vrml.field.ConstMFRotation;
import vrml.field.ConstSFRotation;
import vrml.field.MFRotation;
import vrml.field.SFRotation;

class JSAIMFRotation
extends MFRotation
implements VRMLNodeListener {
    private VRMLNodeType node;
    private int fieldIndex;

    JSAIMFRotation(VRMLNodeType vRMLNodeType, int n) {
        this.node = vRMLNodeType;
        this.fieldIndex = n;
        this.valueChanged = true;
        this.updateLocalData();
        this.node.addNodeListener(this);
    }

    public void getValue(float[] fArray) {
        this.updateLocalData();
        super.getValue(fArray);
    }

    public void get1Value(int n, float[] fArray) {
        this.updateLocalData();
        super.get1Value(n, fArray);
    }

    public void get1Value(int n, SFRotation sFRotation) {
        this.updateLocalData();
        super.get1Value(n, sFRotation);
    }

    public void setValue(float[][] fArray) {
        super.setValue(fArray);
        this.updateCoreData();
    }

    public void setValue(float[] fArray) {
        super.setValue(fArray);
        this.updateCoreData();
    }

    public void setValue(int n, float[] fArray) {
        super.setValue(n, fArray);
        this.updateCoreData();
    }

    public void setValue(MFRotation mFRotation) {
        super.setValue(mFRotation);
        this.updateCoreData();
    }

    public void setValue(ConstMFRotation constMFRotation) {
        super.setValue(constMFRotation);
        this.updateCoreData();
    }

    public void set1Value(int n, ConstSFRotation constSFRotation) {
        super.set1Value(n, constSFRotation);
        this.updateCoreData();
    }

    public void set1Value(int n, float f, float f2, float f3, float f4) {
        super.set1Value(n, f, f2, f3, f4);
        this.updateCoreData();
    }

    public void addValue(ConstSFRotation constSFRotation) {
        super.addValue(constSFRotation);
        this.updateCoreData();
    }

    public void addValue(SFRotation sFRotation) {
        super.addValue(sFRotation);
        this.updateCoreData();
    }

    public void addValue(float f, float f2, float f3, float f4) {
        super.addValue(f, f2, f3, f4);
        this.updateCoreData();
    }

    public void insertValue(int n, ConstSFRotation constSFRotation) {
        super.insertValue(n, constSFRotation);
        this.updateCoreData();
    }

    public void insertValue(int n, SFRotation sFRotation) {
        super.insertValue(n, sFRotation);
        this.updateCoreData();
    }

    public void insertValue(int n, float f, float f2, float f3, float f4) {
        super.insertValue(n, f, f2, f3, f4);
        this.updateCoreData();
    }

    public void clear() {
        System.out.println("JSAIMFRotation clear not implemented yet");
    }

    public void delete(int n) {
        super.delete(n);
        this.updateCoreData();
    }

    public String toString() {
        this.updateLocalData();
        return super.toString();
    }

    public Object clone() {
        return new JSAIMFRotation(this.node, this.fieldIndex);
    }

    public void fieldChanged(int n) {
        if (n != this.fieldIndex) {
            return;
        }
        this.valueChanged = true;
    }

    private void updateLocalData() {
        if (!this.valueChanged) {
            return;
        }
        try {
            VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
            if (vRMLFieldData == null) {
                return;
            }
            if (vRMLFieldData.numElements == 0) {
                this.numElements = 0;
                this.data = new float[0];
            } else {
                super.setValue(vRMLFieldData.numElements * 4, vRMLFieldData.floatArrayValue);
            }
            this.valueChanged = false;
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    private void updateCoreData() {
        try {
            this.node.setValue(this.fieldIndex, this.data, this.numElements * 4);
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }
}

