/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.jsai;

import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.jsai.FieldFactory;
import org.web3d.vrml.scripting.jsai.JSAINode;
import org.web3d.vrml.scripting.jsai.NodeField;
import vrml.BaseNode;
import vrml.Browser;
import vrml.field.ConstMFNode;
import vrml.field.ConstSFNode;
import vrml.field.MFNode;
import vrml.field.SFNode;

class JSAIMFNode
extends MFNode
implements VRMLNodeListener,
NodeField {
    private VRMLNodeType node;
    private int fieldIndex;
    private FieldFactory fieldFactory;
    private Browser browser;

    JSAIMFNode(VRMLNodeType vRMLNodeType, int n) {
        this.node = vRMLNodeType;
        this.fieldIndex = n;
        this.node.addNodeListener(this);
    }

    public void initialize(Browser browser, FieldFactory fieldFactory) {
        this.browser = browser;
        this.fieldFactory = fieldFactory;
        this.valueChanged = true;
        this.updateLocalData();
    }

    public void getValue(BaseNode[] baseNodeArray) {
        this.updateLocalData();
        super.getValue(baseNodeArray);
    }

    public BaseNode get1Value(int n) {
        this.updateLocalData();
        return super.get1Value(n);
    }

    public void setValue(BaseNode[] baseNodeArray) {
        super.setValue(baseNodeArray);
        this.updateCoreData();
    }

    public void setValue(int n, BaseNode[] baseNodeArray) {
        super.setValue(n, baseNodeArray);
        this.updateCoreData();
    }

    public void setValue(MFNode mFNode) {
        super.setValue(mFNode);
        this.updateCoreData();
    }

    public void setValue(ConstMFNode constMFNode) {
        super.setValue(constMFNode);
        this.updateCoreData();
    }

    public void set1Value(int n, BaseNode baseNode) {
        super.set1Value(n, baseNode);
        this.updateCoreData();
    }

    public void set1Value(int n, ConstSFNode constSFNode) {
        super.set1Value(n, constSFNode);
        this.updateCoreData();
    }

    public void set1Value(int n, SFNode sFNode) {
        super.set1Value(n, sFNode);
        this.updateCoreData();
    }

    public void addValue(BaseNode baseNode) {
        super.addValue(baseNode);
        this.updateCoreData();
    }

    public void addValue(ConstSFNode constSFNode) {
        super.addValue(constSFNode);
        this.updateCoreData();
    }

    public void addValue(SFNode sFNode) {
        super.addValue(sFNode);
        this.updateCoreData();
    }

    public void insertValue(int n, BaseNode baseNode) {
        super.insertValue(n, baseNode);
        this.updateCoreData();
    }

    public void insertValue(int n, ConstSFNode constSFNode) {
        super.insertValue(n, constSFNode);
        this.updateCoreData();
    }

    public void insertValue(int n, SFNode sFNode) {
        super.insertValue(n, sFNode);
        this.updateCoreData();
    }

    public void clear() {
        this.numElements = 0;
        this.data = new BaseNode[0];
        this.updateCoreData();
    }

    public void delete(int n) {
        this.updateLocalData();
        super.delete(n);
    }

    public String toString() {
        this.updateLocalData();
        return super.toString();
    }

    public Object clone() {
        return new JSAIMFNode(this.node, this.fieldIndex);
    }

    public void fieldChanged(int n) {
        if (n != this.fieldIndex) {
            return;
        }
        this.valueChanged = true;
    }

    private void updateLocalData() {
        if (!this.valueChanged) {
            return;
        }
        try {
            VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
            if (vRMLFieldData == null) {
                return;
            }
            if (vRMLFieldData.numElements == 0) {
                this.numElements = 0;
                this.data = new BaseNode[0];
            } else {
                VRMLNodeType[] vRMLNodeTypeArray = (VRMLNodeType[])vRMLFieldData.nodeArrayValue;
                if (this.numElements != vRMLFieldData.numElements) {
                    this.numElements = vRMLFieldData.numElements;
                    this.data = new BaseNode[this.numElements];
                }
                for (int i = 0; i < this.numElements; ++i) {
                    this.data[i] = new JSAINode(vRMLNodeTypeArray[i], this.browser, this.fieldFactory);
                }
            }
            this.valueChanged = false;
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    private void updateCoreData() {
        try {
            VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[this.numElements];
            for (int i = 0; i < this.numElements; ++i) {
                vRMLNodeTypeArray[i] = this.data[i].getImplNode();
            }
            this.node.setValue(this.fieldIndex, vRMLNodeTypeArray, this.numElements);
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }
}

