/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.jsai;

import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import vrml.field.ConstMFFloat;
import vrml.field.ConstSFFloat;
import vrml.field.MFFloat;
import vrml.field.SFFloat;

class JSAIMFFloat
extends MFFloat
implements VRMLNodeListener {
    private VRMLNodeType node;
    private int fieldIndex;

    JSAIMFFloat(VRMLNodeType vRMLNodeType, int n) {
        this.node = vRMLNodeType;
        this.fieldIndex = n;
        this.valueChanged = true;
        this.updateLocalData();
        this.node.addNodeListener(this);
    }

    public void getValue(float[] fArray) {
        this.updateLocalData();
        super.getValue(fArray);
    }

    public float get1Value(int n) {
        this.updateLocalData();
        return super.get1Value(n);
    }

    public void setValue(float[] fArray) {
        super.setValue(fArray);
        this.updateCoreData();
    }

    public void setValue(int n, float[] fArray) {
        super.setValue(n, fArray);
        this.updateCoreData();
    }

    public void setValue(MFFloat mFFloat) {
        super.setValue(mFFloat);
        this.updateCoreData();
    }

    public void setValue(ConstMFFloat constMFFloat) {
        super.setValue(constMFFloat);
        this.updateCoreData();
    }

    public void set1Value(int n, float f) {
        super.set1Value(n, f);
        this.updateCoreData();
    }

    public void set1Value(int n, ConstSFFloat constSFFloat) {
        super.set1Value(n, constSFFloat);
        this.updateCoreData();
    }

    public void set1Value(int n, SFFloat sFFloat) {
        super.set1Value(n, sFFloat);
        this.updateCoreData();
    }

    public void addValue(float f) {
        super.addValue(f);
        this.updateCoreData();
    }

    public void addValue(ConstSFFloat constSFFloat) {
        super.addValue(constSFFloat);
        this.updateCoreData();
    }

    public void addValue(SFFloat sFFloat) {
        super.addValue(sFFloat);
        this.updateCoreData();
    }

    public void insertValue(int n, float f) {
        super.insertValue(n, f);
        this.updateCoreData();
    }

    public void insertValue(int n, ConstSFFloat constSFFloat) {
        super.insertValue(n, constSFFloat);
        this.updateCoreData();
    }

    public void insertValue(int n, SFFloat sFFloat) {
        super.insertValue(n, sFFloat);
        this.updateCoreData();
    }

    public void clear() {
        System.out.println("JSAIMFFloat clear not implemented yet");
    }

    public void delete(int n) {
        super.delete(n);
        this.updateCoreData();
    }

    public Object clone() {
        return new JSAIMFFloat(this.node, this.fieldIndex);
    }

    public String toString() {
        this.updateLocalData();
        return super.toString();
    }

    public void fieldChanged(int n) {
        if (n != this.fieldIndex) {
            return;
        }
        this.valueChanged = true;
    }

    private void updateLocalData() {
        if (!this.valueChanged) {
            return;
        }
        try {
            VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
            if (vRMLFieldData == null) {
                return;
            }
            if (vRMLFieldData.numElements == 0) {
                this.numElements = 0;
                this.data = new float[0];
            } else {
                super.setValue(vRMLFieldData.numElements, vRMLFieldData.floatArrayValue);
            }
            this.valueChanged = false;
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    private void updateCoreData() {
        try {
            this.node.setValue(this.fieldIndex, this.data, this.numElements);
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }
}

