/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.jsai;

import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.jsai.FieldFactory;
import org.web3d.vrml.scripting.jsai.JSAINode;
import org.web3d.vrml.scripting.jsai.NodeField;
import vrml.BaseNode;
import vrml.Browser;
import vrml.field.ConstSFNode;

class JSAIConstSFNode
extends ConstSFNode
implements VRMLNodeListener,
NodeField {
    private VRMLNodeType parentNode;
    private int fieldIndex;
    private VRMLNodeType childNode;
    private FieldFactory fieldFactory;
    private Browser browser;

    JSAIConstSFNode(VRMLNodeType vRMLNodeType, int n) {
        this.parentNode = vRMLNodeType;
        this.fieldIndex = n;
        this.parentNode.addNodeListener(this);
    }

    public void initialize(Browser browser, FieldFactory fieldFactory) {
        this.browser = browser;
        this.fieldFactory = fieldFactory;
        this.valueChanged = true;
        this.updateLocalData();
    }

    public BaseNode getValue() {
        this.updateLocalData();
        return this.data;
    }

    public Object clone() {
        JSAIConstSFNode jSAIConstSFNode = new JSAIConstSFNode(this.parentNode, this.fieldIndex);
        jSAIConstSFNode.initialize(this.browser, this.fieldFactory);
        return jSAIConstSFNode;
    }

    public void fieldChanged(int n) {
        if (n != this.fieldIndex) {
            return;
        }
        this.valueChanged = true;
    }

    private void updateLocalData() {
        if (!this.valueChanged) {
            return;
        }
        try {
            VRMLFieldData vRMLFieldData = this.parentNode.getFieldValue(this.fieldIndex);
            if (vRMLFieldData == null) {
                return;
            }
            if (vRMLFieldData.nodeValue == null) {
                this.data = null;
            } else if (this.childNode == null || this.childNode != vRMLFieldData.nodeValue) {
                this.childNode = (VRMLNodeType)vRMLFieldData.nodeValue;
                this.data = new JSAINode(this.childNode, this.browser, this.fieldFactory);
            }
            this.valueChanged = false;
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }
}

