/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.jsai;

import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.jsai.JSAIConstMFVec2f;
import vrml.field.ConstMFVec3f;
import vrml.field.SFVec3f;

class JSAIConstMFVec3f
extends ConstMFVec3f
implements VRMLNodeListener {
    private VRMLNodeType node;
    private int fieldIndex;

    JSAIConstMFVec3f(VRMLNodeType vRMLNodeType, int n) {
        this.node = vRMLNodeType;
        this.fieldIndex = n;
        this.valueChanged = true;
        this.updateLocalData();
        this.node.addNodeListener(this);
    }

    public void getValue(float[][] fArray) {
        this.updateLocalData();
        super.getValue(fArray);
    }

    public void getValue(float[] fArray) {
        this.updateLocalData();
        super.getValue(fArray);
    }

    public void get1Value(int n, float[] fArray) {
        this.updateLocalData();
        super.get1Value(n, fArray);
    }

    public void get1Value(int n, SFVec3f sFVec3f) {
        this.updateLocalData();
        super.get1Value(n, sFVec3f);
    }

    public String toString() {
        this.updateLocalData();
        return super.toString();
    }

    public Object clone() {
        return new JSAIConstMFVec2f(this.node, this.fieldIndex);
    }

    public void fieldChanged(int n) {
        if (n != this.fieldIndex) {
            return;
        }
        this.valueChanged = true;
    }

    private void updateLocalData() {
        if (!this.valueChanged) {
            return;
        }
        try {
            VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
            if (vRMLFieldData == null) {
                return;
            }
            if (vRMLFieldData.numElements == 0) {
                this.numElements = 0;
                this.data = new float[0];
            } else {
                this.setValue(vRMLFieldData.numElements * 3, vRMLFieldData.floatArrayValue);
            }
            this.valueChanged = false;
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    private void setValue(int n, float[] fArray) {
        if (n > this.data.length) {
            this.data = new float[n];
        }
        this.numElements = n / 3;
        System.arraycopy(fArray, 0, this.data, 0, n);
    }
}

