/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.jsai;

import org.web3d.vrml.lang.FieldException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import vrml.field.ConstMFInt32;

class JSAIConstMFInt32
extends ConstMFInt32
implements VRMLNodeListener {
    private VRMLNodeType node;
    private int fieldIndex;

    JSAIConstMFInt32(VRMLNodeType vRMLNodeType, int n) {
        this.node = vRMLNodeType;
        this.fieldIndex = n;
        this.node.addNodeListener(this);
        this.valueChanged = true;
        this.node.addNodeListener(this);
    }

    public void getValue(int[] nArray) {
        this.updateLocalData();
        super.getValue(nArray);
    }

    public int get1Value(int n) {
        this.updateLocalData();
        return super.get1Value(n);
    }

    public String toString() {
        this.updateLocalData();
        return super.toString();
    }

    public Object clone() {
        return new JSAIConstMFInt32(this.node, this.fieldIndex);
    }

    public void fieldChanged(int n) {
        if (n != this.fieldIndex) {
            return;
        }
        this.valueChanged = true;
    }

    private void updateLocalData() {
        if (!this.valueChanged) {
            return;
        }
        try {
            VRMLFieldData vRMLFieldData = this.node.getFieldValue(this.fieldIndex);
            if (vRMLFieldData == null) {
                return;
            }
            if (vRMLFieldData.numElements == 0) {
                this.numElements = 0;
                this.data = new int[0];
            } else {
                this.setValue(vRMLFieldData.numElements, vRMLFieldData.intArrayValue);
            }
            this.valueChanged = false;
        }
        catch (FieldException fieldException) {
            // empty catch block
        }
    }

    private void setValue(int n, int[] nArray) {
        if (n > this.data.length) {
            this.data = new int[n];
        }
        System.arraycopy(nArray, 0, this.data, 0, n);
        this.numElements = n;
    }
}

