/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.feature;

import java.util.EventObject;
import org.opengis.feature.FeatureStore;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class FeatureStoreEvent
extends EventObject {
    private static final long serialVersionUID = -1842329357109520014L;
    public static final int ADD = 1;
    public static final int MODIFY = 0;
    public static final int DELETE = -1;
    private final GenericName typeName;
    private final int eventType;

    public FeatureStoreEvent(FeatureStore featureStore, GenericName genericName, int n) {
        super(featureStore);
        this.typeName = genericName;
        this.eventType = n;
    }

    public Object getSource() {
        return (FeatureStore)super.getSource();
    }

    public FeatureStore getFeatureStore() {
        return (FeatureStore)super.getSource();
    }

    public GenericName getTypeName() {
        return this.typeName;
    }

    public int getEventType() {
        return this.eventType;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("FeatureStore ");
        FeatureStore featureStore = this.getFeatureStore();
        if (featureStore != null) {
            InternationalString internationalString = featureStore.getDisplayName();
            stringBuffer.append(internationalString != null ? ((Object)internationalString).toString() : featureStore.toString());
        }
        stringBuffer.append(' ');
        switch (this.eventType) {
            case 1: {
                stringBuffer.append("ADD");
                break;
            }
            case 0: {
                stringBuffer.append("MODIFY");
                break;
            }
            case -1: {
                stringBuffer.append("DELETE");
            }
        }
        stringBuffer.append(" Event");
        return stringBuffer.toString();
    }
}

