/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.geotools.factory.Hints;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;

public class NumericConverterFactory
implements ConverterFactory {
    public Converter createConverter(Class source, Class target, Hints hints) {
        if (!Number.class.isAssignableFrom(source) && !String.class.isAssignableFrom(source)) {
            return null;
        }
        if (Long.class.equals(target) || Integer.class.equals(target) || Short.class.equals(target) || Byte.class.equals(target) || BigInteger.class.equals(target) || BigDecimal.class.equals(target) || Double.class.equals(target) || Float.class.equals(target) || Number.class.equals(target)) {
            return new NumericConverter();
        }
        return null;
    }

    class NumericConverter
    implements Converter {
        NumericConverter() {
        }

        public Object convert(Object source, Class target) throws Exception {
            if (source instanceof Number) {
                Number s = (Number)source;
                if ((class$java$lang$Long == null ? (class$java$lang$Long = NumericConverterFactory.class$("java.lang.Long")) : class$java$lang$Long).equals(target)) {
                    return new Long(s.longValue());
                }
                if ((class$java$lang$Integer == null ? (class$java$lang$Integer = NumericConverterFactory.class$("java.lang.Integer")) : class$java$lang$Integer).equals(target)) {
                    return new Integer(s.intValue());
                }
                if ((class$java$lang$Short == null ? (class$java$lang$Short = NumericConverterFactory.class$("java.lang.Short")) : class$java$lang$Short).equals(target)) {
                    return new Short(s.shortValue());
                }
                if ((class$java$lang$Byte == null ? (class$java$lang$Byte = NumericConverterFactory.class$("java.lang.Byte")) : class$java$lang$Byte).equals(target)) {
                    return new Byte(s.byteValue());
                }
                if ((class$java$math$BigInteger == null ? (class$java$math$BigInteger = NumericConverterFactory.class$("java.math.BigInteger")) : class$java$math$BigInteger).equals(target)) {
                    return BigInteger.valueOf(s.longValue());
                }
                if ((class$java$lang$Double == null ? (class$java$lang$Double = NumericConverterFactory.class$("java.lang.Double")) : class$java$lang$Double).equals(target)) {
                    return new Double(s.doubleValue());
                }
                if ((class$java$lang$Float == null ? (class$java$lang$Float = NumericConverterFactory.class$("java.lang.Float")) : class$java$lang$Float).equals(target)) {
                    return new Float(s.floatValue());
                }
                if ((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NumericConverterFactory.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).equals(target)) {
                    return new BigDecimal(s.doubleValue());
                }
                if ((class$java$lang$Number == null ? (class$java$lang$Number = NumericConverterFactory.class$("java.lang.Number")) : class$java$lang$Number).equals(target)) {
                    try {
                        return new Integer(s.toString());
                    }
                    catch (Exception e) {
                        try {
                            return new BigInteger(s.toString());
                        }
                        catch (Exception e2) {
                            try {
                                return new Double(s.toString());
                            }
                            catch (Exception e3) {
                                try {
                                    return new BigDecimal(s.toString());
                                }
                                catch (Exception e4) {}
                            }
                        }
                    }
                }
            } else if (source instanceof String) {
                String s = (String)source;
                s = s.trim();
                if ((class$java$lang$Long == null ? (class$java$lang$Long = NumericConverterFactory.class$("java.lang.Long")) : class$java$lang$Long).equals(target)) {
                    return new Long(s);
                }
                if ((class$java$lang$Integer == null ? (class$java$lang$Integer = NumericConverterFactory.class$("java.lang.Integer")) : class$java$lang$Integer).equals(target)) {
                    return new Integer(s);
                }
                if ((class$java$lang$Short == null ? (class$java$lang$Short = NumericConverterFactory.class$("java.lang.Short")) : class$java$lang$Short).equals(target)) {
                    return new Short(s);
                }
                if ((class$java$lang$Byte == null ? (class$java$lang$Byte = NumericConverterFactory.class$("java.lang.Byte")) : class$java$lang$Byte).equals(target)) {
                    return new Byte(s);
                }
                if ((class$java$math$BigInteger == null ? (class$java$math$BigInteger = NumericConverterFactory.class$("java.math.BigInteger")) : class$java$math$BigInteger).equals(target)) {
                    return new BigInteger(s);
                }
                if ((class$java$lang$Double == null ? (class$java$lang$Double = NumericConverterFactory.class$("java.lang.Double")) : class$java$lang$Double).equals(target)) {
                    return new Double(s);
                }
                if ((class$java$lang$Float == null ? (class$java$lang$Float = NumericConverterFactory.class$("java.lang.Float")) : class$java$lang$Float).equals(target)) {
                    return new Float(s);
                }
                if ((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NumericConverterFactory.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).equals(target)) {
                    return new BigDecimal(s);
                }
                if ((class$java$lang$Number == null ? (class$java$lang$Number = NumericConverterFactory.class$("java.lang.Number")) : class$java$lang$Number).equals(target)) {
                    try {
                        return new Integer(s);
                    }
                    catch (Exception e) {
                        try {
                            return new BigInteger(s);
                        }
                        catch (Exception e5) {
                            try {
                                return new Double(s);
                            }
                            catch (Exception e6) {
                                try {
                                    return new BigDecimal(s);
                                }
                                catch (Exception e7) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
            }
            return null;
        }
    }
}

