/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.resources.LazySet;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;

public final class Converters {
    static Collection factories;
    private static FactoryRegistry registry;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static FactoryRegistry getServiceRegistry() {
        if (!$assertionsDisabled && !Thread.holdsLock(Converters.class)) {
            throw new AssertionError();
        }
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(ConverterFactory.class));
        }
        return registry;
    }

    private static Hints addDefaultHints(Hints hints) {
        Hints completed = GeoTools.getDefaultHints();
        if (hints != null) {
            completed.add(hints);
        }
        return completed;
    }

    public static synchronized Set getConverterFactories(Hints hints) {
        hints = Converters.addDefaultHints(hints);
        return new LazySet(Converters.getServiceRegistry().getServiceProviders(ConverterFactory.class, null, hints));
    }

    public static Object convert(Object source, Class target) {
        return Converters.convert(source, target, null);
    }

    public static Object convert(Object source, Class target, Hints hints) {
        if (source == null) {
            return null;
        }
        if (source.getClass().equals(target)) {
            return source;
        }
        Iterator i = Converters.factories().iterator();
        while (i.hasNext()) {
            ConverterFactory factory = (ConverterFactory)i.next();
            Converter converter = factory.createConverter(source.getClass(), target, hints);
            if (converter == null) continue;
            try {
                Object converted = converter.convert(source, target);
                if (converted == null) continue;
                return converted;
            }
            catch (Exception e) {
            }
        }
        if (String.class.equals(target)) {
            return source.toString();
        }
        return null;
    }

    static Collection factories() {
        if (factories == null) {
            factories = Converters.getConverterFactories(GeoTools.getDefaultHints());
        }
        return factories;
    }

    static {
        $assertionsDisabled = !Converters.class.desiredAssertionStatus();
    }
}

