/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.Arrays;
import org.geotools.data.DataStore;
import org.geotools.event.GTList;
import org.geotools.feature.FeatureType;
import org.geotools.resources.Utilities;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.RemoteOWS;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayerImpl;
import org.geotools.styling.UserLayer;

public class UserLayerImpl
extends StyledLayerImpl
implements UserLayer {
    private DataStore inlineFeatureDatastore = null;
    private FeatureType inlineFeatureType = null;
    RemoteOWS remoteOWS;
    ArrayList styles = new GTList(this, "styles");
    FeatureTypeConstraint[] constraints = new FeatureTypeConstraint[0];

    public RemoteOWS getRemoteOWS() {
        return this.remoteOWS;
    }

    public DataStore getInlineFeatureDatastore() {
        return this.inlineFeatureDatastore;
    }

    public FeatureType getInlineFeatureType() {
        return this.inlineFeatureType;
    }

    public void setInlineFeatureDatastore(DataStore store) {
        this.inlineFeatureDatastore = store;
        this.fireChanged();
    }

    public void setInlineFeatureType(FeatureType ft) {
        this.inlineFeatureType = ft;
        this.fireChanged();
    }

    public void setRemoteOWS(RemoteOWS service) {
        RemoteOWS old = this.remoteOWS;
        this.remoteOWS = service;
        this.fireChildChanged("remoteOWS", this.remoteOWS, old);
    }

    public FeatureTypeConstraint[] getLayerFeatureConstraints() {
        return this.constraints;
    }

    public void setLayerFeatureConstraints(FeatureTypeConstraint[] constraints) {
        this.constraints = constraints;
        this.fireChanged();
    }

    public Style[] getUserStyles() {
        return this.styles.toArray(new Style[0]);
    }

    public void setUserStyles(Style[] styles) {
        this.styles.clear();
        this.styles.addAll(Arrays.asList(styles));
        this.fireChanged();
    }

    public void addUserStyle(Style style) {
        this.styles.add(style);
        this.fireChanged();
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((UserLayer)this);
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof UserLayerImpl) {
            UserLayerImpl other = (UserLayerImpl)oth;
            if (!(Utilities.equals(this.inlineFeatureDatastore, other.inlineFeatureDatastore) && Utilities.equals(this.inlineFeatureType, other.inlineFeatureType) && Utilities.equals(this.remoteOWS, other.remoteOWS) && Utilities.equals(this.styles, other.styles))) {
                return false;
            }
            int length = this.constraints.length;
            if (length != other.constraints.length) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                if (Utilities.equals(this.constraints[i], other.constraints[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

