/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.Arrays;
import java.util.List;
import org.geotools.event.AbstractGTComponent;
import org.geotools.event.GTList;
import org.geotools.resources.Utilities;
import org.geotools.styling.Graphic;
import org.geotools.styling.Rule;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbolizer;
import org.opengis.filter.Filter;
import org.opengis.util.Cloneable;

public class RuleImpl
extends AbstractGTComponent
implements Rule,
Cloneable {
    private List symbolizers = new GTList(this, "symbolizers");
    private List graphics = new GTList(this, "graphics");
    private String name;
    private String title;
    private String abstractStr;
    private Filter filter = null;
    private boolean hasElseFilter = false;
    private double maxScaleDenominator = Double.POSITIVE_INFINITY;
    private double minScaleDenominator = 0.0;

    protected RuleImpl() {
    }

    protected RuleImpl(Symbolizer[] symbolizers) {
        this.symbolizers.addAll(Arrays.asList(symbolizers));
    }

    public Graphic[] getLegendGraphic() {
        return this.graphics.toArray(new Graphic[0]);
    }

    public void addLegendGraphic(Graphic graphic) {
        this.graphics.add(graphic);
    }

    public void setLegendGraphic(Graphic[] graphics) {
        List<Graphic> graphicList = Arrays.asList(graphics);
        this.graphics.clear();
        this.graphics.addAll(graphicList);
    }

    public void addSymbolizer(Symbolizer symb) {
        this.symbolizers.add(symb);
    }

    public void setSymbolizers(Symbolizer[] syms) {
        List<Symbolizer> symbols = Arrays.asList(syms);
        this.symbolizers.clear();
        this.symbolizers.addAll(symbols);
    }

    public Symbolizer[] getSymbolizers() {
        return this.symbolizers.toArray(new Symbolizer[this.symbolizers.size()]);
    }

    public String getAbstract() {
        return this.abstractStr;
    }

    public void setAbstract(String abstractStr) {
        this.abstractStr = abstractStr;
        this.fireChanged();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.fireChanged();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.fireChanged();
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        Filter old = this.filter;
        this.filter = filter;
        this.fireChildChanged("filter", filter, old);
    }

    public boolean hasElseFilter() {
        return this.hasElseFilter;
    }

    public void setIsElseFilter(boolean flag) {
        this.hasElseFilter = flag;
        this.fireChanged();
    }

    public void setHasElseFilter() {
        this.hasElseFilter = true;
        this.fireChanged();
    }

    public double getMaxScaleDenominator() {
        return this.maxScaleDenominator;
    }

    public void setMaxScaleDenominator(double maxScaleDenominator) {
        this.maxScaleDenominator = maxScaleDenominator;
        this.fireChanged();
    }

    public double getMinScaleDenominator() {
        return this.minScaleDenominator;
    }

    public void setMinScaleDenominator(double minScaleDenominator) {
        this.minScaleDenominator = minScaleDenominator;
        this.fireChanged();
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((Rule)this);
    }

    public Object clone() {
        try {
            RuleImpl clone = (RuleImpl)super.clone();
            clone.graphics = new GTList(clone, "graphics");
            clone.symbolizers = new GTList(clone, "symbolizers");
            clone.filter = this.filter;
            Graphic[] legends = new Graphic[this.graphics.size()];
            for (int i = 0; i < legends.length; ++i) {
                Graphic legend = (Graphic)this.graphics.get(i);
                legends[i] = (Graphic)((Cloneable)legend).clone();
            }
            clone.setLegendGraphic(legends);
            Symbolizer[] symbArray = new Symbolizer[this.symbolizers.size()];
            for (int i = 0; i < symbArray.length; ++i) {
                Symbolizer symb = (Symbolizer)this.symbolizers.get(i);
                symbArray[i] = (Symbolizer)((Cloneable)symb).clone();
            }
            clone.setSymbolizers(symbArray);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("This will never happen", e);
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        result = 1000003 * result + ((Object)this.symbolizers).hashCode();
        if (this.graphics != null) {
            result = 1000003 * result + ((Object)this.graphics).hashCode();
        }
        if (this.name != null) {
            result = 1000003 * result + this.name.hashCode();
        }
        if (this.title != null) {
            result = 1000003 * result + this.title.hashCode();
        }
        if (this.abstractStr != null) {
            result = 1000003 * result + this.abstractStr.hashCode();
        }
        if (this.filter != null) {
            result = 1000003 * result + this.filter.hashCode();
        }
        result = 1000003 * result + (this.hasElseFilter ? 1 : 0);
        long temp = Double.doubleToLongBits(this.maxScaleDenominator);
        result = 1000003 * result + (int)(temp >>> 32);
        result = 1000003 * result + (int)(temp & 0xFFFFFFFFFFFFFFFFL);
        temp = Double.doubleToLongBits(this.minScaleDenominator);
        result = 1000003 * result + (int)(temp >>> 32);
        result = 1000003 * result + (int)(temp & 0xFFFFFFFFFFFFFFFFL);
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof RuleImpl) {
            RuleImpl other = (RuleImpl)oth;
            return Utilities.equals(this.name, other.name) && Utilities.equals(this.title, other.title) && Utilities.equals(this.abstractStr, other.abstractStr) && Utilities.equals(this.filter, other.filter) && this.hasElseFilter == other.hasElseFilter && Utilities.equals(this.graphics, other.graphics) && Utilities.equals(this.symbolizers, other.symbolizers) && Double.doubleToLongBits(this.maxScaleDenominator) == Double.doubleToLongBits(other.maxScaleDenominator) && Double.doubleToLongBits(this.minScaleDenominator) == Double.doubleToLongBits(other.minScaleDenominator);
        }
        return false;
    }
}

