/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml.producer;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;

final class GMLUtils {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.gml.producer");
    public static final String GML_URL = "http://www.opengis.net/gml";
    protected static final int POINT = 1;
    protected static final int LINESTRING = 2;
    protected static final int POLYGON = 3;
    protected static final int MULTIPOINT = 4;
    protected static final int MULTILINESTRING = 5;
    protected static final int MULTIPOLYGON = 6;
    protected static final int MULTIGEOMETRY = 7;

    private GMLUtils() {
    }

    public static String getGeometryName(Geometry geometry) {
        LOGGER.entering("GMLUtils", "getGeometryName", geometry);
        Class<?> geomClass = geometry.getClass();
        String returnValue = null;
        returnValue = geomClass.equals(Point.class) ? "Point" : (geomClass.equals(LineString.class) ? "LineString" : (geomClass.equals(Polygon.class) ? "Polygon" : (geomClass.equals(MultiPoint.class) ? "MultiPoint" : (geomClass.equals(MultiLineString.class) ? "MultiLineString" : (geomClass.equals(MultiPolygon.class) ? "MultiPolygon" : (geomClass.equals(GeometryCollection.class) ? "GeometryCollection" : null))))));
        LOGGER.exiting("GMLUtils", "getGeometryName", returnValue);
        return returnValue;
    }

    public static int getGeometryType(Geometry geometry) {
        Class<?> geomClass = geometry.getClass();
        int returnValue = -1;
        returnValue = geomClass.equals(Point.class) ? 1 : (geomClass.equals(LineString.class) ? 2 : (geomClass.equals(Polygon.class) ? 3 : (geomClass.equals(MultiPoint.class) ? 4 : (geomClass.equals(MultiLineString.class) ? 5 : (geomClass.equals(MultiPolygon.class) ? 6 : (geomClass.equals(GeometryCollection.class) ? 7 : -1))))));
        return returnValue;
    }

    public static String getMemberName(int geometryType) {
        switch (geometryType) {
            case 4: {
                return "pointMember";
            }
            case 5: {
                return "lineStringMember";
            }
            case 6: {
                return "polygonMember";
            }
        }
        return "geometryMember";
    }

    public static String encodeXML(String inData) {
        if (inData == null) {
            return null;
        }
        if (inData.indexOf(38) == -1 && inData.indexOf(60) == -1 && inData.indexOf(62) == -1 && inData.indexOf(39) == -1 && inData.indexOf(34) == -1) {
            return inData;
        }
        int length = inData.length();
        StringBuffer buffer = new StringBuffer(2 * length);
        for (int i = 0; i < length; ++i) {
            char charToCompare = inData.charAt(i);
            if (charToCompare == '&') {
                buffer.append("&amp;");
                continue;
            }
            if (charToCompare == '<') {
                buffer.append("&lt;");
                continue;
            }
            if (charToCompare == '>') {
                buffer.append("&gt;");
                continue;
            }
            if (charToCompare == '\"') {
                buffer.append("&quot;");
                continue;
            }
            if (charToCompare == '\'') {
                buffer.append("&apos;");
                continue;
            }
            buffer.append(charToCompare);
        }
        return buffer.toString();
    }
}

