/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml.producer;

import java.net.URI;
import java.util.logging.Logger;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureType;
import org.geotools.filter.LengthFunction;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FeatureTypeTransformer
extends TransformerBase {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.gml.producer.FeatureTypeTransformer");
    private static final String SCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Geometry;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Point;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$LineString;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Polygon;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$MultiPoint;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$MultiLineString;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$MultiPolygon;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$GeometryCollection;

    public Translator createTranslator(ContentHandler handler) {
        FeatureTypeTranslator translator = new FeatureTypeTranslator(handler);
        return translator;
    }

    public static class FeatureTypeTranslator
    extends TransformerBase.TranslatorSupport {
        public FeatureTypeTranslator(ContentHandler handler) {
            super(handler, "xs", FeatureTypeTransformer.SCHEMA_NS);
        }

        public void encode(Object o) throws IllegalArgumentException {
            if (!(o instanceof FeatureType)) {
                throw new IllegalArgumentException("Translator does not know how to translate " + o.getClass().getName());
            }
            this.encode((FeatureType)o);
        }

        protected void encode(FeatureType type) {
            AttributeType[] attributes = type.getAttributeTypes();
            try {
                this.startSchemaType(type.getTypeName(), type.getNamespace());
                for (int i = 0; i < attributes.length; ++i) {
                    this.encode(attributes[i]);
                }
                this.endSchemaType();
            }
            catch (SAXException e) {
                throw new RuntimeException(e);
            }
        }

        protected void startSchemaType(String name, URI namespace) throws SAXException {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "name", "name", "", name + "_Type");
            this.contentHandler.startElement(FeatureTypeTransformer.SCHEMA_NS, "complexType", "xs:complexType", atts);
            this.contentHandler.startElement(FeatureTypeTransformer.SCHEMA_NS, "complexContent", "xs:complexContent", new AttributesImpl());
            atts = new AttributesImpl();
            atts.addAttribute("", "base", "base", "", "gml:AbstractFeatureType");
            this.contentHandler.startElement(FeatureTypeTransformer.SCHEMA_NS, "extension", "xs:extension", atts);
            this.contentHandler.startElement(FeatureTypeTransformer.SCHEMA_NS, "sequence", "xs:sequence", new AttributesImpl());
        }

        protected void endSchemaType() throws SAXException {
            this.contentHandler.endElement(FeatureTypeTransformer.SCHEMA_NS, "sequence", "xs:sequence");
            this.contentHandler.endElement(FeatureTypeTransformer.SCHEMA_NS, "extension", "xs:extension");
            this.contentHandler.endElement(FeatureTypeTransformer.SCHEMA_NS, "complexContent", "xs:complexContent");
            this.contentHandler.endElement(FeatureTypeTransformer.SCHEMA_NS, "complexType", "xs:complexType");
        }

        protected void encode(AttributeType attribute) throws SAXException {
            Class type;
            if ((class$java$lang$Number == null ? (class$java$lang$Number = FeatureTypeTransformer.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(type = attribute.getType())) {
                this.encodeNumber(attribute);
            } else if ((class$java$util$Date == null ? (class$java$util$Date = FeatureTypeTransformer.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(type)) {
                this.encodeDate(attribute);
            } else if (type == (class$java$lang$String == null ? (class$java$lang$String = FeatureTypeTransformer.class$("java.lang.String")) : class$java$lang$String)) {
                this.encodeString(attribute);
            } else if ((class$com$vividsolutions$jts$geom$Geometry == null ? (class$com$vividsolutions$jts$geom$Geometry = FeatureTypeTransformer.class$("com.vividsolutions.jts.geom.Geometry")) : class$com$vividsolutions$jts$geom$Geometry).isAssignableFrom(type)) {
                this.encodeGeometry(attribute);
            } else if (type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = FeatureTypeTransformer.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                this.encodeBoolean(attribute);
            } else {
                throw new RuntimeException("Cannot encode " + type.getName());
            }
        }

        protected void encodeBoolean(AttributeType attribute) throws SAXException {
            AttributesImpl atts = this.createStandardAttributes(attribute);
            atts.addAttribute("", "type", "type", "", "xs:boolean");
            this.contentHandler.startElement(FeatureTypeTransformer.SCHEMA_NS, "element", "xs:element", atts);
            this.contentHandler.endElement(FeatureTypeTransformer.SCHEMA_NS, "element", "xs:element");
        }

        protected void encodeString(AttributeType attribute) throws SAXException {
            int length = Integer.MAX_VALUE;
            if (attribute.getRestriction() != null && attribute.getRestriction() != Filter.EXCLUDE && attribute.getRestriction() != Filter.INCLUDE) {
                try {
                    Filter f = attribute.getRestriction();
                    if (f instanceof PropertyIsLessThan || f instanceof PropertyIsLessThanOrEqualTo) {
                        BinaryComparisonOperator cf = (BinaryComparisonOperator)f;
                        Expression e = cf.getExpression1();
                        if (e != null && e instanceof LengthFunction) {
                            length = Integer.parseInt(((Literal)cf.getExpression2()).getValue().toString());
                        } else if (cf.getExpression2() instanceof LengthFunction) {
                            length = Integer.parseInt(((Literal)cf.getExpression1()).getValue().toString());
                        }
                    }
                }
                catch (Throwable t) {
                    length = Integer.MAX_VALUE;
                }
            }
            AttributesImpl atts = this.createStandardAttributes(attribute);
            if (length == 0) {
                atts.addAttribute("", "type", "type", "", "xs:string");
                this.contentHandler.startElement(FeatureTypeTransformer.SCHEMA_NS, "element", "xs:element", atts);
                this.contentHandler.endElement(FeatureTypeTransformer.SCHEMA_NS, "element", "xs:element");
            } else {
                this.contentHandler.startElement(FeatureTypeTransformer.SCHEMA_NS, "element", "xs:element", atts);
                this.contentHandler.startElement(FeatureTypeTransformer.SCHEMA_NS, "simpleType", "xs:simpleType", new AttributesImpl());
                atts = new AttributesImpl();
                atts.addAttribute("", "base", "base", "", "xs:string");
                this.contentHandler.startElement(FeatureTypeTransformer.SCHEMA_NS, "restriction", "xs:restriction", atts);
                atts = new AttributesImpl();
                atts.addAttribute("", "value", "value", "", "" + length);
                this.contentHandler.startElement(FeatureTypeTransformer.SCHEMA_NS, "maxLength", "xs:maxLength", atts);
                this.contentHandler.endElement(FeatureTypeTransformer.SCHEMA_NS, "maxLength", "xs:maxLength");
                this.contentHandler.endElement(FeatureTypeTransformer.SCHEMA_NS, "restriction", "xs:restriction");
                this.contentHandler.endElement(FeatureTypeTransformer.SCHEMA_NS, "simpleType", "xs:simpleType");
                this.contentHandler.endElement(FeatureTypeTransformer.SCHEMA_NS, "element", "xs:element");
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void encodeNumber(AttributeType attribute) throws SAXException {
            void var4_4;
            String typeString;
            AttributesImpl atts = this.createStandardAttributes(attribute);
            Class type = attribute.getType();
            if (type == (class$java$lang$Byte == null ? (class$java$lang$Byte = FeatureTypeTransformer.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                typeString = "xs:byte";
            } else if (type == (class$java$lang$Short == null ? (class$java$lang$Short = FeatureTypeTransformer.class$("java.lang.Short")) : class$java$lang$Short)) {
                typeString = "xs:short";
            } else if (type == (class$java$lang$Integer == null ? (class$java$lang$Integer = FeatureTypeTransformer.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                typeString = "xs:int";
            } else if (type == (class$java$lang$Long == null ? (class$java$lang$Long = FeatureTypeTransformer.class$("java.lang.Long")) : class$java$lang$Long)) {
                typeString = "xs:long";
            } else if (type == (class$java$lang$Float == null ? (class$java$lang$Float = FeatureTypeTransformer.class$("java.lang.Float")) : class$java$lang$Float)) {
                typeString = "xs:float";
            } else if (type == (class$java$lang$Double == null ? (class$java$lang$Double = FeatureTypeTransformer.class$("java.lang.Double")) : class$java$lang$Double)) {
                typeString = "xs:double";
            } else if (type == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = FeatureTypeTransformer.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
                typeString = "xs:integer";
            } else if (type == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = FeatureTypeTransformer.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
                typeString = "xs:decimal";
            } else if ((class$java$lang$Number == null ? (class$java$lang$Number = FeatureTypeTransformer.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(type)) {
                typeString = "xs:decimal";
            } else {
                throw new RuntimeException("Called encode number with invalid attribute type.");
            }
            atts.addAttribute("", "type", "type", "", (String)var4_4);
            this.contentHandler.startElement(FeatureTypeTransformer.SCHEMA_NS, "element", "xs:element", atts);
            this.contentHandler.endElement(FeatureTypeTransformer.SCHEMA_NS, "element", "xs:element");
        }

        protected void encodeDate(AttributeType attribute) throws SAXException {
            AttributesImpl atts = this.createStandardAttributes(attribute);
            if ((class$java$sql$Date == null ? (class$java$sql$Date = FeatureTypeTransformer.class$("java.sql.Date")) : class$java$sql$Date).isAssignableFrom(attribute.getType())) {
                atts.addAttribute("", "type", "type", "", "xs:date");
            } else if ((class$java$sql$Time == null ? (class$java$sql$Time = FeatureTypeTransformer.class$("java.sql.Time")) : class$java$sql$Time).isAssignableFrom(attribute.getType())) {
                atts.addAttribute("", "type", "type", "", "xs:time");
            } else {
                atts.addAttribute("", "type", "type", "", "xs:dateTime");
            }
            this.contentHandler.startElement(FeatureTypeTransformer.SCHEMA_NS, "element", "xs:element", atts);
            this.contentHandler.endElement(FeatureTypeTransformer.SCHEMA_NS, "element", "xs:element");
        }

        protected void encodeGeometry(AttributeType attribute) throws SAXException {
            AttributesImpl atts = this.createStandardAttributes(attribute);
            Class type = attribute.getType();
            String typeString = "";
            LOGGER.finer(type.getName());
            if (type == (class$com$vividsolutions$jts$geom$Point == null ? (class$com$vividsolutions$jts$geom$Point = FeatureTypeTransformer.class$("com.vividsolutions.jts.geom.Point")) : class$com$vividsolutions$jts$geom$Point)) {
                typeString = "gml:PointPropertyType";
            } else if (type == (class$com$vividsolutions$jts$geom$LineString == null ? (class$com$vividsolutions$jts$geom$LineString = FeatureTypeTransformer.class$("com.vividsolutions.jts.geom.LineString")) : class$com$vividsolutions$jts$geom$LineString)) {
                typeString = "gml:LineStringPropertyType";
            } else if (type == (class$com$vividsolutions$jts$geom$Polygon == null ? (class$com$vividsolutions$jts$geom$Polygon = FeatureTypeTransformer.class$("com.vividsolutions.jts.geom.Polygon")) : class$com$vividsolutions$jts$geom$Polygon)) {
                typeString = "gml:PolygonPropertyType";
            } else if (type == (class$com$vividsolutions$jts$geom$MultiPoint == null ? (class$com$vividsolutions$jts$geom$MultiPoint = FeatureTypeTransformer.class$("com.vividsolutions.jts.geom.MultiPoint")) : class$com$vividsolutions$jts$geom$MultiPoint)) {
                typeString = "gml:MultiPointPropertyType";
            } else if (type == (class$com$vividsolutions$jts$geom$MultiLineString == null ? (class$com$vividsolutions$jts$geom$MultiLineString = FeatureTypeTransformer.class$("com.vividsolutions.jts.geom.MultiLineString")) : class$com$vividsolutions$jts$geom$MultiLineString)) {
                typeString = "gml:MultiLineStringPropertyType";
            } else if (type == (class$com$vividsolutions$jts$geom$MultiPolygon == null ? (class$com$vividsolutions$jts$geom$MultiPolygon = FeatureTypeTransformer.class$("com.vividsolutions.jts.geom.MultiPolygon")) : class$com$vividsolutions$jts$geom$MultiPolygon)) {
                typeString = "gml:MultiPolygonPropertyType";
            } else if (type == (class$com$vividsolutions$jts$geom$GeometryCollection == null ? (class$com$vividsolutions$jts$geom$GeometryCollection = FeatureTypeTransformer.class$("com.vividsolutions.jts.geom.GeometryCollection")) : class$com$vividsolutions$jts$geom$GeometryCollection)) {
                typeString = "gml:MultiGeometryPropertyType";
            } else if (type == (class$com$vividsolutions$jts$geom$Geometry == null ? (class$com$vividsolutions$jts$geom$Geometry = FeatureTypeTransformer.class$("com.vividsolutions.jts.geom.Geometry")) : class$com$vividsolutions$jts$geom$Geometry)) {
                typeString = "gml:GeometryAssociationType";
            } else {
                throw new RuntimeException("Unsupported type: " + type.getName());
            }
            atts.addAttribute("", "type", "type", "", typeString);
            this.contentHandler.startElement(FeatureTypeTransformer.SCHEMA_NS, "element", "xs:element", atts);
            this.contentHandler.endElement(FeatureTypeTransformer.SCHEMA_NS, "element", "xs:element");
        }

        protected AttributesImpl createStandardAttributes(AttributeType attribute) {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "name", "name", "", attribute.getName());
            if (attribute.isNillable() && attribute.getMinOccurs() == 0) {
                atts.addAttribute("", "minOccurs", "minOccurs", "", "0");
                atts.addAttribute("", "nillable", "nillable", "", "true");
            } else {
                atts.addAttribute("", "minOccurs", "minOccurs", "", "1");
                atts.addAttribute("", "nillable", "nillable", "", "false");
            }
            return atts;
        }
    }
}

