/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml.producer;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.sql.Date;
import java.sql.Time;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.data.FeatureReader;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollectionIteration;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.type.DateUtil;
import org.geotools.gml.producer.GeometryTransformer;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class FeatureTransformer
extends TransformerBase {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.gml");
    private static Set gmlAtts;
    private String collectionPrefix = "wfs";
    private String collectionNamespace = "http://www.opengis.net/wfs";
    private NamespaceSupport nsLookup = new NamespaceSupport();
    private FeatureTypeNamespaces featureTypeNamespaces = new FeatureTypeNamespaces(this.nsLookup);
    private TransformerBase.SchemaLocationSupport schemaLocation = new TransformerBase.SchemaLocationSupport();
    private int maxFeatures = -1;
    private boolean prefixGml = false;
    private boolean featureBounding = false;
    private String srsName;
    private String lockId;
    private int numDecimals = 4;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Geometry;

    public void setCollectionNamespace(String nsURI) {
        this.collectionNamespace = nsURI;
    }

    public String getCollectionNamespace() {
        return this.collectionNamespace;
    }

    public void setCollectionPrefix(String prefix) {
        this.collectionPrefix = prefix;
    }

    public String getCollectionPrefix() {
        return this.collectionPrefix;
    }

    public void setNumDecimals(int numDecimals) {
        this.numDecimals = numDecimals;
    }

    public NamespaceSupport getFeatureNamespaces() {
        return this.nsLookup;
    }

    public FeatureTypeNamespaces getFeatureTypeNamespaces() {
        return this.featureTypeNamespaces;
    }

    public void addSchemaLocation(String nsURI, String uri) {
        this.schemaLocation.setLocation(nsURI, uri);
    }

    public void setSrsName(String srsName) {
        this.srsName = srsName;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public void setGmlPrefixing(boolean prefixGml) {
        this.prefixGml = prefixGml;
        if (prefixGml && gmlAtts == null) {
            gmlAtts = new HashSet();
            this.loadGmlAttributes(gmlAtts);
        }
    }

    protected void loadGmlAttributes(Set gmlAtts) {
        gmlAtts.add("pointProperty");
        gmlAtts.add("geometryProperty");
        gmlAtts.add("polygonProperty");
        gmlAtts.add("lineStringProperty");
        gmlAtts.add("multiPointProperty");
        gmlAtts.add("multiLineStringProperty");
        gmlAtts.add("multiPolygonProperty");
        gmlAtts.add("description");
        gmlAtts.add("name");
    }

    public void setFeatureBounding(boolean featureBounding) {
        this.featureBounding = featureBounding;
    }

    public Translator createTranslator(ContentHandler handler) {
        FeatureTranslator t = this.createTranslator(handler, this.collectionPrefix, this.collectionNamespace, this.featureTypeNamespaces, this.schemaLocation);
        Enumeration<String> prefixes = this.nsLookup.getPrefixes();
        t.setNumDecimals(this.numDecimals);
        t.setGmlPrefixing(this.prefixGml);
        t.setSrsName(this.srsName);
        t.setLockId(this.lockId);
        t.setFeatureBounding(this.featureBounding);
        while (prefixes.hasMoreElements()) {
            String prefix = prefixes.nextElement().toString();
            String uri = this.nsLookup.getURI(prefix);
            t.getNamespaceSupport().declarePrefix(prefix, uri);
        }
        return t;
    }

    protected FeatureTranslator createTranslator(ContentHandler handler, String prefix, String ns, FeatureTypeNamespaces featureTypeNamespaces, TransformerBase.SchemaLocationSupport schemaLocationSupport) {
        return new FeatureTranslator(handler, prefix, ns, featureTypeNamespaces, schemaLocationSupport);
    }

    public static class FeatureTranslator
    extends TransformerBase.TranslatorSupport
    implements FeatureCollectionIteration.Handler {
        String fc = "FeatureCollection";
        protected GeometryTransformer.GeometryTranslator geometryTranslator;
        String memberString;
        String currentPrefix;
        FeatureTypeNamespaces types;
        boolean prefixGml = false;
        boolean featureBounding = false;
        String srsName = null;
        int dimension = 0;
        String lockId = null;
        ContentHandler handler;
        private boolean running = true;

        public FeatureTranslator(ContentHandler handler, String prefix, String ns, FeatureTypeNamespaces types, TransformerBase.SchemaLocationSupport schemaLoc) {
            super(handler, prefix, ns, schemaLoc);
            this.geometryTranslator = this.createGeometryTranslator(handler);
            this.types = types;
            this.handler = handler;
            this.getNamespaceSupport().declarePrefix(this.geometryTranslator.getDefaultPrefix(), this.geometryTranslator.getDefaultNamespace());
            this.memberString = this.geometryTranslator.getDefaultPrefix() + ":featureMember";
        }

        protected GeometryTransformer.GeometryTranslator createGeometryTranslator(ContentHandler handler) {
            return new GeometryTransformer.GeometryTranslator(handler);
        }

        protected GeometryTransformer.GeometryTranslator createGeometryTranslator(ContentHandler handler, int numDecimals) {
            return new GeometryTransformer.GeometryTranslator(handler, numDecimals);
        }

        protected GeometryTransformer.GeometryTranslator createGeometryTranslator(ContentHandler handler, int numDecimals, boolean useDummyZ) {
            return new GeometryTransformer.GeometryTranslator(handler, numDecimals, useDummyZ);
        }

        protected GeometryTransformer.GeometryTranslator createGeometryTranslator(ContentHandler handler, int numDecimals, int dimension) {
            return new GeometryTransformer.GeometryTranslator(handler, "gml", "http://www.opengis.net/gml", numDecimals, false, dimension);
        }

        void setGmlPrefixing(boolean prefixGml) {
            this.prefixGml = prefixGml;
        }

        void setFeatureBounding(boolean bounding) {
            this.featureBounding = bounding;
        }

        void setSrsName(String srsName) {
            this.srsName = srsName;
            this.dimension = 0;
        }

        void setNumDecimals(int numDecimals) {
            this.geometryTranslator = this.createGeometryTranslator(this.handler, numDecimals);
        }

        void setUseDummyZ(boolean useDummyZ) {
            this.geometryTranslator = this.createGeometryTranslator(this.handler, this.geometryTranslator.getNumDecimals(), useDummyZ);
        }

        void setDimension(int dimension) {
            this.geometryTranslator = this.createGeometryTranslator(this.handler, this.geometryTranslator.getNumDecimals(), dimension);
        }

        public void setLockId(String lockId) {
            this.lockId = lockId;
        }

        public FeatureTypeNamespaces getFeatureTypeNamespaces() {
            return this.types;
        }

        public void encode(Object o) throws IllegalArgumentException {
            block7: {
                try {
                    if (o instanceof FeatureCollection) {
                        FeatureCollection fc = (FeatureCollection)o;
                        FeatureCollectionIteration.iteration(this, fc);
                        break block7;
                    }
                    if (o instanceof FeatureCollection[]) {
                        int i;
                        FeatureCollection[] results = (FeatureCollection[])o;
                        Envelope bounds = new Envelope();
                        for (i = 0; i < results.length; ++i) {
                            bounds.expandToInclude((Envelope)results[i].getBounds());
                        }
                        this.startFeatureCollection();
                        this.writeBounds(bounds);
                        for (i = 0; i < results.length; ++i) {
                            this.handleFeatureIterator(results[i].features());
                        }
                        this.endFeatureCollection();
                        break block7;
                    }
                    if (o instanceof FeatureReader) {
                        FeatureReader r = (FeatureReader)o;
                        this.startFeatureCollection();
                        this.handleFeatureReader(r);
                        this.endFeatureCollection();
                        break block7;
                    }
                    throw new IllegalArgumentException("Cannot encode " + o);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace(System.out);
                    throw new RuntimeException("error reading FeatureResults", ioe);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleFeatureIterator(FeatureIterator iterator) throws IOException {
            try {
                try {}
                catch (Exception ioe) {
                    throw new RuntimeException("Error reading Features", ioe);
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (iterator == null) throw throwable;
                LOGGER.finer("closing reader " + iterator);
                iterator.close();
                throw throwable;
            }
            while (iterator.hasNext() && this.running) {
                Feature f = iterator.next();
                this.handleFeature(f);
                FeatureType t = f.getFeatureType();
                int ii = f.getNumberOfAttributes();
                for (int i = 0; i < ii; ++i) {
                    this.handleAttribute(t.getAttributeType(i), f.getAttribute(i));
                }
                this.endFeature(f);
            }
            Object var7_7 = null;
            if (iterator == null) return;
            LOGGER.finer("closing reader " + iterator);
            iterator.close();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleFeatureReader(FeatureReader reader) throws IOException {
            try {
                try {}
                catch (Exception ioe) {
                    throw new RuntimeException("Error reading Features", ioe);
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (reader == null) throw throwable;
                LOGGER.finer("closing reader " + reader);
                reader.close();
                throw throwable;
            }
            while (reader.hasNext() && this.running) {
                Feature f = reader.next();
                this.handleFeature(f);
                FeatureType t = f.getFeatureType();
                int ii = f.getNumberOfAttributes();
                for (int i = 0; i < ii; ++i) {
                    this.handleAttribute(t.getAttributeType(i), f.getAttribute(i));
                }
                this.endFeature(f);
            }
            Object var7_7 = null;
            if (reader == null) return;
            LOGGER.finer("closing reader " + reader);
            reader.close();
        }

        public void startFeatureCollection() {
            try {
                String element = this.getDefaultPrefix() == null ? this.fc : this.getDefaultPrefix() + ":" + this.fc;
                AttributesImpl atts = new AttributesImpl();
                if (this.lockId != null) {
                    atts.addAttribute("", "lockId", "lockId", "", this.lockId);
                }
                this.contentHandler.startElement("", "", element, atts);
            }
            catch (SAXException se) {
                throw new RuntimeException(se);
            }
        }

        public void endFeatureCollection() {
            this.end(this.fc);
        }

        public void handleFeatureCollection(FeatureCollection collection) {
            this.startFeatureCollection();
            this.writeBounds((Envelope)collection.getBounds());
        }

        public void writeBounds(Envelope bounds) {
            try {
                String boundedBy = this.geometryTranslator.getDefaultPrefix() + ":" + "boundedBy";
                this.contentHandler.startElement("", "", boundedBy, this.NULL_ATTS);
                this.geometryTranslator.encode(bounds, this.srsName);
                this.contentHandler.endElement("", "", boundedBy);
            }
            catch (SAXException se) {
                throw new RuntimeException(se);
            }
        }

        public void endFeatureCollection(FeatureCollection collection) {
            this.endFeatureCollection();
        }

        public void endFeature(Feature f) {
            try {
                String name = f.getFeatureType().getTypeName();
                if (this.currentPrefix != null) {
                    name = this.currentPrefix + ":" + name;
                }
                this.contentHandler.endElement("", "", name);
                this.contentHandler.endElement("", "", this.memberString);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void handleAttribute(AttributeType type, Object value) {
            try {
                if (value != null) {
                    String name = type.getName();
                    if (this.prefixGml && name.equals("boundedBy") && (class$com$vividsolutions$jts$geom$Geometry == null ? (class$com$vividsolutions$jts$geom$Geometry = FeatureTransformer.class$("com.vividsolutions.jts.geom.Geometry")) : class$com$vividsolutions$jts$geom$Geometry).isAssignableFrom(value.getClass())) {
                        this.writeBounds(((Geometry)value).getEnvelopeInternal());
                    } else {
                        String thisPrefix = this.currentPrefix;
                        if (this.prefixGml && gmlAtts.contains(name)) {
                            thisPrefix = "gml";
                        }
                        if (thisPrefix != null) {
                            name = thisPrefix + ":" + name;
                        }
                        this.contentHandler.startElement("", "", name, this.NULL_ATTS);
                        if ((class$com$vividsolutions$jts$geom$Geometry == null ? (class$com$vividsolutions$jts$geom$Geometry = FeatureTransformer.class$("com.vividsolutions.jts.geom.Geometry")) : class$com$vividsolutions$jts$geom$Geometry).isAssignableFrom(value.getClass())) {
                            if (this.dimension == 0) {
                                GeometryAttributeType geometryType = (GeometryAttributeType)type;
                                CoordinateReferenceSystem crs = geometryType.getCoordinateSystem();
                                if (crs == null) {
                                    this.dimension = 2;
                                } else {
                                    this.dimension = crs.getCoordinateSystem().getDimension();
                                    if (this.dimension == 3) {
                                        this.setDimension(this.dimension);
                                    }
                                }
                            }
                            this.geometryTranslator.encode((Geometry)value, this.srsName);
                        } else if (value instanceof java.util.Date) {
                            String text = null;
                            text = value instanceof Date ? DateUtil.serializeSqlDate((Date)value) : (value instanceof Time ? DateUtil.serializeSqlTime((Time)value) : DateUtil.serializeDateTime((java.util.Date)value));
                            this.contentHandler.characters(text.toCharArray(), 0, text.length());
                        } else {
                            String text = value.toString();
                            this.contentHandler.characters(text.toCharArray(), 0, text.length());
                        }
                        this.contentHandler.endElement("", "", name);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void handleFeature(Feature f) {
            try {
                this.contentHandler.startElement("", "", this.memberString, this.NULL_ATTS);
                FeatureType type = f.getFeatureType();
                String name = type.getTypeName();
                this.currentPrefix = this.getNamespaceSupport().getPrefix(f.getFeatureType().getNamespace().toString());
                if (this.currentPrefix == null) {
                    this.currentPrefix = this.types.findPrefix(f.getFeatureType());
                }
                if (this.currentPrefix == null) {
                    throw new RuntimeException("Could not locate namespace for FeatureType : " + type.getTypeName() + ":" + type.getNamespace() + "look up in: " + this.types);
                }
                if (this.currentPrefix != null) {
                    name = this.currentPrefix + ":" + name;
                }
                Attributes fidAtts = this.encodeFeatureId(f);
                this.contentHandler.startElement("", "", name, fidAtts);
                if (this.featureBounding && (!this.prefixGml || f.getAttribute("boundedBy") == null)) {
                    this.writeBounds((Envelope)f.getBounds());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected Attributes encodeFeatureId(Feature f) {
            AttributesImpl fidAtts = new AttributesImpl();
            String fid = f.getID();
            if (fid != null) {
                fidAtts.addAttribute("", "fid", "fid", "fids", fid);
            }
            return fidAtts;
        }
    }

    public static class FeatureTypeNamespaces {
        Map lookup = new HashMap();
        NamespaceSupport nsSupport;
        String defaultPrefix = null;

        public FeatureTypeNamespaces(NamespaceSupport nsSupport) {
            this.nsSupport = nsSupport;
        }

        public void declareDefaultNamespace(String prefix, String nsURI) {
            this.defaultPrefix = prefix;
            this.nsSupport.declarePrefix(prefix, nsURI);
        }

        public void declareNamespace(FeatureType type, String prefix, String nsURI) {
            this.lookup.put(type, prefix);
            this.nsSupport.declarePrefix(prefix, nsURI);
        }

        public String findPrefix(FeatureType type) {
            String pre = (String)this.lookup.get(type);
            if (pre == null) {
                pre = this.defaultPrefix;
            }
            return pre;
        }

        public String toString() {
            return "FeatureTypeNamespaces[Default: " + this.defaultPrefix + ", lookUp: " + this.lookup;
        }
    }
}

