/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.Iterator;
import java.util.logging.Logger;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.BetweenFilter;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.Expression;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.Filters;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.LogicFilter;
import org.geotools.filter.MathExpression;
import org.geotools.filter.NullFilter;
import org.geotools.filter.visitor.NullExpressionVisitor;
import org.geotools.util.logging.Logging;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

public class AbstractFilterVisitor
implements FilterVisitor,
org.opengis.filter.FilterVisitor {
    private static Logger LOGGER = Logging.getLogger("org.geotools.filter.visitor");
    private ExpressionVisitor expressionVisitor;

    public AbstractFilterVisitor() {
        this(new NullExpressionVisitor());
    }

    public AbstractFilterVisitor(ExpressionVisitor expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }

    public Object visit(IncludeFilter filter, Object data) {
        return data;
    }

    public Object visit(ExcludeFilter filter, Object data) {
        return data;
    }

    public Object visitNullFilter(Object data) {
        return null;
    }

    public void visit(Filter filter) {
    }

    public void visit(BetweenFilter filter) {
        if (filter.getLeftValue() != null) {
            filter.getLeftValue().accept((FilterVisitor)this);
        }
        if (filter.getMiddleValue() != null) {
            filter.getMiddleValue().accept((FilterVisitor)this);
        }
        if (filter.getRightValue() != null) {
            filter.getRightValue().accept((FilterVisitor)this);
        }
    }

    public Object visit(PropertyIsBetween filter, Object data) {
        if (filter.getLowerBoundary() != null) {
            filter.getLowerBoundary().accept(this.expressionVisitor, data);
        }
        if (filter.getExpression() != null) {
            filter.getExpression().accept(this.expressionVisitor, data);
        }
        if (filter.getUpperBoundary() != null) {
            filter.getUpperBoundary().accept(this.expressionVisitor, data);
        }
        return filter;
    }

    public void visit(CompareFilter filter) {
        if (filter.getLeftValue() != null) {
            filter.getLeftValue().accept((FilterVisitor)this);
        }
        if (filter.getRightValue() != null) {
            filter.getRightValue().accept((FilterVisitor)this);
        }
    }

    protected Object visit(BinaryComparisonOperator filter, Object data) {
        if (this.expressionVisitor != null) {
            if (filter.getExpression1() != null) {
                filter.getExpression1().accept(this.expressionVisitor, data);
            }
            if (filter.getExpression2() != null) {
                filter.getExpression2().accept(this.expressionVisitor, data);
            }
        }
        return filter;
    }

    public Object visit(PropertyIsEqualTo filter, Object data) {
        return this.visit((BinaryComparisonOperator)filter, data);
    }

    public Object visit(PropertyIsNotEqualTo filter, Object data) {
        return this.visit((BinaryComparisonOperator)filter, data);
    }

    public Object visit(PropertyIsLessThan filter, Object data) {
        return this.visit((BinaryComparisonOperator)filter, data);
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object data) {
        return this.visit((BinaryComparisonOperator)filter, data);
    }

    public Object visit(PropertyIsGreaterThan filter, Object data) {
        return this.visit((BinaryComparisonOperator)filter, data);
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object data) {
        return this.visit((BinaryComparisonOperator)filter, data);
    }

    public void visit(GeometryFilter filter) {
        if (filter.getLeftGeometry() != null) {
            filter.getLeftGeometry().accept((FilterVisitor)this);
        }
        if (filter.getRightGeometry() != null) {
            filter.getRightGeometry().accept((FilterVisitor)this);
        }
    }

    public Object visit(BBOX filter, Object data) {
        return filter;
    }

    protected Object visit(BinarySpatialOperator filter, Object data) {
        if (this.expressionVisitor != null) {
            if (filter.getExpression1() != null) {
                filter.getExpression1().accept(this.expressionVisitor, data);
            }
            if (filter.getExpression2() != null) {
                filter.getExpression2().accept(this.expressionVisitor, data);
            }
        }
        return filter;
    }

    public Object visit(Beyond filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    public Object visit(Contains filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    public Object visit(Crosses filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    public Object visit(Disjoint filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    public Object visit(DWithin filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    public Object visit(Equals filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    public Object visit(Intersects filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    public Object visit(Overlaps filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    public Object visit(Touches filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    public Object visit(Within filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    public void visit(LikeFilter filter) {
        if (filter.getValue() != null) {
            filter.getValue().accept((FilterVisitor)this);
        }
    }

    public Object visit(PropertyIsLike filter, Object data) {
        if (this.expressionVisitor != null && filter.getExpression() != null) {
            filter.getExpression().accept(this.expressionVisitor, null);
        }
        return filter;
    }

    public void visit(LogicFilter filter) {
        Iterator it = filter.getFilterIterator();
        while (it.hasNext()) {
            Filters.accept((org.opengis.filter.Filter)it.next(), this);
        }
    }

    protected Object visit(BinaryLogicOperator filter, Object data) {
        if (filter.getChildren() != null) {
            Iterator i = filter.getChildren().iterator();
            while (i.hasNext()) {
                org.opengis.filter.Filter child = (org.opengis.filter.Filter)i.next();
                child.accept(this, data);
            }
        }
        return filter;
    }

    public Object visit(And filter, Object data) {
        return this.visit((BinaryLogicOperator)filter, data);
    }

    public Object visit(Or filter, Object data) {
        return this.visit((BinaryLogicOperator)filter, data);
    }

    public Object visit(Not filter, Object data) {
        if (filter.getFilter() != null) {
            filter.getFilter().accept(this, data);
        }
        return filter;
    }

    public void visit(NullFilter filter) {
        if (filter.getNullCheckValue() != null) {
            filter.getNullCheckValue().accept((FilterVisitor)this);
        }
    }

    public Object visit(PropertyIsNull filter, Object data) {
        if (this.expressionVisitor != null && filter.getExpression() != null) {
            filter.getExpression().accept(this.expressionVisitor, data);
        }
        return filter;
    }

    public void visit(FidFilter filter) {
    }

    public Object visit(Id filter, Object data) {
        return filter;
    }

    public void visit(AttributeExpression expression) {
    }

    public void visit(Expression expression) {
    }

    public void visit(LiteralExpression expression) {
    }

    public void visit(MathExpression expression) {
        if (expression.getLeftValue() != null) {
            expression.getLeftValue().accept((FilterVisitor)this);
        }
        if (expression.getRightValue() != null) {
            expression.getRightValue().accept((FilterVisitor)this);
        }
    }

    public void visit(FunctionExpression expression) {
        Expression[] args = expression.getArgs();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            args[i].accept((FilterVisitor)this);
        }
    }
}

