/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import org.geotools.feature.Feature;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.GeometryFilterImpl;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;

public class BBOXImpl
extends GeometryFilterImpl
implements BBOX {
    double minx;
    double miny;
    double maxx;
    double maxy;
    String srs;

    public BBOXImpl(FilterFactory factory, Expression e1, Expression e2) {
        super(factory, e1, e2);
        this.filterType = (short)4;
        if (e1 != null) {
            this.setExpression1(e1);
        }
        if (e2 != null) {
            this.setExpression2(e2);
        }
    }

    public String getPropertyName() {
        if (this.getExpression1() instanceof PropertyName) {
            PropertyName propertyName = (PropertyName)this.getExpression1();
            return propertyName.getPropertyName();
        }
        if (this.getExpression2() instanceof PropertyName) {
            PropertyName propertyName = (PropertyName)this.getExpression2();
            return propertyName.getPropertyName();
        }
        return null;
    }

    public void setPropertyName(String propertyName) {
        this.setExpression1(new AttributeExpressionImpl(propertyName));
    }

    public String getSRS() {
        return this.srs;
    }

    public void setSRS(String srs) {
        this.srs = srs;
    }

    public double getMinX() {
        return this.minx;
    }

    public void setMinX(double minx) {
        this.minx = minx;
    }

    public double getMinY() {
        return this.miny;
    }

    public void setMinY(double miny) {
        this.miny = miny;
    }

    public double getMaxX() {
        return this.maxx;
    }

    public void setMaxX(double maxx) {
        this.maxx = maxx;
    }

    public double getMaxY() {
        return this.maxy;
    }

    public void setMaxY(double maxy) {
        this.maxy = maxy;
    }

    public boolean evaluate(Object feature) {
        if (feature instanceof Feature && !this.validate((Feature)feature)) {
            return false;
        }
        Geometry left = this.getLeftGeometry(feature);
        Geometry right = this.getRightGeometry(feature);
        Envelope envLeft = left.getEnvelopeInternal();
        Envelope envRight = right.getEnvelopeInternal();
        if (envRight.contains(envLeft) || envLeft.contains(envRight)) {
            return true;
        }
        if (envRight.intersects(envLeft)) {
            return left.intersects(right);
        }
        return false;
    }

    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit(this, extraData);
    }

    public void setExpression1(Expression expression) {
        this.updateMinMaxFields(expression);
        super.setExpression1(expression);
    }

    public void setExpression2(Expression expression) {
        this.updateMinMaxFields(expression);
        super.setExpression2(expression);
    }

    private void updateMinMaxFields(Expression expression) {
        if (expression instanceof Literal) {
            Literal bbox = (Literal)expression;
            Envelope env = (Envelope)bbox.evaluate(null, Envelope.class);
            if (env == null) {
                return;
            }
            this.minx = env.getMinX();
            this.maxx = env.getMaxX();
            this.miny = env.getMinY();
            this.maxy = env.getMaxY();
        }
    }
}

