/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.BoundsVisitor;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.FeatureVisitor;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.visitor.AbstractFilterVisitor;
import org.geotools.util.logging.Logging;

public class Collection_BoundsFunction
extends FunctionExpressionImpl {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.filter.function");
    FeatureCollection previousFeatureCollection = null;
    Object bounds = null;

    public Collection_BoundsFunction() {
        super("Collection_Bounds");
    }

    public int getArgCount() {
        return 1;
    }

    public static CalcResult calculateBounds(FeatureCollection collection) throws IllegalFilterException, IOException {
        BoundsVisitor boundsVisitor = new BoundsVisitor();
        collection.accepts((FeatureVisitor)boundsVisitor, null);
        return boundsVisitor.getResult();
    }

    public void setParameters(List args) {
        super.setParameters(args);
        if (args.size() != 1) {
            throw new IllegalArgumentException("Require a single argument for unique");
        }
        Expression expr = (Expression)this.getExpression(0);
        expr.accept((FilterVisitor)new AbstractFilterVisitor(){

            public void visit(AttributeExpression expression) {
                String xpath = expression.getAttributePath();
                if (xpath.startsWith("featureMembers/*/")) {
                    xpath = xpath.substring(17);
                } else if (xpath.startsWith("featureMember/*/")) {
                    xpath = xpath.substring(16);
                }
                try {
                    expression.setAttributePath(xpath);
                }
                catch (IllegalFilterException illegalFilterException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(Object feature) {
        FeatureCollection featureCollection;
        if (feature == null) {
            return new Integer(0);
        }
        FeatureCollection featureCollection2 = featureCollection = (FeatureCollection)feature;
        synchronized (featureCollection2) {
            if (featureCollection != this.previousFeatureCollection) {
                this.previousFeatureCollection = featureCollection;
                this.bounds = null;
                try {
                    CalcResult result = Collection_BoundsFunction.calculateBounds(featureCollection);
                    if (result != null) {
                        this.bounds = result.getValue();
                    }
                }
                catch (IllegalFilterException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
            }
        }
        return this.bounds;
    }

    public void setExpression(Expression e) {
        this.setParameters(Collections.singletonList(e));
    }
}

