/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.AverageVisitor;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.FeatureVisitor;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.visitor.AbstractFilterVisitor;
import org.geotools.util.logging.Logging;

public class Collection_AverageFunction
extends FunctionExpressionImpl {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.filter.function");
    FeatureCollection previousFeatureCollection = null;
    Object average = null;
    Expression expr;

    public Collection_AverageFunction() {
        super("Collection_Average");
    }

    public int getArgCount() {
        return 1;
    }

    public static CalcResult calculateAverage(FeatureCollection collection, Expression expression) throws IllegalFilterException, IOException {
        AverageVisitor averageVisitor = new AverageVisitor((org.opengis.filter.expression.Expression)expression);
        collection.accepts((FeatureVisitor)averageVisitor, null);
        return averageVisitor.getResult();
    }

    public void setParameters(List params) {
        super.setParameters(params);
        if (params.size() != 1) {
            throw new IllegalArgumentException("Require a single argument for average");
        }
        this.expr = (Expression)this.getExpression(0);
        this.expr.accept((FilterVisitor)new AbstractFilterVisitor(){

            public void visit(AttributeExpression expression) {
                String xpath = expression.getAttributePath();
                if (xpath.startsWith("featureMembers/*/")) {
                    xpath = xpath.substring(17);
                } else if (xpath.startsWith("featureMember/*/")) {
                    xpath = xpath.substring(16);
                }
                try {
                    expression.setAttributePath(xpath);
                }
                catch (IllegalFilterException illegalFilterException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(Object feature) {
        FeatureCollection featureCollection;
        if (feature == null) {
            return new Integer(0);
        }
        FeatureCollection featureCollection2 = featureCollection = (FeatureCollection)feature;
        synchronized (featureCollection2) {
            if (featureCollection != this.previousFeatureCollection) {
                this.previousFeatureCollection = featureCollection;
                this.average = null;
                try {
                    CalcResult result = Collection_AverageFunction.calculateAverage(featureCollection, this.expr);
                    if (result != null) {
                        this.average = result.getValue();
                    }
                }
                catch (IllegalFilterException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
            }
        }
        return this.average;
    }

    public void setExpression(Expression e) {
        this.setParameters(Collections.singletonList(e));
    }

    public String toString() {
        return "Collection_Average(" + this.expr + ")";
    }
}

