/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.FunctionImpl;
import org.opengis.filter.expression.Function;

public class FunctionFinder {
    private Map functionExpressionCache;
    private Map functionImplCache;

    public FunctionFinder(Hints hints) {
    }

    public Function findFunction(String name) {
        return this.findFunction(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function findFunction(String name, List parameters) {
        name = this.functionName(name);
        try {
            Object function;
            FunctionFinder functionFinder = this;
            synchronized (functionFinder) {
                if (this.functionExpressionCache == null) {
                    Object function2;
                    this.functionExpressionCache = new HashMap();
                    this.functionImplCache = new HashMap();
                    Set functions = CommonFactoryFinder.getFunctionExpressions(null);
                    Iterator it = functions.iterator();
                    while (it.hasNext()) {
                        function2 = (FunctionExpression)it.next();
                        this.functionExpressionCache.put(function2.getName().toLowerCase(), function2.getClass());
                    }
                    functions = CommonFactoryFinder.getFunctions(null);
                    Iterator i = functions.iterator();
                    while (i.hasNext()) {
                        function2 = (FunctionImpl)i.next();
                        this.functionImplCache.put(((FunctionImpl)function2).getName().toLowerCase(), function2.getClass());
                    }
                }
            }
            Class clazz = (Class)this.functionExpressionCache.get(name.toLowerCase());
            if (clazz != null) {
                function = (FunctionExpression)clazz.newInstance();
                if (parameters != null) {
                    function.setParameters(parameters);
                }
                return function;
            }
            clazz = (Class)this.functionImplCache.get(name.toLowerCase());
            if (clazz != null) {
                function = (FunctionImpl)clazz.newInstance();
                if (parameters != null) {
                    ((FunctionImpl)function).setParameters(parameters);
                }
                return function;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create class " + name + "Function", e);
        }
        throw new RuntimeException("Unable to find function " + name);
    }

    private String functionName(String name) {
        int index = -1;
        index = name.indexOf("Function");
        if (index != -1) {
            name = name.substring(0, index);
        }
        name = name.toLowerCase().trim();
        char c = name.charAt(0);
        name = name.replaceFirst("" + c, "" + Character.toUpperCase(c));
        return name;
    }
}

