/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.awt.Color;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.FilterVisitor2;
import org.geotools.filter.visitor.DuplicatorFilterVisitor;
import org.opengis.filter.And;
import org.opengis.filter.Id;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;

public class Filters {
    public static final int NOTFOUND = -1;
    FilterFactory ff;

    public Filters() {
        this(FilterFactoryFinder.createFilterFactory());
    }

    public Filters(FilterFactory factory) {
        this.ff = factory;
    }

    public void setFilterFactory(FilterFactory factory) {
        this.ff = factory;
    }

    public static org.opengis.filter.Filter and(org.opengis.filter.FilterFactory ff, org.opengis.filter.Filter a, org.opengis.filter.Filter b) {
        ArrayList<org.opengis.filter.Filter> list = new ArrayList<org.opengis.filter.Filter>();
        if (a instanceof And) {
            And some = (And)a;
            list.addAll(some.getChildren());
        } else {
            list.add(a);
        }
        if (b instanceof And) {
            And more = (And)b;
            list.addAll(more.getChildren());
        } else {
            list.add(b);
        }
        return ff.and(list);
    }

    public static org.opengis.filter.Filter or(org.opengis.filter.FilterFactory ff, org.opengis.filter.Filter a, org.opengis.filter.Filter b) {
        ArrayList<org.opengis.filter.Filter> list = new ArrayList<org.opengis.filter.Filter>();
        if (a instanceof Or) {
            Or some = (Or)a;
            list.addAll(some.getChildren());
        } else {
            list.add(a);
        }
        if (b instanceof Or) {
            Or more = (Or)b;
            list.addAll(more.getChildren());
        } else {
            list.add(b);
        }
        return ff.or(list);
    }

    public static void accept(org.opengis.filter.Filter filter, FilterVisitor visitor) {
        if (filter == org.opengis.filter.Filter.EXCLUDE) {
            if (visitor instanceof FilterVisitor2) {
                ((FilterVisitor2)visitor).visit(org.opengis.filter.Filter.EXCLUDE);
            }
            return;
        }
        if (filter == org.opengis.filter.Filter.INCLUDE) {
            if (visitor instanceof FilterVisitor2) {
                ((FilterVisitor2)visitor).visit(org.opengis.filter.Filter.INCLUDE);
            }
            return;
        }
        if (!(filter instanceof Filter)) {
            throw new ClassCastException("Please update your code to a org.opengis.filter.FilterVisitor");
        }
        ((Filter)filter).accept(visitor);
    }

    public org.opengis.filter.Filter duplicate(org.opengis.filter.Filter filter) {
        DuplicatorFilterVisitor xerox = new DuplicatorFilterVisitor(this.ff);
        Filters.accept(filter, xerox);
        return (org.opengis.filter.Filter)xerox.getCopy();
    }

    public static short getFilterType(org.opengis.filter.Filter filter) {
        if (filter == org.opengis.filter.Filter.EXCLUDE) {
            return -12345;
        }
        if (filter == org.opengis.filter.Filter.INCLUDE) {
            return 12345;
        }
        if (filter instanceof org.opengis.filter.Filter) {
            return ((Filter)filter).getFilterType();
        }
        if (filter instanceof PropertyIsBetween) {
            return 19;
        }
        if (filter instanceof PropertyIsEqualTo) {
            return 14;
        }
        if (filter instanceof PropertyIsGreaterThan) {
            return 16;
        }
        if (filter instanceof PropertyIsGreaterThanOrEqualTo) {
            return 18;
        }
        if (filter instanceof PropertyIsLessThan) {
            return 15;
        }
        if (filter instanceof PropertyIsLessThanOrEqualTo) {
            return 17;
        }
        if (filter instanceof PropertyIsNotEqualTo) {
            return 23;
        }
        if (filter instanceof Id) {
            return 22;
        }
        if (filter instanceof BBOX) {
            return 4;
        }
        if (filter instanceof Beyond) {
            return 13;
        }
        if (filter instanceof Contains) {
            return 11;
        }
        if (filter instanceof Crosses) {
            return 9;
        }
        if (filter instanceof Disjoint) {
            return 6;
        }
        if (filter instanceof DWithin) {
            return 24;
        }
        if (filter instanceof Equals) {
            return 5;
        }
        if (filter instanceof Intersects) {
            return 7;
        }
        if (filter instanceof Overlaps) {
            return 12;
        }
        if (filter instanceof Touches) {
            return 8;
        }
        if (filter instanceof Within) {
            return 10;
        }
        if (filter instanceof PropertyIsLike) {
            return 20;
        }
        if (filter instanceof And) {
            return 2;
        }
        if (filter instanceof Not) {
            return 3;
        }
        if (filter instanceof Or) {
            return 1;
        }
        if (filter instanceof PropertyIsNull) {
            return 21;
        }
        return 0;
    }

    public static int asInt(Expression expr) {
        Number number = (Number)Filters.asType(expr, Number.class);
        if (number != null) {
            return number.intValue();
        }
        String string = (String)Filters.asType(expr, String.class);
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static String asString(Expression expr) {
        String string = (String)Filters.asType(expr, String.class);
        return string;
    }

    public static double asDouble(Expression expr) {
        Number number = (Number)Filters.asType(expr, Number.class);
        if (number != null) {
            return number.doubleValue();
        }
        String string = (String)Filters.asType(expr, String.class);
        if (string != null) {
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Double.NaN;
    }

    public static Object asType(Expression expr, Class TYPE) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof Literal) {
            Literal literal = (Literal)expr;
            Object value = literal.getValue();
            if (TYPE.isInstance(value)) {
                return value;
            }
        } else if (expr instanceof Function) {
            Function function = (Function)expr;
            List params = function.getParameters();
            if (params != null && params.size() != 0) {
                for (int i = 0; i < params.size(); ++i) {
                    Expression e = (Expression)params.get(i);
                    Object value = Filters.asType(e, TYPE);
                    if (value == null) continue;
                    return value;
                }
            }
        } else {
            try {
                Object value = expr.evaluate(null, TYPE);
                if (TYPE.isInstance(value)) {
                    return value;
                }
            }
            catch (NullPointerException expected) {
                return null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static double number(Object value) {
        if (value == null) {
            return Double.NaN;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        if (value instanceof String) {
            String text = (String)value;
            try {
                Number number = (Number)Filters.gets(text, Number.class);
                return number.doubleValue();
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Unable to decode '" + text + "' as a number");
            }
        }
        if (value instanceof Expression) {
            throw new IllegalArgumentException("Cannot deal with un evaulated Expression");
        }
        throw new IllegalArgumentException("Unable to evaulate " + value.getClass() + " in a numeric context");
    }

    public static Object gets(String text, Class TYPE) throws Throwable {
        if (text == null) {
            return null;
        }
        if (TYPE == String.class) {
            return text;
        }
        if (TYPE == Integer.class) {
            return Integer.decode(text);
        }
        if (TYPE == Double.class) {
            return Double.valueOf(text);
        }
        if (TYPE == Number.class) {
            try {
                return Double.valueOf(text);
            }
            catch (NumberFormatException ignore) {
                return Integer.decode(text);
            }
        }
        if (TYPE == Color.class) {
            return new Color(Integer.decode(text));
        }
        try {
            Constructor create = TYPE.getConstructor(String.class);
            return create.newInstance(text);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        return null;
    }

    public static String puts(double number) {
        if (Math.rint(number) == number) {
            return Integer.toString((int)number);
        }
        return Double.toString(number);
    }

    public static String puts(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Color) {
            Color color = (Color)obj;
            return Filters.puts(color);
        }
        if (obj instanceof Number) {
            Number number = (Number)obj;
            return Filters.puts(number.doubleValue());
        }
        return obj.toString();
    }

    public static String puts(Color color) {
        String redCode = Integer.toHexString(color.getRed());
        String greenCode = Integer.toHexString(color.getGreen());
        String blueCode = Integer.toHexString(color.getBlue());
        if (redCode.length() == 1) {
            redCode = "0" + redCode;
        }
        if (greenCode.length() == 1) {
            greenCode = "0" + greenCode;
        }
        if (blueCode.length() == 1) {
            blueCode = "0" + blueCode;
        }
        return "#" + redCode + greenCode + blueCode;
    }
}

