/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.filter.BetweenFilter;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.Expression;
import org.geotools.filter.ExpressionDOMParser;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LogicFilter;
import org.geotools.filter.NullFilter;
import org.geotools.util.logging.Logging;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class FilterDOMParser {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.filter");
    private static final FilterFactory FILTER_FACT = FilterFactoryFinder.createFilterFactory();
    private static final int NUM_BETWEEN_CHILDREN = 3;
    private static Map comparisions = new HashMap();
    private static Map spatial = new HashMap();
    private static Map logical = new HashMap();

    private FilterDOMParser() {
    }

    public static Filter parseFilter(Node root) {
        LOGGER.finer("parsingFilter " + root.getLocalName());
        if (root == null || root.getNodeType() != 1) {
            LOGGER.finest("bad node input ");
            return null;
        }
        LOGGER.finest("processing root " + root.getLocalName() + " " + root.getNodeName());
        Node child = root;
        String childName = child.getLocalName();
        if (childName == null) {
            childName = child.getNodeName();
        }
        if (childName.indexOf(58) != -1) {
            childName = childName.substring(childName.indexOf(58) + 1);
        }
        LOGGER.finest("looking up " + childName);
        if (comparisions.containsKey(childName)) {
            LOGGER.finer("a comparision filter " + childName);
            try {
                short type = ((Integer)comparisions.get(childName)).shortValue();
                CompareFilter filter = null;
                LOGGER.finer("type is " + type);
                if (type == 22) {
                    FidFilter fidFilter = FILTER_FACT.createFidFilter();
                    Element fidElement = (Element)child;
                    fidFilter.addFid(fidElement.getAttribute("fid"));
                    for (Node sibling = fidElement.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
                        LOGGER.finer("Parsing another FidFilter");
                        if (sibling.getNodeType() != 1) continue;
                        fidElement = (Element)sibling;
                        String fidElementName = fidElement.getLocalName();
                        if (fidElementName == null) {
                            fidElementName = fidElement.getNodeName();
                        }
                        if (fidElementName.indexOf(58) != -1) {
                            fidElementName = fidElementName.substring(fidElementName.indexOf(58) + 1);
                        }
                        if (!"FeatureId".equals(fidElementName)) continue;
                        fidFilter.addFid(fidElement.getAttribute("fid"));
                    }
                    return fidFilter;
                }
                if (type == 19) {
                    BetweenFilter bfilter = FILTER_FACT.createBetweenFilter();
                    NodeList kids = child.getChildNodes();
                    if (kids.getLength() < 3) {
                        throw new IllegalFilterException("wrong number of children in Between filter: expected 3 got " + kids.getLength());
                    }
                    Node value = child.getFirstChild();
                    while (value.getNodeType() != 1) {
                        value = value.getNextSibling();
                    }
                    LOGGER.finer("add middle value -> " + value + "<-");
                    bfilter.addMiddleValue(ExpressionDOMParser.parseExpression(value));
                    for (int i = 0; i < kids.getLength(); ++i) {
                        String kidName;
                        Node kid = kids.item(i);
                        String string = kidName = kid.getLocalName() != null ? kid.getLocalName() : kid.getNodeName();
                        if (kidName.indexOf(58) != -1) {
                            kidName = kidName.substring(kidName.indexOf(58) + 1);
                        }
                        if (kidName.equalsIgnoreCase("LowerBoundary")) {
                            value = kid.getFirstChild();
                            while (value.getNodeType() != 1) {
                                value = value.getNextSibling();
                            }
                            LOGGER.finer("add left value -> " + value + "<-");
                            bfilter.addLeftValue(ExpressionDOMParser.parseExpression(value));
                        }
                        if (!kidName.equalsIgnoreCase("UpperBoundary")) continue;
                        value = kid.getFirstChild();
                        while (value.getNodeType() != 1) {
                            value = value.getNextSibling();
                        }
                        LOGGER.finer("add right value -> " + value + "<-");
                        bfilter.addRightValue(ExpressionDOMParser.parseExpression(value));
                    }
                    return bfilter;
                }
                if (type == 20) {
                    String wildcard = null;
                    String single = null;
                    String escape = null;
                    String pattern = null;
                    Expression value = null;
                    NodeList map = child.getChildNodes();
                    for (int i = 0; i < map.getLength(); ++i) {
                        String res;
                        Node kid = map.item(i);
                        if (kid == null || kid.getNodeType() != 1) continue;
                        String string = res = kid.getLocalName() != null ? kid.getLocalName() : kid.getNodeName();
                        if (res.indexOf(58) != -1) {
                            res = res.substring(res.indexOf(58) + 1);
                        }
                        if (res.equalsIgnoreCase("PropertyName")) {
                            value = ExpressionDOMParser.parseExpression(kid);
                        }
                        if (!res.equalsIgnoreCase("Literal")) continue;
                        pattern = ExpressionDOMParser.parseExpression(kid).toString();
                    }
                    NamedNodeMap kids = child.getAttributes();
                    for (int i = 0; i < kids.getLength(); ++i) {
                        String res;
                        Node kid = kids.item(i);
                        String string = res = kid.getLocalName() != null ? kid.getLocalName() : kid.getNodeName();
                        if (res.indexOf(58) != -1) {
                            res = res.substring(res.indexOf(58) + 1);
                        }
                        if (res.equalsIgnoreCase("wildCard")) {
                            wildcard = kid.getNodeValue();
                        }
                        if (res.equalsIgnoreCase("singleChar")) {
                            single = kid.getNodeValue();
                        }
                        if (!res.equalsIgnoreCase("escapeChar") && !res.equalsIgnoreCase("escape")) continue;
                        escape = kid.getNodeValue();
                    }
                    if (wildcard != null && single != null && escape != null && pattern != null) {
                        LikeFilter lfilter = FILTER_FACT.createLikeFilter();
                        LOGGER.finer("Building like filter " + value.toString() + "\n" + pattern + " " + wildcard + " " + single + " " + escape);
                        lfilter.setValue(value);
                        lfilter.setPattern(pattern, wildcard, single, escape);
                        return lfilter;
                    }
                    LOGGER.finer("Problem building like filter\n" + pattern + " " + wildcard + " " + single + " " + escape);
                    return null;
                }
                if (type == 21) {
                    return FilterDOMParser.parseNullFilter(child);
                }
                FilterFactory factory = FilterFactoryFinder.createFilterFactory();
                filter = factory.createCompareFilter(type);
                Node value = child.getFirstChild();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finest("add left value -> " + value + "<-");
                filter.addLeftValue(ExpressionDOMParser.parseExpression(value));
                value = value.getNextSibling();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finest("add right value -> " + value + "<-");
                filter.addRightValue(ExpressionDOMParser.parseExpression(value));
                return filter;
            }
            catch (IllegalFilterException ife) {
                LOGGER.warning("Unable to build filter: " + (Object)((Object)ife));
                return null;
            }
        }
        if (spatial.containsKey(childName)) {
            LOGGER.finest("a spatial filter " + childName);
            try {
                String valueName;
                short type = ((Integer)spatial.get(childName)).shortValue();
                GeometryFilter filter = FILTER_FACT.createGeometryFilter(type);
                Node value = child.getFirstChild();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finest("add left value -> " + value + "<-");
                filter.addLeftGeometry(ExpressionDOMParser.parseExpression(value));
                value = value.getNextSibling();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finest("add right value -> " + value + "<-");
                String string = valueName = value.getLocalName() != null ? value.getLocalName() : value.getNodeName();
                if (valueName.indexOf(58) != -1) {
                    valueName = valueName.substring(valueName.indexOf(58) + 1);
                }
                if (!valueName.equalsIgnoreCase("Literal") && !valueName.equalsIgnoreCase("propertyname")) {
                    Element literal = value.getOwnerDocument().createElement("literal");
                    literal.appendChild(value);
                    LOGGER.finest("Built new literal " + literal);
                    value = literal;
                }
                filter.addRightGeometry(ExpressionDOMParser.parseExpression(value));
                return filter;
            }
            catch (IllegalFilterException ife) {
                LOGGER.warning("Unable to build filter: " + (Object)((Object)ife));
                return null;
            }
        }
        if (logical.containsKey(childName)) {
            LOGGER.finest("a logical filter " + childName);
            try {
                short type = ((Integer)logical.get(childName)).shortValue();
                LOGGER.finest("logic type " + type);
                LogicFilter filter = FILTER_FACT.createLogicFilter(type);
                NodeList map = child.getChildNodes();
                for (int i = 0; i < map.getLength(); ++i) {
                    Node kid = map.item(i);
                    if (kid == null || kid.getNodeType() != 1) continue;
                    LOGGER.finest("adding to logic filter " + kid.getLocalName());
                    filter.addFilter((org.opengis.filter.Filter)FilterDOMParser.parseFilter(kid));
                }
                return filter;
            }
            catch (IllegalFilterException ife) {
                LOGGER.warning("Unable to build filter: " + (Object)((Object)ife));
                return null;
            }
        }
        LOGGER.warning("unknown filter " + root);
        return null;
    }

    private static NullFilter parseNullFilter(Node nullNode) throws IllegalFilterException {
        LOGGER.finest("parsing null node: " + nullNode);
        NullFilter nFilter = FILTER_FACT.createNullFilter();
        Node value = nullNode.getFirstChild();
        while (value.getNodeType() != 1) {
            value = value.getNextSibling();
        }
        LOGGER.finest("add null value -> " + value + "<-");
        nFilter.nullCheckValue(ExpressionDOMParser.parseExpression(value));
        return nFilter;
    }

    static {
        comparisions.put("PropertyIsEqualTo", new Integer(14));
        comparisions.put("PropertyIsNotEqualTo", new Integer(23));
        comparisions.put("PropertyIsGreaterThan", new Integer(16));
        comparisions.put("PropertyIsGreaterThanOrEqualTo", new Integer(18));
        comparisions.put("PropertyIsLessThan", new Integer(15));
        comparisions.put("PropertyIsLessThanOrEqualTo", new Integer(17));
        comparisions.put("PropertyIsLike", new Integer(20));
        comparisions.put("PropertyIsNull", new Integer(21));
        comparisions.put("PropertyIsBetween", new Integer(19));
        comparisions.put("FeatureId", new Integer(22));
        spatial.put("Equals", new Integer(5));
        spatial.put("Disjoint", new Integer(6));
        spatial.put("Intersects", new Integer(7));
        spatial.put("Touches", new Integer(8));
        spatial.put("Crosses", new Integer(9));
        spatial.put("Within", new Integer(10));
        spatial.put("Contains", new Integer(11));
        spatial.put("Overlaps", new Integer(12));
        spatial.put("Beyond", new Integer(13));
        spatial.put("BBOX", new Integer(4));
        logical.put("And", new Integer(2));
        logical.put("Or", new Integer(1));
        logical.put("Not", new Integer(3));
    }
}

