/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.ArrayList;
import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Or;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;

public class FilterBuilder {
    FilterFactory ff;
    List filter = new ArrayList(2);
    List expression = new ArrayList(3);
    private String name;

    public FilterBuilder literal(byte number) {
        this.expression.add(this.ff.literal(number));
        return this;
    }

    public FilterBuilder literal(short number) {
        this.expression.add(this.ff.literal(number));
        return this;
    }

    public FilterBuilder literal(int number) {
        this.expression.add(this.ff.literal(number));
        return this;
    }

    public FilterBuilder literal(long number) {
        this.expression.add(this.ff.literal(number));
        return this;
    }

    public FilterBuilder literal(double number) {
        this.expression.add(this.ff.literal(number));
        return this;
    }

    public FilterBuilder literal(Object object) {
        this.expression.add(this.ff.literal(object));
        return this;
    }

    public Expression expr() {
        if (this.expression.isEmpty()) {
            return Expression.NIL;
        }
        return (Expression)this.expression.remove(this.expression.size() - 1);
    }

    private FilterBuilder build(Expression expression) {
        this.expression.add(expression);
        return this;
    }

    private FilterBuilder build(Filter filter) {
        this.filter.add(filter);
        return this;
    }

    public FilterBuilder() {
        this(CommonFactoryFinder.getFilterFactory(null));
    }

    public FilterBuilder(Hints hints) {
        this(CommonFactoryFinder.getFilterFactory(hints));
    }

    public FilterBuilder(FilterFactory filterFactory) {
        this.ff = filterFactory;
    }

    public void setFilterFactory(FilterFactory factory) {
        this.ff = factory;
    }

    public void init() {
        this.expression.clear();
        this.filter.clear();
    }

    public void init(Filter filter) {
        this.init();
        this.filter.add(filter);
    }

    public void init(Expression expr) {
        this.init();
        this.expression.add(expr);
    }

    public Filter filter() {
        if (this.filter.isEmpty()) {
            return Filter.EXCLUDE;
        }
        return (Filter)this.filter.remove(this.filter.size() - 1);
    }

    public FilterBuilder left(Expression left) {
        this.setLeft(left);
        return this;
    }

    public void setLeft(Expression left) {
        this.setExpression(0, left);
    }

    public FilterBuilder right(Expression right) {
        this.setRight(right);
        return this;
    }

    public void setRight(Expression right) {
        this.setExpression(2, right);
    }

    public FilterBuilder expression(Expression expr) {
        this.expression.add(expr);
        return this;
    }

    public FilterBuilder expression(int position, Expression expr) {
        this.setExpression(position, expr);
        return this;
    }

    public void setExpression(int position, Expression expr) {
        while (this.expression.size() < position) {
            this.expression.add(null);
        }
        this.expression.set(position, expr);
    }

    FilterBuilder name(String name) {
        this.name = name;
        return this;
    }

    Function function() {
        Function function = this.ff.function(this.name, this.expression.toArray(new Expression[this.expression.size()]));
        this.expression.clear();
        this.expression.add(function);
        return function;
    }

    Function function(String functionName) {
        this.name(functionName);
        return this.function();
    }

    public Expression add() {
        return this.add(this).expr();
    }

    public FilterBuilder add(Object number) {
        return this.add(this.ff.literal(number));
    }

    public FilterBuilder add(long number) {
        return this.add(this.ff.literal(number));
    }

    public FilterBuilder add(double number) {
        return this.add(this.ff.literal(number));
    }

    public FilterBuilder add(FilterBuilder build) {
        return this.add(build.expr());
    }

    public FilterBuilder add(Expression right) {
        Expression left = this.expr();
        return this.build(this.ff.add(left, right));
    }

    public Expression subtract() {
        return this.subtract(this).expr();
    }

    public FilterBuilder subtract(Object number) {
        return this.subtract(this.ff.literal(number));
    }

    public FilterBuilder subtract(long number) {
        return this.subtract(this.ff.literal(number));
    }

    public FilterBuilder subtract(double number) {
        return this.subtract(this.ff.literal(number));
    }

    public FilterBuilder subtract(FilterBuilder build) {
        return this.subtract(build.expr());
    }

    public FilterBuilder subtract(Expression right) {
        Expression left = this.expr();
        return this.build(this.ff.subtract(left, right));
    }

    public Expression multiply() {
        return this.multiply(this).expr();
    }

    public FilterBuilder multiply(Object number) {
        return this.multiply(this.ff.literal(number));
    }

    public FilterBuilder multiply(long number) {
        return this.multiply(this.ff.literal(number));
    }

    public FilterBuilder multiply(double number) {
        return this.multiply(this.ff.literal(number));
    }

    public FilterBuilder multiply(FilterBuilder build) {
        return this.multiply(build.expr());
    }

    public FilterBuilder multiply(Expression right) {
        Expression left = this.expr();
        return this.build(this.ff.multiply(left, right));
    }

    public Expression divide() {
        return this.divide(this).expr();
    }

    public FilterBuilder divide(long number) {
        return this.divide(this.ff.literal(number));
    }

    public FilterBuilder divide(double number) {
        return this.divide(this.ff.literal(number));
    }

    public FilterBuilder divide(FilterBuilder build) {
        return this.divide(build.expr());
    }

    public FilterBuilder divide(Expression right) {
        Expression left = this.expr();
        return this.build(this.ff.divide(left, right));
    }

    public Filter and() {
        if (this.filter.isEmpty()) {
            return Filter.EXCLUDE;
        }
        if (this.filter.size() == 1) {
            return this.filter();
        }
        And and = this.ff.and(this.filter);
        this.filter = new ArrayList(2);
        return and;
    }

    public FilterBuilder and(FilterBuilder build) {
        return this.and(build.filter());
    }

    public FilterBuilder and(Filter right) {
        Filter left = this.filter();
        if (left instanceof And) {
            And and = (And)left;
            ArrayList<Filter> children = new ArrayList<Filter>(and.getChildren());
            children.add(right);
            return this.build(this.ff.and(children));
        }
        return this.build(this.ff.and(left, right));
    }

    public Filter or() {
        if (this.filter.isEmpty()) {
            return Filter.INCLUDE;
        }
        if (this.filter.size() == 1) {
            return this.filter();
        }
        Or or = this.ff.or(this.filter);
        this.filter = new ArrayList(2);
        return or;
    }

    public FilterBuilder or(FilterBuilder build) {
        return this.or(build.filter());
    }

    public FilterBuilder or(Filter right) {
        Filter left = this.filter();
        if (left instanceof Or) {
            Or or = (Or)left;
            ArrayList<Filter> children = new ArrayList<Filter>(or.getChildren());
            children.add(right);
            return this.build(this.ff.or(children));
        }
        return this.build(this.ff.or(left, right));
    }
}

