/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureType;
import org.geotools.filter.visitor.DefaultFilterVisitor;
import org.opengis.filter.expression.PropertyName;

public class FilterAttributeExtractor
extends DefaultFilterVisitor {
    protected Set attributeNames = new HashSet();
    protected FeatureType featureType;

    public FilterAttributeExtractor() {
        this(null);
    }

    public FilterAttributeExtractor(FeatureType featureType) {
        this.featureType = featureType;
    }

    public Set getAttributeNameSet() {
        return Collections.unmodifiableSet(this.attributeNames);
    }

    public String[] getAttributeNames() {
        return this.attributeNames.toArray(new String[this.attributeNames.size()]);
    }

    public void clear() {
        this.attributeNames = new HashSet();
    }

    public Object visit(PropertyName expression, Object data) {
        if (data != null && data != this.attributeNames) {
            this.attributeNames = (Set)data;
        }
        if (this.featureType != null) {
            AttributeType type = (AttributeType)expression.evaluate(this.featureType);
            if (type != null) {
                this.attributeNames.add(type.getName());
            } else {
                this.attributeNames.add(expression.getPropertyName());
            }
        } else {
            this.attributeNames.add(expression.getPropertyName());
        }
        return this.attributeNames;
    }
}

