/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.filter.AbstractFilterImpl;
import org.geotools.filter.FidFilter;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessors;
import org.geotools.util.logging.Logging;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.identity.Identifier;

public class FidFilterImpl
extends AbstractFilterImpl
implements FidFilter {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.core");
    private Set fids = new HashSet();

    protected FidFilterImpl() {
        super(FilterFactoryFinder.createFilterFactory());
        this.filterType = (short)22;
    }

    protected FidFilterImpl(String initialFid) {
        super(FilterFactoryFinder.createFilterFactory());
        this.filterType = (short)22;
        this.addFid(initialFid);
    }

    protected FidFilterImpl(Set fids) {
        super(FilterFactoryFinder.createFilterFactory());
        this.filterType = (short)22;
        Iterator it = fids.iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (next instanceof Identifier) continue;
            throw new ClassCastException("Fids must implement Identifier, " + next.getClass() + " does not");
        }
        this.fids = fids;
    }

    public final String[] getFids() {
        return this.fids().toArray(new String[0]);
    }

    public Set getIDs() {
        return this.getFidsSet();
    }

    public Set getIdentifiers() {
        return this.fids;
    }

    public void setIDs(Set ids) {
        this.fids = new HashSet();
        this.addAllFids(ids);
    }

    public Set getFidsSet() {
        return this.fids();
    }

    private Set fids() {
        HashSet<String> set = new HashSet<String>();
        Iterator i = this.fids.iterator();
        while (i.hasNext()) {
            Identifier id = (Identifier)i.next();
            set.add(((Object)id).toString());
        }
        return set;
    }

    public final void addFid(String fid) {
        LOGGER.finest("got fid: " + fid);
        this.fids.add(this.factory.featureId(fid));
    }

    public void addAllFids(Collection fidsToAdd) {
        if (fidsToAdd == null) {
            return;
        }
        Iterator i = fidsToAdd.iterator();
        while (i.hasNext()) {
            String fid = (String)i.next();
            this.addFid(fid);
        }
    }

    public final void removeFid(String fid) {
        if (fid == null) {
            return;
        }
        Iterator f = this.fids.iterator();
        while (f.hasNext()) {
            Identifier featureId = (Identifier)f.next();
            if (!fid.equals(((Object)featureId).toString())) continue;
            f.remove();
        }
    }

    public void removeAllFids(Collection fidsToRemove) {
        if (fidsToRemove == null) {
            return;
        }
        Iterator f = fidsToRemove.iterator();
        while (f.hasNext()) {
            String fid = (String)f.next();
            this.removeFid(fid);
        }
    }

    public boolean evaluate(Object feature) {
        if (feature == null) {
            return false;
        }
        Set fids = this.fids();
        String attPath = "@id";
        PropertyAccessor accessor = PropertyAccessors.findPropertyAccessor(feature, "@id", null, null);
        if (accessor == null) {
            return false;
        }
        Object id = accessor.get(feature, "@id", null);
        return fids.contains(id);
    }

    public String toString() {
        StringBuffer fidFilter = new StringBuffer();
        Iterator fidIterator = this.fids.iterator();
        while (fidIterator.hasNext()) {
            fidFilter.append(fidIterator.next().toString());
            if (!fidIterator.hasNext()) continue;
            fidFilter.append(", ");
        }
        return "[ " + fidFilter.toString() + " ]";
    }

    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit((Id)((Object)this), extraData);
    }

    public boolean equals(Object filter) {
        LOGGER.finest("condition: " + filter);
        if (filter != null && filter.getClass() == this.getClass()) {
            LOGGER.finest("condition: " + ((FidFilterImpl)filter).filterType);
            if (((FidFilterImpl)filter).filterType == 22) {
                return ((Object)this.fids).equals(((FidFilterImpl)filter).fids);
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.fids).hashCode();
    }
}

