/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTReader;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.Stack;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureType;
import org.geotools.filter.BBoxExpressionImpl;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterTransformer;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.parser.ExpressionException;
import org.geotools.filter.parser.ExpressionParser;
import org.geotools.filter.parser.ExpressionParserTreeConstants;
import org.geotools.filter.parser.Node;
import org.geotools.filter.parser.ParseException;
import org.geotools.filter.parser.Token;
import org.geotools.filter.parser.TokenMgrError;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.BinaryExpression;
import org.opengis.filter.expression.Literal;

public class ExpressionBuilder {
    private org.opengis.filter.FilterFactory factory;
    static /* synthetic */ Class class$org$opengis$filter$expression$Add;
    static /* synthetic */ Class class$org$opengis$filter$expression$Subtract;
    static /* synthetic */ Class class$org$opengis$filter$expression$Divide;
    static /* synthetic */ Class class$org$opengis$filter$expression$Multiply;
    static /* synthetic */ Class class$org$opengis$filter$Or;
    static /* synthetic */ Class class$org$opengis$filter$And;
    static /* synthetic */ Class class$org$opengis$filter$PropertyIsLessThanOrEqualTo;
    static /* synthetic */ Class class$org$opengis$filter$PropertyIsLessThan;
    static /* synthetic */ Class class$org$opengis$filter$PropertyIsGreaterThanOrEqualTo;
    static /* synthetic */ Class class$org$opengis$filter$PropertyIsGreaterThan;
    static /* synthetic */ Class class$org$opengis$filter$PropertyIsEqualTo;
    static /* synthetic */ Class class$org$opengis$filter$PropertyIsNotEqualTo;
    static /* synthetic */ Class class$org$geotools$filter$AbstractFilter;

    public ExpressionBuilder() {
        this(CommonFactoryFinder.getFilterFactory(null));
    }

    public ExpressionBuilder(org.opengis.filter.FilterFactory factory) {
        this.factory = factory;
    }

    public void setFilterFactory(org.opengis.filter.FilterFactory factory) {
        this.factory = factory;
    }

    public static Object parse(FeatureType schema, String input) throws ParseException {
        ExpressionBuilder builder = new ExpressionBuilder();
        return builder.parser(schema, input);
    }

    public Object parser(FeatureType schema, String input) throws ParseException {
        ExpressionCompiler c = new ExpressionCompiler(schema, input);
        try {
            c.CompilationUnit();
        }
        catch (TokenMgrError tme) {
            throw new ExpressionException(tme.getMessage(), c.getToken(0));
        }
        if (c.exception != null) {
            throw c.exception;
        }
        StackItem item = (StackItem)c.stack.peek();
        return item.built;
    }

    public static Object parse(String input) throws ParseException {
        return ExpressionBuilder.parse(null, input);
    }

    public Object parser(String input) throws ParseException {
        return this.parser(null, input);
    }

    public static String getFormattedErrorMessage(ParseException pe, String input) {
        StringBuffer sb = new StringBuffer(input);
        sb.append('\n');
        Token t = pe.currentToken;
        while (t.next != null) {
            t = t.next;
        }
        int column = t.beginColumn - 1;
        for (int i = 0; i < column; ++i) {
            sb.append(' ');
        }
        sb.append('^').append('\n');
        sb.append(pe.getMessage());
        return sb.toString();
    }

    public static final void main(String[] args) throws Exception {
        System.out.println("Expression Tester");
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        FilterTransformer t = new FilterTransformer();
        t.setIndentation(4);
        while (true) {
            System.out.print("> ");
            String line = r.readLine();
            if (line.equals("quit")) break;
            try {
                Object b = ExpressionBuilder.parse(line);
                t.transform(b, System.out);
                System.out.println();
            }
            catch (ParseException pe) {
                System.out.println(ExpressionBuilder.getFormattedErrorMessage(pe, line));
            }
        }
    }

    static class StackItem {
        Object built;
        Token token;

        StackItem(Object b, Token t) {
            this.built = b;
            this.token = t;
        }
    }

    class ExpressionCompiler
    extends ExpressionParser
    implements ExpressionParserTreeConstants {
        Stack stack;
        ExpressionException exception;
        String input;
        FeatureType schema;
        WKTReader reader;

        ExpressionCompiler(FeatureType schema, String input) {
            super(new StringReader(input));
            this.stack = new Stack();
            this.exception = null;
            this.input = input;
            this.schema = schema;
        }

        StackItem popStack() {
            return (StackItem)this.stack.pop();
        }

        org.opengis.filter.expression.Expression expression() throws ExpressionException {
            StackItem item = null;
            try {
                item = this.popStack();
                return (org.opengis.filter.expression.Expression)item.built;
            }
            catch (ClassCastException cce) {
                throw new ExpressionException("Expecting Expression, but found Filter", item.token);
            }
            catch (EmptyStackException ese) {
                throw new ExpressionException("No items on stack", this.getToken(0));
            }
        }

        Filter filter() throws ExpressionException {
            StackItem item = null;
            try {
                item = this.popStack();
                return (Filter)item.built;
            }
            catch (ClassCastException cce) {
                throw new ExpressionException("Expecting Filter, but found Expression", item.token);
            }
            catch (EmptyStackException ese) {
                throw new ExpressionException("No items on stack", this.getToken(0));
            }
        }

        double doubleValue() throws ExpressionException {
            try {
                return ((Number)this.expression().evaluate(null)).doubleValue();
            }
            catch (ClassCastException cce) {
                throw new ExpressionException("Expected double", this.getToken(0));
            }
        }

        int intValue() throws ExpressionException {
            try {
                return ((Number)this.expression().evaluate(null)).intValue();
            }
            catch (ClassCastException cce) {
                throw new ExpressionException("Expected int", this.getToken(0));
            }
        }

        String stringValue() throws ExpressionException {
            return this.expression().evaluate(null).toString();
        }

        public void jjtreeOpenNodeScope(Node n) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void jjtreeCloseNodeScope(Node n) throws ParseException {
            try {
                Object built = this.buildObject(n);
                if (built == null) {
                    throw new RuntimeException("INTERNAL ERROR : Node " + n + " resulted in null build");
                }
                this.stack.push(new StackItem(built, this.getToken(0)));
            }
            finally {
                n.dispose();
            }
        }

        String token() {
            return this.getToken((int)0).image;
        }

        /*
         * WARNING - void declaration
         */
        org.opengis.filter.expression.Expression mathExpression(Class type) throws ExpressionException {
            try {
                void var4_5;
                BinaryExpression e;
                org.opengis.filter.expression.Expression right = this.expression();
                org.opengis.filter.expression.Expression left = this.expression();
                if ((class$org$opengis$filter$expression$Add == null ? (class$org$opengis$filter$expression$Add = ExpressionBuilder.class$("org.opengis.filter.expression.Add")) : class$org$opengis$filter$expression$Add) == type) {
                    e = ExpressionBuilder.this.factory.add(left, right);
                } else if ((class$org$opengis$filter$expression$Subtract == null ? (class$org$opengis$filter$expression$Subtract = ExpressionBuilder.class$("org.opengis.filter.expression.Subtract")) : class$org$opengis$filter$expression$Subtract) == type) {
                    e = ExpressionBuilder.this.factory.subtract(left, right);
                } else if ((class$org$opengis$filter$expression$Divide == null ? (class$org$opengis$filter$expression$Divide = ExpressionBuilder.class$("org.opengis.filter.expression.Divide")) : class$org$opengis$filter$expression$Divide) == type) {
                    e = ExpressionBuilder.this.factory.divide(left, right);
                } else if ((class$org$opengis$filter$expression$Multiply == null ? (class$org$opengis$filter$expression$Multiply = ExpressionBuilder.class$("org.opengis.filter.expression.Multiply")) : class$org$opengis$filter$expression$Multiply) == type) {
                    e = ExpressionBuilder.this.factory.multiply(left, right);
                } else {
                    throw new IllegalArgumentException();
                }
                return var4_5;
            }
            catch (IllegalFilterException ife) {
                throw new ExpressionException("Exception building MathExpression", this.getToken(0), ife);
            }
        }

        Filter logicFilter(Class type) throws ExpressionException {
            try {
                Filter right = this.filter();
                Filter left = this.filter();
                if ((class$org$opengis$filter$Or == null ? (class$org$opengis$filter$Or = ExpressionBuilder.class$("org.opengis.filter.Or")) : class$org$opengis$filter$Or) == type) {
                    return ExpressionBuilder.this.factory.or(left, right);
                }
                if ((class$org$opengis$filter$And == null ? (class$org$opengis$filter$And = ExpressionBuilder.class$("org.opengis.filter.And")) : class$org$opengis$filter$And) == type) {
                    return ExpressionBuilder.this.factory.and(left, right);
                }
                throw new IllegalArgumentException();
            }
            catch (IllegalFilterException ife) {
                throw new ExpressionException("Exception building LogicFilter", this.getToken(0), ife);
            }
        }

        /*
         * WARNING - void declaration
         */
        Filter compareFilter(Class type) throws ExpressionException {
            try {
                void var4_5;
                BinaryComparisonOperator f;
                org.opengis.filter.expression.Expression right = this.expression();
                org.opengis.filter.expression.Expression left = this.expression();
                if ((class$org$opengis$filter$PropertyIsLessThanOrEqualTo == null ? (class$org$opengis$filter$PropertyIsLessThanOrEqualTo = ExpressionBuilder.class$("org.opengis.filter.PropertyIsLessThanOrEqualTo")) : class$org$opengis$filter$PropertyIsLessThanOrEqualTo) == type) {
                    f = ExpressionBuilder.this.factory.lessOrEqual(left, right);
                } else if ((class$org$opengis$filter$PropertyIsLessThan == null ? (class$org$opengis$filter$PropertyIsLessThan = ExpressionBuilder.class$("org.opengis.filter.PropertyIsLessThan")) : class$org$opengis$filter$PropertyIsLessThan) == type) {
                    f = ExpressionBuilder.this.factory.less(left, right);
                } else if ((class$org$opengis$filter$PropertyIsGreaterThanOrEqualTo == null ? (class$org$opengis$filter$PropertyIsGreaterThanOrEqualTo = ExpressionBuilder.class$("org.opengis.filter.PropertyIsGreaterThanOrEqualTo")) : class$org$opengis$filter$PropertyIsGreaterThanOrEqualTo) == type) {
                    f = ExpressionBuilder.this.factory.greaterOrEqual(left, right);
                } else if ((class$org$opengis$filter$PropertyIsGreaterThan == null ? (class$org$opengis$filter$PropertyIsGreaterThan = ExpressionBuilder.class$("org.opengis.filter.PropertyIsGreaterThan")) : class$org$opengis$filter$PropertyIsGreaterThan) == type) {
                    f = ExpressionBuilder.this.factory.greater(left, right);
                } else if ((class$org$opengis$filter$PropertyIsEqualTo == null ? (class$org$opengis$filter$PropertyIsEqualTo = ExpressionBuilder.class$("org.opengis.filter.PropertyIsEqualTo")) : class$org$opengis$filter$PropertyIsEqualTo) == type) {
                    f = ExpressionBuilder.this.factory.equals(left, right);
                } else if ((class$org$opengis$filter$PropertyIsNotEqualTo == null ? (class$org$opengis$filter$PropertyIsNotEqualTo = ExpressionBuilder.class$("org.opengis.filter.PropertyIsNotEqualTo")) : class$org$opengis$filter$PropertyIsNotEqualTo) == type) {
                    f = ExpressionBuilder.this.factory.notEqual(left, right, false);
                } else {
                    throw new IllegalArgumentException();
                }
                return var4_5;
            }
            catch (IllegalFilterException ife) {
                throw new ExpressionException("Exception building CompareFilter", this.getToken(0), ife);
            }
        }

        Filter betweenFilter() throws ExpressionException {
            try {
                org.opengis.filter.expression.Expression right = this.expression();
                org.opengis.filter.expression.Expression middle = this.expression();
                org.opengis.filter.expression.Expression left = this.expression();
                PropertyIsBetween f = ExpressionBuilder.this.factory.between(middle, left, right);
                return f;
            }
            catch (IllegalFilterException ife) {
                throw new ExpressionException("Exception building CompareFilter", this.getToken(0), ife);
            }
        }

        Object buildObject(Node n) throws ExpressionException {
            switch (n.getType()) {
                case 16: {
                    return ExpressionBuilder.this.factory.literal(Integer.parseInt(this.token()));
                }
                case 17: {
                    return ExpressionBuilder.this.factory.literal(Double.parseDouble(this.token()));
                }
                case 20: {
                    return ExpressionBuilder.this.factory.literal(n.getToken().image);
                }
                case 15: {
                    try {
                        String attName = this.token();
                        if (this.schema != null && null == this.schema.getAttributeType(attName)) {
                            throw new IllegalArgumentException(attName + " not found in schema");
                        }
                        return ExpressionBuilder.this.factory.property(attName);
                    }
                    catch (IllegalFilterException ife) {
                        throw new ExpressionException("Exception building AttributeExpression", this.getToken(0), ife);
                    }
                }
                case 21: {
                    return this.parseFunction(n);
                }
                case 10: {
                    return this.mathExpression(class$org$opengis$filter$expression$Add == null ? (class$org$opengis$filter$expression$Add = ExpressionBuilder.class$("org.opengis.filter.expression.Add")) : class$org$opengis$filter$expression$Add);
                }
                case 11: {
                    return this.mathExpression(class$org$opengis$filter$expression$Subtract == null ? (class$org$opengis$filter$expression$Subtract = ExpressionBuilder.class$("org.opengis.filter.expression.Subtract")) : class$org$opengis$filter$expression$Subtract);
                }
                case 12: {
                    return this.mathExpression(class$org$opengis$filter$expression$Multiply == null ? (class$org$opengis$filter$expression$Multiply = ExpressionBuilder.class$("org.opengis.filter.expression.Multiply")) : class$org$opengis$filter$expression$Multiply);
                }
                case 13: {
                    return this.mathExpression(class$org$opengis$filter$expression$Divide == null ? (class$org$opengis$filter$expression$Divide = ExpressionBuilder.class$("org.opengis.filter.expression.Divide")) : class$org$opengis$filter$expression$Divide);
                }
                case 1: {
                    return this.logicFilter(class$org$opengis$filter$Or == null ? (class$org$opengis$filter$Or = ExpressionBuilder.class$("org.opengis.filter.Or")) : class$org$opengis$filter$Or);
                }
                case 2: {
                    return this.logicFilter(class$org$opengis$filter$And == null ? (class$org$opengis$filter$And = ExpressionBuilder.class$("org.opengis.filter.And")) : class$org$opengis$filter$And);
                }
                case 14: {
                    return ExpressionBuilder.this.factory.not(this.filter());
                }
                case 5: {
                    return this.betweenFilter();
                }
                case 8: {
                    return this.compareFilter(class$org$opengis$filter$PropertyIsLessThanOrEqualTo == null ? (class$org$opengis$filter$PropertyIsLessThanOrEqualTo = ExpressionBuilder.class$("org.opengis.filter.PropertyIsLessThanOrEqualTo")) : class$org$opengis$filter$PropertyIsLessThanOrEqualTo);
                }
                case 6: {
                    return this.compareFilter(class$org$opengis$filter$PropertyIsLessThan == null ? (class$org$opengis$filter$PropertyIsLessThan = ExpressionBuilder.class$("org.opengis.filter.PropertyIsLessThan")) : class$org$opengis$filter$PropertyIsLessThan);
                }
                case 9: {
                    return this.compareFilter(class$org$opengis$filter$PropertyIsGreaterThanOrEqualTo == null ? (class$org$opengis$filter$PropertyIsGreaterThanOrEqualTo = ExpressionBuilder.class$("org.opengis.filter.PropertyIsGreaterThanOrEqualTo")) : class$org$opengis$filter$PropertyIsGreaterThanOrEqualTo);
                }
                case 7: {
                    return this.compareFilter(class$org$opengis$filter$PropertyIsGreaterThan == null ? (class$org$opengis$filter$PropertyIsGreaterThan = ExpressionBuilder.class$("org.opengis.filter.PropertyIsGreaterThan")) : class$org$opengis$filter$PropertyIsGreaterThan);
                }
                case 3: {
                    return this.compareFilter(class$org$opengis$filter$PropertyIsEqualTo == null ? (class$org$opengis$filter$PropertyIsEqualTo = ExpressionBuilder.class$("org.opengis.filter.PropertyIsEqualTo")) : class$org$opengis$filter$PropertyIsEqualTo);
                }
                case 4: {
                    return this.compareFilter(class$org$opengis$filter$PropertyIsNotEqualTo == null ? (class$org$opengis$filter$PropertyIsNotEqualTo = ExpressionBuilder.class$("org.opengis.filter.PropertyIsNotEqualTo")) : class$org$opengis$filter$PropertyIsNotEqualTo);
                }
                case 22: {
                    Token end = n.getToken();
                    while (end.next != null) {
                        end = end.next;
                    }
                    return this.geometry(n.getToken(), end);
                }
                case 18: 
                case 19: {
                    throw new ExpressionException("Unsupported syntax", this.getToken(0));
                }
            }
            return null;
        }

        Literal geometry(Token start, Token end) throws ExpressionException {
            if (this.reader == null) {
                this.reader = new WKTReader();
            }
            try {
                Geometry g = this.reader.read(this.input.substring(start.beginColumn - 1, end.endColumn));
                return ExpressionBuilder.this.factory.literal(g);
            }
            catch (com.vividsolutions.jts.io.ParseException e) {
                throw new ExpressionException(e.getMessage(), start);
            }
            catch (Exception e) {
                throw new ExpressionException("Error building WKT Geometry", start, e);
            }
        }

        Object parseFunction(Node n) throws ExpressionException {
            String function = n.getToken().image;
            if ("box".equalsIgnoreCase(function)) {
                if (n.jjtGetNumChildren() != 4) {
                    throw new ExpressionException("Bounding Box filter requires 4 arguments", this.getToken(0));
                }
                double d4 = this.doubleValue();
                double d3 = this.doubleValue();
                double d2 = this.doubleValue();
                double d1 = this.doubleValue();
                try {
                    return new BBoxExpressionImpl(new Envelope(d1, d2, d3, d4));
                }
                catch (IllegalFilterException ife) {
                    throw new ExpressionException("Exception building BBoxExpression", this.getToken(0), ife);
                }
            }
            if ("id".equalsIgnoreCase(function)) {
                if (n.jjtGetNumChildren() != 1) {
                    throw new ExpressionException("Feature ID filter requires 1 argument", this.getToken(0));
                }
                return ExpressionBuilder.this.factory.id(Collections.singleton(ExpressionBuilder.this.factory.featureId(this.stringValue())));
            }
            if ("between".equalsIgnoreCase(function)) {
                if (n.jjtGetNumChildren() != 3) {
                    throw new ExpressionException("Between filter requires 3 arguments", this.getToken(0));
                }
                org.opengis.filter.expression.Expression two = this.expression();
                org.opengis.filter.expression.Expression att = this.expression();
                org.opengis.filter.expression.Expression one = this.expression();
                try {
                    PropertyIsBetween b = ExpressionBuilder.this.factory.between(att, one, two);
                    return b;
                }
                catch (IllegalFilterException ife) {
                    throw new ExpressionException("Exception building BetweenFilter", this.getToken(0), ife);
                }
            }
            if ("like".equalsIgnoreCase(function)) {
                if (n.jjtGetNumChildren() != 2) {
                    throw new ExpressionException("Like filter requires at least two arguments", this.getToken(0));
                }
                String pattern = this.stringValue();
                org.opengis.filter.expression.Expression expr = this.expression();
                try {
                    PropertyIsLike f = ExpressionBuilder.this.factory.like(expr, pattern, "*", ".?", "//");
                    return f;
                }
                catch (IllegalFilterException ife) {
                    throw new ExpressionException("Exception building LikeFilter", this.getToken(0), ife);
                }
            }
            if ("null".equalsIgnoreCase(function) || "isNull".equalsIgnoreCase(function)) {
                org.opengis.filter.expression.Expression e = this.expression();
                try {
                    if (e instanceof Literal) {
                        e = ExpressionBuilder.this.factory.property(((Literal)e).evaluate(null).toString());
                    }
                    PropertyIsNull nf = ExpressionBuilder.this.factory.isNull(e);
                    return nf;
                }
                catch (IllegalFilterException ife) {
                    throw new ExpressionException("Exception building NullFilter", this.getToken(0), ife);
                }
            }
            short geometryFilterType = this.lookupGeometryFilter(function);
            if (geometryFilterType >= 0) {
                return this.buildGeometryFilter(geometryFilterType);
            }
            FilterFactory f = (FilterFactory)ExpressionBuilder.this.factory;
            FunctionExpression func = f.createFunctionExpression(function);
            if (func == null) {
                throw new ExpressionException("Could not build function : " + function, this.getToken(0));
            }
            int nArgs = func.getArgCount();
            if (n.jjtGetNumChildren() != nArgs) {
                throw new ExpressionException(function + " function requires " + nArgs + " arguments", this.getToken(0));
            }
            org.opengis.filter.expression.Expression[] args = new org.opengis.filter.expression.Expression[func.getArgCount()];
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.expression();
            }
            func.setParameters(Arrays.asList(args));
            return func;
        }

        short lookupGeometryFilter(String name) {
            Field[] f = (class$org$geotools$filter$AbstractFilter == null ? (class$org$geotools$filter$AbstractFilter = ExpressionBuilder.class$("org.geotools.filter.AbstractFilter")) : class$org$geotools$filter$AbstractFilter).getFields();
            name = name.toUpperCase();
            int ii = f.length;
            for (int i = 0; i < ii; ++i) {
                if (!f[i].getName().endsWith(name)) continue;
                try {
                    return f[i].getShort(null);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return -1;
        }

        GeometryFilter buildGeometryFilter(short type) throws ExpressionException {
            org.opengis.filter.expression.Expression right = this.expression();
            org.opengis.filter.expression.Expression left = this.expression();
            try {
                FilterFactory ff = (FilterFactory)ExpressionBuilder.this.factory;
                GeometryFilter f = ff.createGeometryFilter(type);
                f.addLeftGeometry((Expression)left);
                f.addRightGeometry((Expression)right);
                return f;
            }
            catch (IllegalFilterException ife) {
                throw new ExpressionException("Exception building GeometryFilter", this.getToken(0), ife);
            }
        }
    }
}

