/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.AverageVisitor;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.CalcUtil;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.filter.IllegalFilterException;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

public class SumVisitor
implements FeatureCalc {
    private Expression expr;
    SumStrategy strategy;

    public SumVisitor(int attributeTypeIndex, FeatureType type) throws IllegalFilterException {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        AttributeType attributeType = type.getAttributeType(attributeTypeIndex);
        this.expr = factory.property(attributeType.getName());
        SumVisitor.createStrategy(attributeType.getType());
    }

    public SumVisitor(String attrName, FeatureType type) throws IllegalFilterException {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        AttributeType attributeType = type.getAttributeType(attrName);
        this.expr = factory.property(attributeType.getName());
        SumVisitor.createStrategy(attributeType.getType());
    }

    public SumVisitor(Expression expr) throws IllegalFilterException {
        this.expr = expr;
    }

    private static SumStrategy createStrategy(Class type) {
        if (type == Integer.class) {
            return new IntegerSumStrategy();
        }
        if (type == Double.class) {
            return new DoubleSumStrategy();
        }
        if (type == Long.class) {
            return new LongSumStrategy();
        }
        if (type == Float.class) {
            return new FloatSumStrategy();
        }
        return null;
    }

    public void visit(Feature feature) {
        Object value = this.expr.evaluate(feature);
        if (this.strategy == null) {
            this.strategy = SumVisitor.createStrategy(value.getClass());
        }
        this.strategy.add(value);
    }

    public Expression getExpression() {
        return this.expr;
    }

    public Object getSum() {
        return this.strategy.getResult();
    }

    public void setValue(Object newSum) {
        this.strategy = SumVisitor.createStrategy(newSum.getClass());
        this.strategy.add(newSum);
    }

    public void reset() {
        this.strategy = null;
    }

    public CalcResult getResult() {
        return new SumResult(this.strategy);
    }

    public static class SumResult
    extends AbstractCalcResult {
        private SumStrategy sum;

        public SumResult(SumStrategy newSum) {
            this.sum = newSum;
        }

        public Object getValue() {
            return this.sum.getResult();
        }

        public boolean isCompatible(CalcResult targetResults) {
            if (targetResults instanceof SumResult) {
                return true;
            }
            return targetResults instanceof CountVisitor.CountResult;
        }

        public CalcResult merge(CalcResult resultsToAdd) {
            if (!this.isCompatible(resultsToAdd)) {
                throw new IllegalArgumentException("Parameter is not a compatible type");
            }
            if (resultsToAdd instanceof SumResult) {
                Object[] sums = new Number[]{(Number)this.sum.getResult(), (Number)resultsToAdd.getValue()};
                SumStrategy newSum = SumVisitor.createStrategy(CalcUtil.getObject(sums).getClass());
                newSum.add(sums[0]);
                newSum.add(sums[1]);
                return new SumResult(newSum);
            }
            if (resultsToAdd instanceof CountVisitor.CountResult) {
                int count = resultsToAdd.toInt();
                AverageVisitor.AverageResult newResult = new AverageVisitor.AverageResult(count, this.sum.getResult());
                return newResult;
            }
            throw new IllegalArgumentException("The CalcResults claim to be compatible, but the appropriate merge method has not been implemented.");
        }
    }

    static class IntegerSumStrategy
    implements SumStrategy {
        int number = 0;

        IntegerSumStrategy() {
        }

        public void add(Object value) {
            this.number += ((Number)value).intValue();
        }

        public Object getResult() {
            return new Integer(this.number);
        }
    }

    static class LongSumStrategy
    implements SumStrategy {
        long number = 0L;

        LongSumStrategy() {
        }

        public void add(Object value) {
            this.number += ((Number)value).longValue();
        }

        public Object getResult() {
            return new Long(this.number);
        }
    }

    static class FloatSumStrategy
    implements SumStrategy {
        float number = 0.0f;

        FloatSumStrategy() {
        }

        public void add(Object value) {
            this.number += ((Number)value).floatValue();
        }

        public Object getResult() {
            return new Float(this.number);
        }
    }

    static class DoubleSumStrategy
    implements SumStrategy {
        double number = 0.0;

        DoubleSumStrategy() {
        }

        public void add(Object value) {
            this.number += ((Number)value).doubleValue();
        }

        public Object getResult() {
            return new Double(this.number);
        }
    }

    static interface SumStrategy {
        public void add(Object var1);

        public Object getResult();
    }
}

