/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.CalcUtil;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.filter.IllegalFilterException;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

public class MedianVisitor
implements FeatureCalc {
    private Expression expr;
    private List list = new ArrayList();
    private Object median = null;

    public MedianVisitor(String attributeTypeName) {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        this.expr = factory.property(attributeTypeName);
    }

    public MedianVisitor(int attributeTypeIndex, FeatureType type) throws IllegalFilterException {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        this.expr = factory.property(type.getAttributeType(attributeTypeIndex).getName());
    }

    public MedianVisitor(String attrName, FeatureType type) throws IllegalFilterException {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        this.expr = factory.property(type.getAttributeType(attrName).getName());
    }

    public MedianVisitor(Expression expr) throws IllegalFilterException {
        this.expr = expr;
    }

    public void visit(Feature feature) {
        Object result = this.expr.evaluate(feature);
        if (!(result instanceof Comparable)) {
            throw new IllegalStateException("Expression is not comparable!");
        }
        Comparable value = (Comparable)result;
        this.list.add(value);
    }

    public Expression getExpression() {
        return this.expr;
    }

    public Object getMedian() {
        if (this.median != null) {
            return this.median;
        }
        Object newMedian = MedianVisitor.findMedian(this.list);
        if (newMedian == null) {
            throw new IllegalStateException("Must visit before median value is ready!");
        }
        return newMedian;
    }

    public void reset() {
        this.list.clear();
        this.median = null;
    }

    public CalcResult getResult() {
        if (this.median != null) {
            return new MedianResult(this.median);
        }
        if (this.list.size() < 1) {
            return null;
        }
        return new MedianResult(this.list);
    }

    public void setValue(List list) {
        this.reset();
        this.list = list;
    }

    public void setValue(Comparable median) {
        this.reset();
        this.median = median;
    }

    private static Object findMedian(List list) {
        Object median;
        if (list.size() < 1) {
            return null;
        }
        Collections.sort(list);
        int index = -1;
        index = list.size() / 2;
        if (list.size() % 2 == 0) {
            Object input1 = list.get(index - 1);
            Object input2 = list.get(index);
            if (input1 instanceof Number && input2 instanceof Number) {
                Number num1 = (Number)input1;
                Number num2 = (Number)input2;
                Number[] numbers = new Number[]{num1, num2};
                median = CalcUtil.average(numbers);
            } else {
                ArrayList newList = new ArrayList();
                newList.add(input1);
                newList.add(input2);
                median = newList;
            }
        } else {
            median = list.get(index);
        }
        return median;
    }

    public static class MedianResult
    extends AbstractCalcResult {
        private List list;
        private Object median;

        public MedianResult(List newList) {
            this.list = newList;
            this.median = null;
        }

        public MedianResult(Object median) {
            this.list = null;
            this.median = median;
        }

        public List getList() {
            return this.list;
        }

        public Object getValue() {
            if (this.median != null) {
                return this.median;
            }
            return MedianVisitor.findMedian(this.list);
        }

        public boolean isCompatible(CalcResult targetResults) {
            return targetResults instanceof MedianResult;
        }

        public boolean isOptimized() {
            return this.median != null;
        }

        public CalcResult merge(CalcResult resultsToAdd) {
            if (!this.isCompatible(resultsToAdd)) {
                throw new IllegalArgumentException("Parameter is not a compatible type");
            }
            if (resultsToAdd instanceof MedianResult) {
                MedianResult moreResults = (MedianResult)resultsToAdd;
                if (this.isOptimized() || moreResults.isOptimized()) {
                    throw new IllegalArgumentException("Optimized median results cannot be merged.");
                }
                ArrayList toAdd = (ArrayList)moreResults.getList();
                ArrayList<Comparable> newList = new ArrayList<Comparable>();
                int size = this.list.size() + toAdd.size();
                Object[] values = new Object[size];
                for (int i = 0; i < this.list.size(); ++i) {
                    values[i] = this.list.get(i);
                }
                for (int j = 0; j < toAdd.size(); ++j) {
                    values[i + j] = toAdd.get(j);
                }
                Class bestClass = CalcUtil.bestClass(values);
                for (int k = 0; k < size; ++k) {
                    if (values[k].getClass() != bestClass) {
                        values[k] = CalcUtil.convert(values[k], bestClass);
                    }
                    newList.add((Comparable)values[k]);
                }
                return new MedianResult(newList);
            }
            throw new IllegalArgumentException("The CalcResults claim to be compatible, but the appropriate merge method has not been implemented.");
        }
    }
}

