/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.CalcUtil;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.filter.IllegalFilterException;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

public class AverageVisitor
implements FeatureCalc {
    private Expression expr;
    private boolean isOptimized = false;
    AverageStrategy strategy;

    public AverageVisitor(int attributeTypeIndex, FeatureType type) throws IllegalFilterException {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        AttributeType attributeType = type.getAttributeType(attributeTypeIndex);
        this.expr = factory.property(attributeType.getName());
        AverageVisitor.createStrategy(attributeType.getType());
    }

    public AverageVisitor(String attrName, FeatureType type) throws IllegalFilterException {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        AttributeType attributeType = type.getAttributeType(attrName);
        this.expr = factory.property(attributeType.getName());
        AverageVisitor.createStrategy(attributeType.getType());
    }

    public AverageVisitor(Expression expr) throws IllegalFilterException {
        this.expr = expr;
    }

    private static AverageStrategy createStrategy(Class type) {
        if (type == Integer.class) {
            return new IntegerAverageStrategy();
        }
        if (type == Double.class) {
            return new DoubleAverageStrategy();
        }
        if (type == Long.class) {
            return new LongAverageStrategy();
        }
        if (type == Float.class) {
            return new FloatAverageStrategy();
        }
        return null;
    }

    public void visit(Feature feature) {
        Object value = this.expr.evaluate(feature);
        if (this.strategy == null) {
            Class<?> type = value.getClass();
            this.strategy = AverageVisitor.createStrategy(type);
        }
        this.strategy.add(value);
    }

    public Expression getExpression() {
        return this.expr;
    }

    public Object getAverage() {
        return this.strategy.getResult();
    }

    public void reset() {
        this.strategy = null;
        this.isOptimized = false;
    }

    public CalcResult getResult() {
        return new AverageResult(this.strategy, this.isOptimized);
    }

    public void setValue(Object newAverage) {
        this.reset();
        Class<?> type = newAverage.getClass();
        this.strategy = AverageVisitor.createStrategy(type);
        this.strategy.add(newAverage);
        this.isOptimized = true;
    }

    public void setValue(int newCount, Object newSum) {
        this.reset();
        this.strategy = AverageVisitor.createStrategy(newSum.getClass());
        this.strategy.set(newCount, newSum);
        this.isOptimized = false;
    }

    public static class AverageResult
    extends AbstractCalcResult {
        private AverageStrategy averageStrategy;
        private boolean isOptimized = false;

        public AverageResult(Object newAverageStrategy) {
            this.averageStrategy = (AverageStrategy)newAverageStrategy;
        }

        public AverageResult(Object newAverageStrategy, boolean isOptimized) {
            this.averageStrategy = (AverageStrategy)newAverageStrategy;
            this.isOptimized = isOptimized;
        }

        public AverageResult(int newCount, Object newSum) {
            this.averageStrategy = AverageVisitor.createStrategy(newSum.getClass());
            this.averageStrategy.set(newCount, newSum);
        }

        public Object getResult() {
            return this.averageStrategy.getResult();
        }

        public Object getValue() {
            return this.averageStrategy.getResult();
        }

        public int getCount() {
            if (this.isOptimized) {
                return -1;
            }
            return this.averageStrategy.getCount();
        }

        public Object getSum() {
            if (this.isOptimized) {
                return null;
            }
            return this.averageStrategy.getSum();
        }

        public boolean isCompatible(CalcResult targetResults) {
            return targetResults instanceof AverageResult;
        }

        public CalcResult merge(CalcResult resultsToAdd) {
            if (!this.isCompatible(resultsToAdd)) {
                throw new IllegalArgumentException("Parameter is not a compatible type");
            }
            if (resultsToAdd instanceof AverageResult) {
                AverageResult moreResults = (AverageResult)resultsToAdd;
                if (this.isOptimized || moreResults.isOptimized) {
                    throw new IllegalArgumentException("Optimized average results cannot be merged.");
                }
                Number[] sums = new Number[]{(Number)this.averageStrategy.getSum(), (Number)moreResults.averageStrategy.getSum()};
                Number newSum = CalcUtil.sum(sums);
                Integer newCount = new Integer(this.averageStrategy.getCount() + moreResults.averageStrategy.getCount());
                Object[] params = new Number[]{newSum, newCount};
                Object newAverage = CalcUtil.getObject(params);
                AverageStrategy newAverageObj = AverageVisitor.createStrategy(newAverage.getClass());
                newAverageObj.set(newCount, newSum);
                return new AverageResult(newAverageObj);
            }
            throw new IllegalArgumentException("The CalcResults claim to be compatible, but the appropriate merge method has not been implemented.");
        }
    }

    static class IntegerAverageStrategy
    implements AverageStrategy {
        int number = 0;
        int count = 0;

        IntegerAverageStrategy() {
        }

        public void add(Object value) {
            this.number += ((Number)value).intValue();
            ++this.count;
        }

        public Object getResult() {
            return new Double((double)this.number / (double)this.count);
        }

        public Object getSum() {
            return new Integer(this.number);
        }

        public int getCount() {
            return this.count;
        }

        public void set(int newCount, Object sum) {
            this.number = ((Number)sum).intValue();
            this.count = newCount;
        }
    }

    static class LongAverageStrategy
    implements AverageStrategy {
        long number = 0L;
        int count = 0;

        LongAverageStrategy() {
        }

        public void add(Object value) {
            this.number += ((Number)value).longValue();
            ++this.count;
        }

        public Object getResult() {
            return new Double((double)this.number / (double)this.count);
        }

        public Object getSum() {
            return new Long(this.number);
        }

        public int getCount() {
            return this.count;
        }

        public void set(int newCount, Object sum) {
            this.number = ((Number)sum).longValue();
            this.count = newCount;
        }
    }

    static class FloatAverageStrategy
    implements AverageStrategy {
        float number = 0.0f;
        int count = 0;

        FloatAverageStrategy() {
        }

        public void add(Object value) {
            this.number += ((Number)value).floatValue();
            ++this.count;
        }

        public Object getResult() {
            return new Float(this.number / (float)this.count);
        }

        public Object getSum() {
            return new Float(this.number);
        }

        public int getCount() {
            return this.count;
        }

        public void set(int newCount, Object sum) {
            this.number = ((Number)sum).floatValue();
            this.count = newCount;
        }
    }

    static class DoubleAverageStrategy
    implements AverageStrategy {
        double number = 0.0;
        int count = 0;

        DoubleAverageStrategy() {
        }

        public void add(Object value) {
            this.number += ((Number)value).doubleValue();
            ++this.count;
        }

        public Object getResult() {
            return new Double(this.number / (double)this.count);
        }

        public Object getSum() {
            return new Double(this.number);
        }

        public int getCount() {
            return this.count;
        }

        public void set(int newCount, Object sum) {
            this.number = ((Number)sum).doubleValue();
            this.count = newCount;
        }
    }

    static interface AverageStrategy {
        public void add(Object var1);

        public Object getResult();

        public Object getSum();

        public int getCount();

        public void set(int var1, Object var2);
    }
}

