/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.geotools.feature.DefaultAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.PrimativeAttributeType;
import org.geotools.util.Converters;
import org.opengis.filter.Filter;

public class TemporalAttributeType
extends DefaultAttributeType
implements PrimativeAttributeType {
    static DateFormat format = DateFormat.getInstance();
    private Filter filter;

    public TemporalAttributeType(String name, boolean nillable, int min, int max, Object defaultValue, Filter filter) {
        super(name, Date.class, nillable, min, max, defaultValue);
        this.filter = filter;
    }

    public TemporalAttributeType(String name, Class type, boolean nillable, int min, int max, Object defaultValue, Filter filter) {
        super(name, type, nillable, min, max, defaultValue);
        this.filter = filter;
    }

    public Object parse(Object value) throws IllegalArgumentException {
        if (value == null) {
            return value;
        }
        if (this.type.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        Object converted = Converters.convert(value, this.type);
        if (converted != null) {
            return converted;
        }
        try {
            return format.parse(value.toString());
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("unable to parse " + value + " as Date");
        }
    }

    public Object duplicate(Object o) throws IllegalAttributeException {
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            Date d = (Date)o;
            return new Date(d.getTime());
        }
        throw new IllegalAttributeException("Cannot duplicate " + o.getClass().getName());
    }

    public Filter getRestriction() {
        return this.filter;
    }
}

