/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.HashSet;
import java.util.Set;
import org.geotools.feature.AttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.opengis.filter.Filter;

public class SetAttributeType
implements AttributeType {
    private final boolean nill;
    private final int min;
    private final int max;
    private final String name;
    private final AttributeType[] children;
    private Filter restriction;

    public SetAttributeType(SetAttributeType copy) {
        this.nill = copy.isNillable();
        this.min = copy.getMinOccurs();
        this.max = copy.getMaxOccurs();
        this.name = copy.getName();
        this.children = copy.getAttributeTypes();
        this.restriction = copy.getRestriction();
    }

    public SetAttributeType(String name, boolean nillable, int min, int max, AttributeType[] children, Filter restriction) {
        this.nill = nillable;
        this.min = min;
        this.max = max;
        this.name = name;
        this.children = children;
        this.restriction = restriction;
    }

    public SetAttributeType(String name, boolean nillable, AttributeType[] children) {
        this(name, nillable, 1, 1, children, Filter.EXCLUDE);
    }

    public Filter getRestriction() {
        return this.restriction;
    }

    public String getName() {
        return this.getLocalName();
    }

    public String getLocalName() {
        return this.name;
    }

    public final Class getType() {
        return this.getBinding();
    }

    public Class getBinding() {
        return Set.class;
    }

    public boolean isNillable() {
        return this.nill;
    }

    public int getMinOccurs() {
        return this.min;
    }

    public int getMaxOccurs() {
        return this.max;
    }

    public boolean isGeometry() {
        return false;
    }

    public Object parse(Object value) throws IllegalArgumentException {
        if (value instanceof Set) {
            Object[] in = ((Set)value).toArray();
            HashSet<Object> out = new HashSet<Object>(in.length);
            if (in.length == this.children.length) {
                for (int i = 0; i < this.children.length; ++i) {
                    out.add(this.children[i].parse(in[i]));
                }
                return out;
            }
            throw new IllegalArgumentException("Expected " + this.children.length + " Objects, got " + in.length + " Objects");
        }
        throw new IllegalArgumentException("Not an Object []");
    }

    public void validate(Object obj) throws IllegalArgumentException {
        if (obj instanceof Set) {
            Object[] in = ((Set)obj).toArray();
            if (in.length == this.children.length) {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].validate(in[i]);
                }
                return;
            }
            throw new IllegalArgumentException("Expected " + this.children.length + " Objects, got " + in.length + " Objects");
        }
        throw new IllegalArgumentException("Not an Object []");
    }

    public Object duplicate(Object src) throws IllegalAttributeException {
        if (src instanceof Set) {
            Object[] in = ((Set)src).toArray();
            HashSet<Object> out = new HashSet<Object>(in.length);
            if (in.length == this.children.length) {
                for (int i = 0; i < this.children.length; ++i) {
                    out.add(this.children[i].duplicate(in[i]));
                }
                return out;
            }
            throw new IllegalArgumentException("Expected " + this.children.length + " Objects, got " + in.length + " Objects");
        }
        throw new IllegalArgumentException("Not an Object []");
    }

    public Object createDefaultValue() {
        HashSet<Object> out = new HashSet<Object>(this.children.length);
        for (int i = 0; i < this.children.length; ++i) {
            out.add(this.children[i].createDefaultValue());
        }
        return out;
    }

    public boolean hasAttributeType(String xPath) {
        return this.getAttributeType(xPath) != null;
    }

    public int getAttributeCount() {
        return this.children.length;
    }

    public AttributeType getAttributeType(String xPath) {
        AttributeType attType = null;
        int idx = this.find(xPath);
        if (idx >= 0) {
            attType = this.children[idx];
        }
        return attType;
    }

    public int find(AttributeType type) {
        if (type == null) {
            return -1;
        }
        int idx = this.find(type.getName());
        if (idx < 0 || !this.children[idx].equals(type)) {
            idx = -1;
        }
        return idx;
    }

    public int find(String attName) {
        int i;
        for (i = 0; i < this.children.length && !attName.equals(this.children[i].getName()); ++i) {
        }
        return i == this.children.length ? -1 : i;
    }

    public AttributeType getAttributeType(int position) {
        return this.children[position];
    }

    public AttributeType[] getAttributeTypes() {
        return (AttributeType[])this.children.clone();
    }
}

