/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.opengis.filter.Filter;

public class FeatureAttributeType
implements AttributeType {
    private final boolean nill;
    private final int min;
    private final int max;
    private final String name;
    private final FeatureType featureType;

    public FeatureAttributeType(FeatureAttributeType copy) {
        this.nill = copy.isNillable();
        this.min = copy.getMinOccurs();
        this.max = copy.getMaxOccurs();
        this.name = copy.getName();
        this.featureType = copy.getFeatureType();
    }

    public FeatureAttributeType(String name, FeatureType featureType, boolean nillable, int min, int max) {
        this.nill = nillable;
        this.min = min;
        this.max = max;
        this.name = name;
        this.featureType = featureType;
    }

    public FeatureAttributeType(String name, FeatureType featureType, boolean nillable) {
        this(name, featureType, nillable, 1, 1);
    }

    public Filter getRestriction() {
        return Filter.INCLUDE;
    }

    protected FeatureType getFeatureType() {
        return this.featureType;
    }

    public final String getName() {
        return this.getLocalName();
    }

    public String getLocalName() {
        return this.name;
    }

    public final Class getType() {
        return this.getBinding();
    }

    public Class getBinding() {
        return Feature.class;
    }

    public boolean isNillable() {
        return this.nill;
    }

    public int getMinOccurs() {
        return this.min;
    }

    public int getMaxOccurs() {
        return this.max;
    }

    public boolean isGeometry() {
        return false;
    }

    public Object parse(Object value) throws IllegalArgumentException {
        if (value instanceof Feature) {
            return value;
        }
        if (value instanceof Object[]) {
            try {
                return this.featureType.create((Object[])value);
            }
            catch (IllegalAttributeException e) {
                IllegalArgumentException ee = new IllegalArgumentException(e.getMessage());
                ee.initCause(e);
                throw ee;
            }
        }
        throw new IllegalArgumentException(this.getName() + " needs to parse an array of Objects");
    }

    public void validate(Object obj) throws IllegalArgumentException {
        if (obj instanceof Feature) {
            try {
                this.featureType.duplicate((Feature)obj);
                return;
            }
            catch (IllegalAttributeException e) {
                IllegalArgumentException ee = new IllegalArgumentException(e.getMessage());
                ee.initCause(e);
                throw ee;
            }
        }
        throw new IllegalArgumentException("Not a Feature");
    }

    public Object duplicate(Object src) throws IllegalAttributeException {
        if (src instanceof Feature) {
            return this.featureType.duplicate((Feature)src);
        }
        throw new IllegalArgumentException("Not an Object []");
    }

    public Object createDefaultValue() {
        Object[] t = new Object[this.featureType.getAttributeCount()];
        for (int i = 0; i < t.length; ++i) {
            t[i] = null;
        }
        try {
            return this.featureType.create(t);
        }
        catch (IllegalAttributeException e) {
            return null;
        }
    }

    public boolean hasAttributeType(String xPath) {
        return this.getAttributeType(xPath) != null;
    }

    public int getAttributeCount() {
        return this.featureType.getAttributeCount();
    }

    public AttributeType getAttributeType(String xPath) {
        return this.featureType.getAttributeType(xPath);
    }

    public int find(AttributeType type) {
        return this.featureType.find(type);
    }

    public int find(String attName) {
        return this.featureType.find(attName);
    }

    public AttributeType getAttributeType(int position) {
        return this.featureType.getAttributeType(position);
    }

    public AttributeType[] getAttributeTypes() {
        return this.featureType.getAttributeTypes();
    }
}

