/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import com.vividsolutions.jts.geom.GeometryFactory;
import java.util.Arrays;
import org.geotools.feature.AttributeType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ChoiceAttributeType
implements AttributeType {
    private final boolean nill;
    private final int min;
    private final int max;
    private final String name;
    private final AttributeType[] children;
    private Filter restriction;

    public ChoiceAttributeType(ChoiceAttributeType copy) {
        this.nill = copy.isNillable();
        this.min = copy.getMinOccurs();
        this.max = copy.getMaxOccurs();
        this.name = copy.getName();
        this.children = this.copyChildren(copy.getAttributeTypes());
        this.restriction = copy.getRestriction();
    }

    public ChoiceAttributeType(String name, int min, int max, AttributeType[] children, Filter restriction) {
        this.nill = this.calculateNillable(children);
        this.min = min;
        this.max = max;
        this.name = name;
        this.children = this.copyChildren(children);
        this.restriction = restriction;
    }

    public ChoiceAttributeType(String name, AttributeType[] children) {
        this(name, 1, 1, children, Filter.EXCLUDE);
    }

    public Filter getRestriction() {
        return this.restriction;
    }

    protected AttributeType[] copyChildren(AttributeType[] attributes) {
        int length = attributes.length;
        AttributeType[] returnArray = new AttributeType[length];
        System.arraycopy(attributes, 0, returnArray, 0, length);
        return returnArray;
    }

    public final String getName() {
        return this.getLocalName();
    }

    public String getLocalName() {
        return this.name;
    }

    public final Class getType() {
        return this.getBinding();
    }

    public Class getBinding() {
        return Object.class;
    }

    public boolean isNillable() {
        return this.nill;
    }

    public boolean calculateNillable(AttributeType[] children) {
        int ii = children.length;
        for (int i = 0; i < ii; ++i) {
            if (!children[i].isNillable()) continue;
            return true;
        }
        return false;
    }

    public int getMinOccurs() {
        return this.min;
    }

    public int getMaxOccurs() {
        return this.max;
    }

    public boolean isGeometry() {
        return false;
    }

    public Object parse(Object value) throws IllegalArgumentException {
        for (int i = 0; i < this.children.length; ++i) {
            try {
                return this.children[i].parse(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        throw new IllegalArgumentException("Could not be parsed :(");
    }

    public void validate(Object obj) throws IllegalArgumentException {
        for (int i = 0; i < this.children.length; ++i) {
            try {
                this.children[i].validate(obj);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        throw new IllegalArgumentException("Could not be validated :(");
    }

    public Object duplicate(Object src) throws IllegalAttributeException {
        for (int i = 0; i < this.children.length; ++i) {
            try {
                return this.children[i].duplicate(src);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        throw new IllegalArgumentException("Could not be duplicated :(");
    }

    public Object createDefaultValue() {
        for (int i = 0; i < this.children.length; ++i) {
            try {
                return this.children[i].createDefaultValue();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        return null;
    }

    public boolean hasAttributeType(String xPath) {
        return this.getAttributeType(xPath) != null;
    }

    public int getAttributeCount() {
        return this.children.length;
    }

    public AttributeType getAttributeType(String xPath) {
        AttributeType attType = null;
        int idx = this.find(xPath);
        if (idx >= 0) {
            attType = this.children[idx];
        }
        return attType;
    }

    public int find(AttributeType type) {
        if (type == null) {
            return -1;
        }
        int idx = this.find(type.getName());
        if (idx < 0 || !this.children[idx].equals(type)) {
            idx = -1;
        }
        return idx;
    }

    public int find(String attName) {
        int i;
        for (i = 0; i < this.children.length && !attName.equals(this.children[i].getName()); ++i) {
        }
        return i == this.children.length ? -1 : i;
    }

    public AttributeType getAttributeType(int position) {
        return this.children[position];
    }

    public AttributeType[] getAttributeTypes() {
        return (AttributeType[])this.children.clone();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof ChoiceAttributeType)) {
            return false;
        }
        ChoiceAttributeType att = (ChoiceAttributeType)other;
        if (this.name == null ? att.getName() != null : !this.name.equals(att.getName())) {
            return false;
        }
        return Arrays.equals(this.children, att.getAttributeTypes());
    }

    public int hashCode() {
        int hash = this.name.hashCode();
        int ii = this.children.length;
        for (int i = 0; i < ii; ++i) {
            hash ^= this.children[i].hashCode();
        }
        return hash;
    }

    public String toString() {
        String details = "name=" + this.name;
        details = details + " , nillable=" + this.nill + ", min=" + this.min + ", max=" + this.max;
        details = details + ", choices: " + Arrays.asList(this.children);
        return "ChoiceAttributeType [" + details + "]";
    }

    public static final class Geometric
    extends ChoiceAttributeType
    implements GeometryAttributeType {
        public Geometric(Geometric copy) {
            super(copy);
        }

        public Geometric(String name, int min, int max, GeometryAttributeType[] children, Filter restriction) {
            super(name, min, max, (AttributeType[])children, restriction);
        }

        public Geometric(String name, GeometryAttributeType[] children) {
            super(name, (AttributeType[])children);
        }

        public CoordinateReferenceSystem getCoordinateSystem() {
            GeometryAttributeType first = (GeometryAttributeType)this.getAttributeType(0);
            return first.getCoordinateSystem();
        }

        public GeometryFactory getGeometryFactory() {
            GeometryAttributeType first = (GeometryAttributeType)this.getAttributeType(0);
            return first.getGeometryFactory();
        }

        public boolean isGeometry() {
            return true;
        }
    }
}

